/*
 * Decompiled with CFR 0.152.
 */
package org.bekit.flow.flow;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.bekit.event.bus.EventBusHolder;
import org.bekit.flow.annotation.flow.Flow;
import org.bekit.flow.flow.FlowExecutor;
import org.bekit.flow.flow.FlowParser;
import org.bekit.flow.processor.ProcessorHolder;
import org.bekit.flow.transaction.FlowTxHolder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;

public class FlowHolder {
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private ProcessorHolder processorHolder;
    @Autowired
    private FlowTxHolder flowTxHolder;
    @Autowired
    private EventBusHolder eventBusHolder;
    private Map<String, FlowExecutor> flowExecutorMap = new HashMap<String, FlowExecutor>();

    @PostConstruct
    public void init() {
        String[] beanNames;
        for (String beanName : beanNames = this.applicationContext.getBeanNamesForAnnotation(Flow.class)) {
            FlowExecutor flowExecutor = FlowParser.parseFlow(this.applicationContext.getBean(beanName), this.processorHolder, this.flowTxHolder, this.eventBusHolder);
            if (this.flowExecutorMap.containsKey(flowExecutor.getFlowName())) {
                throw new RuntimeException("\u5b58\u5728\u91cd\u540d\u7684\u6d41\u7a0b" + flowExecutor.getFlowName());
            }
            this.flowExecutorMap.put(flowExecutor.getFlowName(), flowExecutor);
        }
    }

    public FlowExecutor getRequiredFlowExecutor(String flow) {
        if (!this.flowExecutorMap.containsKey(flow)) {
            throw new IllegalArgumentException("\u4e0d\u5b58\u5728\u6d41\u7a0b" + flow);
        }
        return this.flowExecutorMap.get(flow);
    }
}

