/*
 * Decompiled with CFR 0.152.
 */
package org.bekit.flow.flow;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.apache.commons.lang3.StringUtils;
import org.bekit.event.EventPublisher;
import org.bekit.event.bus.EventBusHolder;
import org.bekit.event.publisher.DefaultEventPublisher;
import org.bekit.flow.annotation.flow.EndNode;
import org.bekit.flow.annotation.flow.Flow;
import org.bekit.flow.annotation.flow.Node;
import org.bekit.flow.annotation.flow.StartNode;
import org.bekit.flow.annotation.flow.TargetMapping;
import org.bekit.flow.engine.TargetContext;
import org.bekit.flow.flow.FlowExecutor;
import org.bekit.flow.listener.FlowListenerType;
import org.bekit.flow.processor.ProcessorExecutor;
import org.bekit.flow.processor.ProcessorHolder;
import org.bekit.flow.transaction.FlowTxHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.core.ResolvableType;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.util.ClassUtils;

public class FlowParser {
    private static final Logger logger = LoggerFactory.getLogger(FlowParser.class);

    public static FlowExecutor parseFlow(Object flow, ProcessorHolder processorHolder, FlowTxHolder flowTxHolder, EventBusHolder eventBusHolder) {
        Class flowClass = AopUtils.getTargetClass((Object)flow);
        logger.debug("\u89e3\u6790\u6d41\u7a0b\uff1a{}", (Object)ClassUtils.getQualifiedName((Class)flowClass));
        Flow flowAnnotation = flowClass.getAnnotation(Flow.class);
        String flowName = flowAnnotation.name();
        if (StringUtils.isEmpty((CharSequence)flowName)) {
            flowName = ClassUtils.getShortNameAsProperty((Class)flowClass);
        }
        FlowExecutor flowExecutor = new FlowExecutor(flowName, flowAnnotation.enableFlowTx(), flow, (EventPublisher)new DefaultEventPublisher(eventBusHolder.getEventBus(FlowListenerType.class)));
        if (flowAnnotation.enableFlowTx()) {
            flowExecutor.setFlowTxExecutor(flowTxHolder.getRequiredFlowTxExecutor(flowName));
        }
        for (Method method : flowClass.getDeclaredMethods()) {
            Node nodeAnnotation = (Node)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, Node.class);
            if (nodeAnnotation != null) {
                FlowExecutor.NodeExecutor nodeExecutor = FlowParser.parseNode(nodeAnnotation, method, processorHolder);
                flowExecutor.addNode(nodeExecutor);
                if (method.isAnnotationPresent(StartNode.class)) {
                    flowExecutor.setStartNode(nodeExecutor.getNodeName());
                }
                if (!method.isAnnotationPresent(EndNode.class)) continue;
                flowExecutor.addEndNode(nodeExecutor.getNodeName());
                continue;
            }
            if (!method.isAnnotationPresent(TargetMapping.class)) continue;
            flowExecutor.setMappingExecutor(FlowParser.parseTargetMapping(method));
        }
        flowExecutor.validate();
        return flowExecutor;
    }

    private static FlowExecutor.NodeExecutor parseNode(Node nodeAnnotation, Method method, ProcessorHolder processorHolder) {
        logger.debug("\u89e3\u6790\u6d41\u7a0b\u8282\u70b9\uff1anode={}\uff0cmethod={}", (Object)nodeAnnotation, (Object)method);
        String nodeName = nodeAnnotation.name();
        if (StringUtils.isEmpty((CharSequence)nodeName)) {
            nodeName = method.getName();
        }
        ProcessorExecutor processorExecutor = null;
        if (StringUtils.isNotEmpty((CharSequence)nodeAnnotation.processor())) {
            processorExecutor = processorHolder.getRequiredProcessorExecutor(nodeAnnotation.processor());
        }
        FlowExecutor.NodeExecutor nodeExecutor = new FlowExecutor.NodeExecutor(nodeName, processorExecutor, nodeAnnotation.autoExecute(), nodeAnnotation.newTx());
        nodeExecutor.setNodeDeciderExecutor(FlowParser.parseNodeDecider(method, processorExecutor));
        nodeExecutor.validate();
        return nodeExecutor;
    }

    private static FlowExecutor.NodeExecutor.NodeDeciderExecutor parseNodeDecider(Method method, ProcessorExecutor processorExecutor) {
        FlowExecutor.NodeExecutor.NodeDeciderExecutor.ParametersType parametersType;
        logger.debug("\u89e3\u6790\u8282\u70b9\u51b3\u7b56\u5668\uff1a{}", (Object)method);
        if (!Modifier.isPublic(method.getModifiers())) {
            throw new IllegalArgumentException("\u89e3\u6790\u8282\u70b9\u51b3\u7b56\u5668" + ClassUtils.getQualifiedMethodName((Method)method) + "\u5fc5\u987b\u662fpublic\u7c7b\u578b");
        }
        Class classOfTarget = null;
        Class<?>[] parameterTypes = method.getParameterTypes();
        if (parameterTypes.length == 0) {
            parametersType = FlowExecutor.NodeExecutor.NodeDeciderExecutor.ParametersType.NONE;
        } else {
            if (method.isAnnotationPresent(EndNode.class)) {
                throw new IllegalArgumentException("\u7ed3\u675f\u8282\u70b9\u7684\u51b3\u7b56\u5668" + ClassUtils.getQualifiedMethodName((Method)method) + "\u4e0d\u80fd\u6709\u5165\u53c2");
            }
            if (parameterTypes.length == 1) {
                if (parameterTypes[0] == TargetContext.class) {
                    parametersType = FlowExecutor.NodeExecutor.NodeDeciderExecutor.ParametersType.ONLY_TARGET_CONTEXT;
                    ResolvableType resolvableType = ResolvableType.forMethodParameter((Method)method, (int)0);
                    classOfTarget = resolvableType.getGeneric(new int[]{0}).resolve(Object.class);
                } else {
                    if (processorExecutor == null) {
                        throw new IllegalArgumentException("\u8282\u70b9\u51b3\u7b56\u5668" + ClassUtils.getQualifiedMethodName((Method)method) + "\u4e0d\u80fd\u6709\u975eTargetContext\u5165\u53c2\uff0c\u56e0\u4e3a\u8fd9\u4e2a\u8282\u70b9\u6ca1\u6709\u5904\u7406\u5668");
                    }
                    if (!parameterTypes[0].isAssignableFrom(processorExecutor.getReturnType())) {
                        throw new IllegalArgumentException("\u8282\u70b9\u51b3\u7b56\u5668" + ClassUtils.getQualifiedMethodName((Method)method) + "\u7684\u975eTargetContext\u5165\u53c2\u7c7b\u578b\u5fc5\u987b\u80fd\u88ab\u5176\u5904\u7406\u5668\u8fd4\u56de\u7c7b\u578b\u8d4b\u503c");
                    }
                    parametersType = FlowExecutor.NodeExecutor.NodeDeciderExecutor.ParametersType.ONLY_PROCESS_RESULT;
                }
            } else if (parameterTypes.length == 2) {
                if (processorExecutor == null) {
                    throw new IllegalArgumentException("\u8282\u70b9\u51b3\u7b56\u5668" + ClassUtils.getQualifiedMethodName((Method)method) + "\u4e0d\u80fd\u6709\u975eTargetContext\u5165\u53c2\uff0c\u56e0\u4e3a\u8fd9\u4e2a\u8282\u70b9\u6ca1\u6709\u5904\u7406\u5668");
                }
                if (!parameterTypes[0].isAssignableFrom(processorExecutor.getReturnType())) {
                    throw new IllegalArgumentException("\u8282\u70b9\u51b3\u7b56\u5668" + ClassUtils.getQualifiedMethodName((Method)method) + "\u7684\u975eTargetContext\u5165\u53c2\u7c7b\u578b\u5fc5\u987b\u80fd\u88ab\u5176\u5904\u7406\u5668\u8fd4\u56de\u7c7b\u578b\u8d4b\u503c");
                }
                if (parameterTypes[1] != TargetContext.class) {
                    throw new IllegalArgumentException("\u8282\u70b9\u51b3\u7b56\u5668" + ClassUtils.getQualifiedMethodName((Method)method) + "\u7684\u7b2c\u4e8c\u4e2a\u53c2\u6570\u7c7b\u578b\u5fc5\u987b\u662fTargetContext");
                }
                parametersType = FlowExecutor.NodeExecutor.NodeDeciderExecutor.ParametersType.PROCESS_RESULT_AND_TARGET_CONTEXT;
                ResolvableType resolvableType = ResolvableType.forMethodParameter((Method)method, (int)1);
                classOfTarget = resolvableType.getGeneric(new int[]{0}).resolve(Object.class);
            } else {
                throw new IllegalArgumentException("\u8282\u70b9\u51b3\u7b56\u5668" + ClassUtils.getQualifiedMethodName((Method)method) + "\u7684\u5165\u53c2\u4e2a\u6570\u4e0d\u80fd\u8d85\u8fc72\u4e2a");
            }
        }
        if (method.isAnnotationPresent(EndNode.class)) {
            if (method.getReturnType() != Void.TYPE) {
                throw new IllegalArgumentException("\u7ed3\u675f\u8282\u70b9\u7684\u8282\u70b9\u51b3\u7b56\u5668" + ClassUtils.getQualifiedMethodName((Method)method) + "\u7684\u8fd4\u56de\u7c7b\u578b\u5fc5\u987b\u662fvoid");
            }
        } else if (method.getReturnType() != String.class) {
            throw new IllegalArgumentException("\u8282\u70b9\u51b3\u7b56\u5668" + ClassUtils.getQualifiedMethodName((Method)method) + "\u7684\u8fd4\u56de\u7c7b\u578b\u5fc5\u987b\u662fString");
        }
        return new FlowExecutor.NodeExecutor.NodeDeciderExecutor(method, parametersType, classOfTarget);
    }

    private static FlowExecutor.TargetMappingExecutor parseTargetMapping(Method method) {
        logger.debug("\u89e3\u6790\u76ee\u6807\u5bf9\u8c61\u6620\u5c04\u65b9\u6cd5\uff1a{}", (Object)method);
        if (!Modifier.isPublic(method.getModifiers())) {
            throw new IllegalArgumentException("\u76ee\u6807\u5bf9\u8c61\u6620\u5c04\u65b9\u6cd5" + ClassUtils.getQualifiedMethodName((Method)method) + "\u5fc5\u987b\u662fpublic\u7c7b\u578b");
        }
        Class<?>[] parameterTypes = method.getParameterTypes();
        if (parameterTypes.length != 1) {
            throw new IllegalArgumentException("\u76ee\u6807\u5bf9\u8c61\u6620\u5c04\u65b9\u6cd5" + ClassUtils.getQualifiedMethodName((Method)method) + "\u5fc5\u987b\u53ea\u80fd\u6709\u4e00\u4e2a\u5165\u53c2");
        }
        if (method.getReturnType() != String.class) {
            throw new IllegalArgumentException("\u76ee\u6807\u5bf9\u8c61\u6620\u5c04\u65b9\u6cd5" + ClassUtils.getQualifiedMethodName((Method)method) + "\u8fd4\u56de\u53c2\u6570\u5fc5\u987b\u662fString\u7c7b\u578b");
        }
        return new FlowExecutor.TargetMappingExecutor(method, parameterTypes[0]);
    }
}

