/*
 * Decompiled with CFR 0.152.
 */
package org.bekit.flow.processor;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.bekit.common.method.MethodExecutor;
import org.bekit.flow.annotation.processor.ProcessorAfter;
import org.bekit.flow.annotation.processor.ProcessorBefore;
import org.bekit.flow.annotation.processor.ProcessorEnd;
import org.bekit.flow.annotation.processor.ProcessorError;
import org.bekit.flow.annotation.processor.ProcessorExecute;
import org.bekit.flow.engine.TargetContext;
import org.springframework.util.ClassUtils;

public class ProcessorExecutor {
    public static final Class[] PROCESSOR_METHOD_ANNOTATIONS = new Class[]{ProcessorBefore.class, ProcessorExecute.class, ProcessorAfter.class, ProcessorEnd.class, ProcessorError.class};
    private String processorName;
    private Object processor;
    private Map<Class, ProcessorMethodExecutor> methodExecutorMap = new HashMap<Class, ProcessorMethodExecutor>();

    public ProcessorExecutor(String processorName, Object processor) {
        this.processorName = processorName;
        this.processor = processor;
    }

    public Object execute(TargetContext targetContext) throws Throwable {
        try {
            this.executeMethod(ProcessorBefore.class, targetContext);
            Object result = this.executeMethod(ProcessorExecute.class, targetContext);
            this.executeMethod(ProcessorAfter.class, targetContext);
            Object object = result;
            return object;
        }
        catch (Throwable e) {
            this.executeMethod(ProcessorError.class, targetContext);
            throw e;
        }
        finally {
            this.executeMethod(ProcessorEnd.class, targetContext);
        }
    }

    private Object executeMethod(Class clazz, TargetContext targetContext) throws Throwable {
        ProcessorMethodExecutor methodExecutor = this.methodExecutorMap.get(clazz);
        if (methodExecutor == null) {
            return null;
        }
        return methodExecutor.execute(this.processor, targetContext);
    }

    public void setMethodExecutor(Class clazz, ProcessorMethodExecutor methodExecutor) {
        if (!Arrays.asList(PROCESSOR_METHOD_ANNOTATIONS).contains(clazz)) {
            throw new IllegalArgumentException(ClassUtils.getShortName((Class)clazz) + "\u4e0d\u662f\u5904\u7406\u5668\u65b9\u6cd5\u6ce8\u89e3");
        }
        if (this.methodExecutorMap.containsKey(clazz)) {
            throw new IllegalStateException("\u5904\u7406\u5668" + this.processorName + "\u5b58\u5728\u591a\u4e2a@" + ClassUtils.getShortName((Class)clazz) + "\u7c7b\u578b\u7684\u65b9\u6cd5");
        }
        this.methodExecutorMap.put(clazz, methodExecutor);
    }

    public Class getReturnType() {
        return this.methodExecutorMap.get(ProcessorExecute.class).getReturnType();
    }

    public Class getClassOfTarget() {
        return this.methodExecutorMap.get(ProcessorExecute.class).getClassOfTarget();
    }

    public String getProcessorName() {
        return this.processorName;
    }

    public void validate() {
        if (this.processorName == null || this.processor == null) {
            throw new IllegalStateException("\u5904\u7406\u5668" + this.processorName + "\u5185\u90e8\u8981\u7d20\u4e0d\u5168");
        }
        if (!this.methodExecutorMap.containsKey(ProcessorExecute.class)) {
            throw new IllegalStateException("\u5904\u7406\u5668" + this.processorName + "\u4e0d\u5b58\u5728@ProcessorExecute\u7c7b\u578b\u7684\u5904\u7406\u5668\u65b9\u6cd5");
        }
        for (ProcessorMethodExecutor methodExecutor : this.methodExecutorMap.values()) {
            if (methodExecutor.getClassOfTarget() == this.getClassOfTarget()) continue;
            throw new IllegalStateException("\u5904\u7406\u5668" + this.processorName + "\u5185\u76ee\u6807\u5bf9\u8c61\u7c7b\u578b\u4e0d\u7edf\u4e00");
        }
    }

    public static class ProcessorMethodExecutor
    extends MethodExecutor {
        private Class classOfTarget;

        public ProcessorMethodExecutor(Method targetMethod, Class classOfTarget) {
            super(targetMethod);
            this.classOfTarget = classOfTarget;
        }

        public Object execute(Object processor, TargetContext targetContext) throws Throwable {
            return this.execute(processor, new Object[]{targetContext});
        }

        public Class getClassOfTarget() {
            return this.classOfTarget;
        }
    }
}

