/*
 * Decompiled with CFR 0.152.
 */
package org.bekit.flow.processor;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.apache.commons.lang3.StringUtils;
import org.bekit.flow.annotation.processor.Processor;
import org.bekit.flow.annotation.processor.ProcessorExecute;
import org.bekit.flow.engine.TargetContext;
import org.bekit.flow.processor.ProcessorExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.core.ResolvableType;
import org.springframework.util.ClassUtils;

public class ProcessorParser {
    private static final Logger logger = LoggerFactory.getLogger(ProcessorParser.class);

    public static ProcessorExecutor parseProcessor(Object processor) {
        Class processorClass = AopUtils.getTargetClass((Object)processor);
        logger.debug("\u89e3\u6790\u5904\u7406\u5668\uff1a{}", (Object)ClassUtils.getQualifiedName((Class)processorClass));
        String processorName = processorClass.getAnnotation(Processor.class).name();
        if (StringUtils.isEmpty((CharSequence)processorName)) {
            processorName = ClassUtils.getShortNameAsProperty((Class)processorClass);
        }
        ProcessorExecutor processorExecutor = new ProcessorExecutor(processorName, processor);
        block0: for (Method method : processorClass.getDeclaredMethods()) {
            for (Class clazz : ProcessorExecutor.PROCESSOR_METHOD_ANNOTATIONS) {
                if (!method.isAnnotationPresent(clazz)) continue;
                processorExecutor.setMethodExecutor(clazz, ProcessorParser.parseProcessorMethod(clazz, method));
                continue block0;
            }
        }
        processorExecutor.validate();
        return processorExecutor;
    }

    private static ProcessorExecutor.ProcessorMethodExecutor parseProcessorMethod(Class clazz, Method method) {
        logger.debug("\u89e3\u6790\u5904\u7406\u5668\u65b9\u6cd5\uff1a{}", (Object)method);
        if (!Modifier.isPublic(method.getModifiers())) {
            throw new IllegalArgumentException("\u5904\u7406\u5668\u65b9\u6cd5" + ClassUtils.getQualifiedMethodName((Method)method) + "\u5fc5\u987b\u662fpublic\u7c7b\u578b");
        }
        Class<?>[] parameterTypes = method.getParameterTypes();
        if (parameterTypes.length != 1) {
            throw new IllegalArgumentException("\u5904\u7406\u5668\u65b9\u6cd5" + ClassUtils.getQualifiedMethodName((Method)method) + "\u5165\u53c2\u5fc5\u987b\u662f\uff08TargetContext\uff09");
        }
        if (parameterTypes[0] != TargetContext.class) {
            throw new IllegalArgumentException("\u5904\u7406\u5668\u65b9\u6cd5" + ClassUtils.getQualifiedMethodName((Method)method) + "\u5165\u53c2\u5fc5\u987b\u662f\uff08TargetContext\uff09");
        }
        if (clazz != ProcessorExecute.class && method.getReturnType() != Void.TYPE) {
            throw new IllegalArgumentException("\u975e@ProcessorExecute\u7c7b\u578b\u7684\u5904\u7406\u5668\u65b9\u6cd5" + ClassUtils.getQualifiedMethodName((Method)method) + "\u7684\u8fd4\u56de\u7c7b\u578b\u5fc5\u987b\u662fvoid");
        }
        ResolvableType resolvableType = ResolvableType.forMethodParameter((Method)method, (int)0);
        Class classOfTarget = resolvableType.getGeneric(new int[]{0}).resolve(Object.class);
        return new ProcessorExecutor.ProcessorMethodExecutor(method, classOfTarget);
    }
}

