/*
 * Decompiled with CFR 0.152.
 */
package org.bekit.flow.flow;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import org.bekit.event.bus.EventBusesHolder;
import org.bekit.flow.annotation.flow.Flow;
import org.bekit.flow.flow.FlowExecutor;
import org.bekit.flow.flow.FlowParser;
import org.bekit.flow.processor.ProcessorsHolder;
import org.bekit.flow.transaction.FlowTxsHolder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Component
public class FlowsHolder {
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private ProcessorsHolder processorsHolder;
    @Autowired
    private FlowTxsHolder flowTxsHolder;
    @Autowired
    private EventBusesHolder eventBusesHolder;
    private Map<String, FlowExecutor> flowExecutorMap = new HashMap<String, FlowExecutor>();

    @PostConstruct
    public void init() {
        String[] beanNames;
        for (String beanName : beanNames = this.applicationContext.getBeanNamesForAnnotation(Flow.class)) {
            FlowExecutor flowExecutor = FlowParser.parseFlow(this.applicationContext.getBean(beanName), this.processorsHolder, this.flowTxsHolder, this.eventBusesHolder);
            if (this.flowExecutorMap.containsKey(flowExecutor.getFlowName())) {
                throw new RuntimeException("\u5b58\u5728\u91cd\u540d\u7684\u6d41\u7a0b" + flowExecutor.getFlowName());
            }
            this.flowExecutorMap.put(flowExecutor.getFlowName(), flowExecutor);
        }
    }

    public Set<String> getFlowNames() {
        return this.flowExecutorMap.keySet();
    }

    public FlowExecutor getRequiredFlowExecutor(String flow) {
        if (!this.flowExecutorMap.containsKey(flow)) {
            throw new IllegalArgumentException("\u4e0d\u5b58\u5728\u6d41\u7a0b" + flow);
        }
        return this.flowExecutorMap.get(flow);
    }
}

