/*
 * Decompiled with CFR 0.152.
 */
package org.bekit.flow.processor;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import org.bekit.flow.annotation.processor.Processor;
import org.bekit.flow.processor.ProcessorExecutor;
import org.bekit.flow.processor.ProcessorParser;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Component
public class ProcessorsHolder {
    @Autowired
    private ApplicationContext applicationContext;
    private Map<String, ProcessorExecutor> processorExecutorMap = new HashMap<String, ProcessorExecutor>();

    @PostConstruct
    public void init() {
        String[] beanNames;
        for (String beanName : beanNames = this.applicationContext.getBeanNamesForAnnotation(Processor.class)) {
            ProcessorExecutor processorExecutor = ProcessorParser.parseProcessor(this.applicationContext.getBean(beanName));
            if (this.processorExecutorMap.containsKey(processorExecutor.getProcessorName())) {
                throw new RuntimeException("\u5b58\u5728\u91cd\u540d\u7684\u5904\u7406\u5668\uff1a" + processorExecutor.getProcessorName());
            }
            this.processorExecutorMap.put(processorExecutor.getProcessorName(), processorExecutor);
        }
    }

    public Set<String> getProcessorNames() {
        return this.processorExecutorMap.keySet();
    }

    public ProcessorExecutor getRequiredProcessorExecutor(String processor) {
        if (!this.processorExecutorMap.containsKey(processor)) {
            throw new IllegalArgumentException("\u4e0d\u5b58\u5728\u5904\u7406\u5668\uff1a" + processor);
        }
        return this.processorExecutorMap.get(processor);
    }
}

