/*
 * Decompiled with CFR 0.152.
 */
package org.bekit.flow.transaction;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.bekit.common.method.MethodExecutor;
import org.bekit.common.transaction.TxExecutor;
import org.bekit.flow.annotation.transaction.InsertTarget;
import org.bekit.flow.annotation.transaction.LockTarget;
import org.bekit.flow.engine.TargetContext;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.util.ClassUtils;

public class FlowTxExecutor
extends TxExecutor {
    public static final Class[] FLOW_TX_OPERATE_ANNOTATIONS = new Class[]{LockTarget.class, InsertTarget.class};
    private String flow;
    private Object flowTx;
    private Map<Class, FlowTxOperateExecutor> operateExecutorMap = new HashMap<Class, FlowTxOperateExecutor>();

    public FlowTxExecutor(String flow, Object flowTx, PlatformTransactionManager transactionManager) {
        super(transactionManager);
        this.flow = flow;
        this.flowTx = flowTx;
    }

    public void lockTarget(TargetContext targetContext) throws Throwable {
        FlowTxOperateExecutor operateExecutor = this.operateExecutorMap.get(LockTarget.class);
        if (operateExecutor == null) {
            throw new IllegalStateException("\u6d41\u7a0b\u4e8b\u52a1" + ClassUtils.getShortName(this.flowTx.getClass()) + "\u4e0d\u5b58\u5728@LockTarget\u7c7b\u578b\u64cd\u4f5c");
        }
        targetContext.refreshTarget(operateExecutor.execute(this.flowTx, targetContext));
    }

    public void insertTarget(TargetContext targetContext) throws Throwable {
        this.createTx();
        try {
            FlowTxOperateExecutor operateExecutor = this.operateExecutorMap.get(InsertTarget.class);
            if (operateExecutor == null) {
                throw new IllegalStateException("\u6d41\u7a0b\u4e8b\u52a1" + ClassUtils.getShortName(this.flowTx.getClass()) + "\u4e0d\u5b58\u5728@InsertTarget\u7c7b\u578b\u64cd\u4f5c");
            }
            targetContext.refreshTarget(operateExecutor.execute(this.flowTx, targetContext));
            this.commitTx();
        }
        catch (Throwable e) {
            this.rollbackTx();
            throw e;
        }
    }

    public void setOperateExecutor(Class clazz, FlowTxOperateExecutor operateExecutor) {
        if (!Arrays.asList(FLOW_TX_OPERATE_ANNOTATIONS).contains(clazz)) {
            throw new IllegalArgumentException(ClassUtils.getShortName((Class)clazz) + "\u4e0d\u662f\u6d41\u7a0b\u4e8b\u52a1\u64cd\u4f5c\u6ce8\u89e3");
        }
        if (this.operateExecutorMap.containsKey(clazz)) {
            throw new IllegalStateException("\u6d41\u7a0b\u4e8b\u52a1" + ClassUtils.getShortName(this.flowTx.getClass()) + "\u5b58\u5728\u591a\u4e2a@" + ClassUtils.getShortName((Class)clazz) + "\u7c7b\u578b\u7684\u64cd\u4f5c");
        }
        this.operateExecutorMap.put(clazz, operateExecutor);
    }

    public String getFlow() {
        return this.flow;
    }

    public Object getFlowTx() {
        return this.flowTx;
    }

    public Class getClassOfTarget() {
        return this.operateExecutorMap.get(LockTarget.class).getClassOfTarget();
    }

    public void validate() {
        super.validate();
        if (this.flow == null || this.flowTx == null) {
            throw new IllegalStateException("\u6d41\u7a0b\u4e8b\u52a1" + ClassUtils.getShortName(this.flowTx.getClass()) + "\u5185\u90e8\u8981\u7d20\u4e0d\u5168");
        }
        if (!this.operateExecutorMap.containsKey(LockTarget.class)) {
            throw new IllegalStateException("\u6d41\u7a0b\u4e8b\u52a1" + ClassUtils.getShortName(this.flowTx.getClass()) + "\u4e0d\u5b58\u5728@LockTarget\u7c7b\u578b\u64cd\u4f5c");
        }
        for (FlowTxOperateExecutor operateExecutor : this.operateExecutorMap.values()) {
            if (operateExecutor.getClassOfTarget() == this.getClassOfTarget()) continue;
            throw new IllegalStateException("\u6d41\u7a0b\u4e8b\u52a1" + ClassUtils.getShortName(this.flowTx.getClass()) + "\u5185\u76ee\u6807\u5bf9\u8c61\u7c7b\u578b\u4e0d\u7edf\u4e00");
        }
    }

    public static class FlowTxOperateExecutor
    extends MethodExecutor {
        private Class classOfTarget;

        public FlowTxOperateExecutor(Method targetMethod, Class classOfTarget) {
            super(targetMethod);
            this.classOfTarget = classOfTarget;
        }

        public Object execute(Object flowTx, TargetContext targetContext) throws Throwable {
            return this.execute(flowTx, new Object[]{targetContext});
        }

        public Class getClassOfTarget() {
            return this.classOfTarget;
        }
    }
}

