/*
 * Decompiled with CFR 0.152.
 */
package org.bekit.flow.transaction;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import org.bekit.flow.annotation.transaction.FlowTx;
import org.bekit.flow.transaction.FlowTxExecutor;
import org.bekit.flow.transaction.FlowTxParser;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;
import org.springframework.transaction.PlatformTransactionManager;

@Component
public class FlowTxsHolder {
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired(required=false)
    private PlatformTransactionManager transactionManager;
    private Map<String, FlowTxExecutor> flowTxExecutorMap = new HashMap<String, FlowTxExecutor>();

    @PostConstruct
    public void init() {
        String[] beanNames = this.applicationContext.getBeanNamesForAnnotation(FlowTx.class);
        if (beanNames.length > 0 && this.transactionManager == null) {
            throw new RuntimeException("\u5b58\u5728\u6d41\u7a0b\u4e8b\u52a1\u4f46\u662f\u4e0d\u5b58\u5728\u4e8b\u52a1\u7ba1\u7406\u5668\uff08PlatformTransactionManager\uff09\uff0c\u8bf7\u68c0\u67e5\u662f\u5426\u6709\u914d\u7f6espring\u4e8b\u52a1\u7ba1\u7406\u5668");
        }
        for (String beanName : beanNames) {
            FlowTxExecutor flowTxExecutor = FlowTxParser.parseFlowTx(this.applicationContext.getBean(beanName), this.transactionManager);
            if (this.flowTxExecutorMap.containsKey(flowTxExecutor.getFlow())) {
                throw new RuntimeException("\u6d41\u7a0b" + flowTxExecutor.getFlow() + "\u5b58\u5728\u591a\u4e2a\u6d41\u7a0b\u4e8b\u52a1");
            }
            this.flowTxExecutorMap.put(flowTxExecutor.getFlow(), flowTxExecutor);
        }
    }

    public Set<String> getFlowNames() {
        return this.flowTxExecutorMap.keySet();
    }

    public FlowTxExecutor getRequiredFlowTxExecutor(String flow) {
        if (!this.flowTxExecutorMap.containsKey(flow)) {
            throw new IllegalArgumentException("\u4e0d\u5b58\u5728\u6d41\u7a0b" + flow + "\u7684\u6d41\u7a0b\u4e8b\u52a1");
        }
        return this.flowTxExecutorMap.get(flow);
    }
}

