/*
 * Decompiled with CFR 0.152.
 */
package org.bekit.flow.engine;

import java.util.Map;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.bekit.flow.FlowEngine;
import org.bekit.flow.engine.TargetContext;
import org.bekit.flow.flow.FlowExecutor;
import org.bekit.flow.flow.FlowsHolder;
import org.bekit.flow.transaction.FlowTxExecutor;
import org.bekit.flow.transaction.FlowTxsHolder;
import org.springframework.util.ClassUtils;

public class DefaultFlowEngine
implements FlowEngine {
    private final FlowsHolder flowsHolder;
    private final FlowTxsHolder flowTxsHolder;

    public DefaultFlowEngine(FlowsHolder flowsHolder, FlowTxsHolder flowTxsHolder) {
        this.flowsHolder = flowsHolder;
        this.flowTxsHolder = flowTxsHolder;
    }

    @Override
    public <T> T start(String flow, T target) {
        return this.start(flow, target, null);
    }

    @Override
    public <T> T start(String flow, T target, Map<Object, Object> attachment) {
        this.checkClassOfTarget(target, flow);
        TargetContext<T> targetContext = new TargetContext<T>(target, attachment);
        this.executeFlow(flow, targetContext);
        return targetContext.getTarget();
    }

    @Override
    public <T> T insertTarget(String flow, T target, Map<Object, Object> attachment) {
        this.checkClassOfTarget(target, flow);
        TargetContext<T> targetContext = new TargetContext<T>(target, attachment);
        this.executeInsertTarget(flow, targetContext);
        return targetContext.getTarget();
    }

    @Override
    public <T> T insertTargetAndStart(String flow, T target, Map<Object, Object> attachment) {
        this.checkClassOfTarget(target, flow);
        TargetContext<T> targetContext = new TargetContext<T>(target, attachment);
        this.executeInsertTarget(flow, targetContext);
        this.executeFlow(flow, targetContext);
        return targetContext.getTarget();
    }

    private void checkClassOfTarget(Object target, String flow) {
        FlowExecutor flowExecutor = this.flowsHolder.getRequiredFlowExecutor(flow);
        if (!flowExecutor.getClassOfTarget().isAssignableFrom(target.getClass())) {
            throw new IllegalArgumentException(String.format("\u4f20\u5165\u7684\u76ee\u6807\u5bf9\u8c61\u7684\u7c7b\u578b[%s]\u548c\u6d41\u7a0b%s\u671f\u671b\u7684\u7c7b\u578b[%s]\u4e0d\u5339\u914d", ClassUtils.getShortName(target.getClass()), flowExecutor.getFlowName(), ClassUtils.getShortName((Class)flowExecutor.getClassOfTarget())));
        }
    }

    private void executeInsertTarget(String flow, TargetContext targetContext) {
        try {
            FlowTxExecutor flowTxExecutor = this.flowTxsHolder.getRequiredFlowTxExecutor(flow);
            flowTxExecutor.insertTarget(targetContext);
        }
        catch (Throwable e) {
            ExceptionUtils.rethrow((Throwable)e);
        }
    }

    private void executeFlow(String flow, TargetContext targetContext) {
        try {
            FlowExecutor flowExecutor = this.flowsHolder.getRequiredFlowExecutor(flow);
            flowExecutor.execute(targetContext);
        }
        catch (Throwable e) {
            ExceptionUtils.rethrow((Throwable)e);
        }
    }
}

