/*
 * Decompiled with CFR 0.152.
 */
package org.bekit.flow.transaction;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.bekit.flow.annotation.transaction.FlowTx;
import org.bekit.flow.engine.TargetContext;
import org.bekit.flow.transaction.FlowTxExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.core.ResolvableType;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.util.ClassUtils;

public class FlowTxParser {
    private static final Logger logger = LoggerFactory.getLogger(FlowTxParser.class);

    public static FlowTxExecutor parseFlowTx(Object flowTx, PlatformTransactionManager transactionManager) {
        Class flowTxClass = AopUtils.getTargetClass((Object)flowTx);
        logger.debug("\u89e3\u6790\u6d41\u7a0b\u4e8b\u52a1\uff1a{}", (Object)ClassUtils.getQualifiedName((Class)flowTxClass));
        FlowTx flowTxAnnotation = flowTxClass.getAnnotation(FlowTx.class);
        FlowTxExecutor flowTxExecutor = new FlowTxExecutor(flowTxAnnotation.flow(), flowTx, transactionManager);
        block0: for (Method method : flowTxClass.getDeclaredMethods()) {
            for (Class clazz : FlowTxExecutor.FLOW_TX_OPERATE_ANNOTATIONS) {
                if (!method.isAnnotationPresent(clazz)) continue;
                flowTxExecutor.setOperateExecutor(clazz, FlowTxParser.parseFlowTxOperate(method));
                continue block0;
            }
        }
        flowTxExecutor.validate();
        return flowTxExecutor;
    }

    private static FlowTxExecutor.FlowTxOperateExecutor parseFlowTxOperate(Method method) {
        logger.debug("\u89e3\u6790\u6d41\u7a0b\u4e8b\u52a1\u65b9\u6cd5\uff1a{}", (Object)method);
        if (!Modifier.isPublic(method.getModifiers())) {
            throw new IllegalArgumentException("\u6d41\u7a0b\u4e8b\u52a1\u65b9\u6cd5" + ClassUtils.getQualifiedMethodName((Method)method) + "\u5fc5\u987b\u662fpublic\u7c7b\u578b");
        }
        Class<?>[] parameterTypes = method.getParameterTypes();
        if (parameterTypes.length != 1) {
            throw new IllegalArgumentException("\u6d41\u7a0b\u4e8b\u52a1\u65b9\u6cd5" + ClassUtils.getQualifiedMethodName((Method)method) + "\u7684\u5165\u53c2\u5fc5\u987b\u662f\uff08TargetContext\uff09");
        }
        if (parameterTypes[0] != TargetContext.class) {
            throw new IllegalArgumentException("\u6d41\u7a0b\u4e8b\u52a1\u65b9\u6cd5" + ClassUtils.getQualifiedMethodName((Method)method) + "\u7684\u5165\u53c2\u5fc5\u987b\u662f\uff08TargetContext\uff09");
        }
        ResolvableType resolvableType = ResolvableType.forMethodParameter((Method)method, (int)0);
        Class classOfTarget = resolvableType.getGeneric(new int[]{0}).resolve(Object.class);
        if (method.getReturnType() != classOfTarget) {
            throw new IllegalArgumentException("\u6d41\u7a0b\u4e8b\u52a1\u65b9\u6cd5" + ClassUtils.getQualifiedMethodName((Method)method) + "\u7684\u8fd4\u56de\u7c7b\u578b\u5fc5\u987b\u662f\u76ee\u6807\u5bf9\u8c61\u7c7b\u578b");
        }
        return new FlowTxExecutor.FlowTxOperateExecutor(method, classOfTarget);
    }
}

