/*
 * Decompiled with CFR 0.152.
 */
package org.bekit.flow.boot;

import org.bekit.common.scanner.AbstractScanner;
import org.bekit.common.transaction.TransactionManager;
import org.bekit.event.boot.EventBusConfiguration;
import org.bekit.event.bus.EventBusHub;
import org.bekit.flow.annotation.flow.Flow;
import org.bekit.flow.annotation.locker.TheFlowLocker;
import org.bekit.flow.annotation.mapper.TheFlowMapper;
import org.bekit.flow.annotation.processor.Processor;
import org.bekit.flow.engine.DefaultFlowEngine;
import org.bekit.flow.flow.FlowExecutor;
import org.bekit.flow.flow.FlowParser;
import org.bekit.flow.flow.FlowRegistrar;
import org.bekit.flow.listener.DefaultFlowListener;
import org.bekit.flow.locker.TheFlowLockerExecutor;
import org.bekit.flow.locker.TheFlowLockerParser;
import org.bekit.flow.locker.TheFlowLockerRegistrar;
import org.bekit.flow.mapper.TheFlowMapperExecutor;
import org.bekit.flow.mapper.TheFlowMapperParser;
import org.bekit.flow.mapper.TheFlowMapperRegistrar;
import org.bekit.flow.processor.ProcessorExecutor;
import org.bekit.flow.processor.ProcessorParser;
import org.bekit.flow.processor.ProcessorRegistrar;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.annotation.Order;
import org.springframework.util.Assert;

@Configuration
@Import(value={EventBusConfiguration.class, DefaultFlowEngine.class, DefaultFlowListener.class, ProcessorRegistrar.class, TheFlowMapperRegistrar.class, TheFlowLockerRegistrar.class, FlowRegistrar.class, ProcessorScanner.class, TheFlowMapperScanner.class, TheFlowLockerScanner.class, FlowScanner.class})
public class FlowEngineConfiguration {
    public static final int ORDER = 1000;

    @Order(value=1300)
    public static class FlowScanner
    extends AbstractScanner {
        private final FlowRegistrar flowRegistrar;
        private final ProcessorRegistrar processorRegistrar;
        private final TheFlowMapperRegistrar theFlowMapperRegistrar;
        private final TheFlowLockerRegistrar theFlowLockerRegistrar;
        private final TransactionManager transactionManager;
        private final EventBusHub eventBusHub;

        public FlowScanner(FlowRegistrar flowRegistrar, ProcessorRegistrar processorRegistrar, TheFlowMapperRegistrar theFlowMapperRegistrar, TheFlowLockerRegistrar theFlowLockerRegistrar, TransactionManager transactionManager, EventBusHub eventBusHub) {
            super(Flow.class);
            this.flowRegistrar = flowRegistrar;
            this.processorRegistrar = processorRegistrar;
            this.theFlowMapperRegistrar = theFlowMapperRegistrar;
            this.theFlowLockerRegistrar = theFlowLockerRegistrar;
            this.transactionManager = transactionManager;
            this.eventBusHub = eventBusHub;
        }

        protected void onScan(Object obj) {
            FlowExecutor flowExecutor = FlowParser.parseFlow(obj, this.processorRegistrar, this.theFlowMapperRegistrar, this.theFlowLockerRegistrar, this.transactionManager, this.eventBusHub);
            FlowExecutor existedOne = (FlowExecutor)this.flowRegistrar.register(flowExecutor);
            Assert.isNull((Object)existedOne, (String)String.format("\u5b58\u5728\u91cd\u540d\u7684\u6d41\u7a0b[%s]", flowExecutor.getFlowName()));
        }
    }

    @Order(value=1200)
    public static class TheFlowLockerScanner
    extends AbstractScanner {
        private final TheFlowLockerRegistrar theFlowLockerRegistrar;

        public TheFlowLockerScanner(TheFlowLockerRegistrar theFlowLockerRegistrar) {
            super(TheFlowLocker.class);
            this.theFlowLockerRegistrar = theFlowLockerRegistrar;
        }

        protected void onScan(Object obj) {
            TheFlowLockerExecutor theFlowLockerExecutor = TheFlowLockerParser.parseTheFlowLocker(obj);
            TheFlowLockerExecutor existedOne = (TheFlowLockerExecutor)this.theFlowLockerRegistrar.register(theFlowLockerExecutor);
            Assert.isNull((Object)existedOne, (String)String.format("\u6d41\u7a0b[%s]\u5b58\u5728\u91cd\u590d\u7684\u7279\u5b9a\u6d41\u7a0b\u52a0\u9501\u5668", theFlowLockerExecutor.getFlow()));
        }
    }

    @Order(value=1100)
    public static class TheFlowMapperScanner
    extends AbstractScanner {
        private final TheFlowMapperRegistrar theFlowMapperRegistrar;

        public TheFlowMapperScanner(TheFlowMapperRegistrar theFlowMapperRegistrar) {
            super(TheFlowMapper.class);
            this.theFlowMapperRegistrar = theFlowMapperRegistrar;
        }

        protected void onScan(Object obj) {
            TheFlowMapperExecutor theFlowMapperExecutor = TheFlowMapperParser.parseTheFlowMapper(obj);
            TheFlowMapperExecutor existedOne = (TheFlowMapperExecutor)((Object)this.theFlowMapperRegistrar.register((Object)theFlowMapperExecutor));
            Assert.isNull((Object)((Object)existedOne), (String)String.format("\u6d41\u7a0b[%s]\u5b58\u5728\u91cd\u590d\u7684\u7279\u5b9a\u6d41\u7a0b\u6620\u5c04\u5668", theFlowMapperExecutor.getFlow()));
        }
    }

    @Order(value=1000)
    public static class ProcessorScanner
    extends AbstractScanner {
        private final ProcessorRegistrar processorRegistrar;

        public ProcessorScanner(ProcessorRegistrar processorRegistrar) {
            super(Processor.class);
            this.processorRegistrar = processorRegistrar;
        }

        protected void onScan(Object obj) {
            ProcessorExecutor processorExecutor = ProcessorParser.parseProcessor(obj);
            ProcessorExecutor existedOne = (ProcessorExecutor)((Object)this.processorRegistrar.register((Object)processorExecutor));
            Assert.isNull((Object)((Object)existedOne), (String)String.format("\u5b58\u5728\u91cd\u540d\u7684\u5904\u7406\u5668[%s]", processorExecutor.getProcessorName()));
        }
    }
}

