/*
 * Decompiled with CFR 0.152.
 */
package org.bekit.flow.flow;

import java.lang.reflect.Method;
import java.util.Map;
import java.util.Set;
import org.bekit.common.method.MethodExecutor;
import org.bekit.common.transaction.TxExecutor;
import org.bekit.event.EventPublisher;
import org.bekit.flow.annotation.locker.FlowLock;
import org.bekit.flow.annotation.locker.FlowUnlock;
import org.bekit.flow.annotation.locker.StateLock;
import org.bekit.flow.annotation.locker.StateUnlock;
import org.bekit.flow.engine.FlowContext;
import org.bekit.flow.event.DecidedNodeEvent;
import org.bekit.flow.event.DecidedStateNodeEvent;
import org.bekit.flow.event.ExecutingNodeEvent;
import org.bekit.flow.event.FlowEndEvent;
import org.bekit.flow.event.FlowExceptionEvent;
import org.bekit.flow.event.FlowStartEvent;
import org.bekit.flow.locker.TheFlowLockerExecutor;
import org.bekit.flow.mapper.TheFlowMapperExecutor;
import org.bekit.flow.processor.ProcessorExecutor;

public class FlowExecutor {
    private final String flowName;
    private final Object flow;
    private final String startNode;
    private final Set<String> endNodes;
    private final Map<String, NodeExecutor> nodeExecutorMap;
    private final TheFlowMapperExecutor mapperExecutor;
    private final TheFlowLockerExecutor lockerExecutor;
    private final TxExecutor txExecutor;
    private final EventPublisher eventPublisher;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(FlowContext<?> context) throws Throwable {
        try {
            this.eventPublisher.publish((Object)new FlowStartEvent(this.flowName, context));
            String node = this.mappingNode(context, this.startNode);
            try {
                node = this.beforeFlow(context, node);
                try {
                    node = this.beforeState(context, node);
                    if (!this.endNodes.contains(node)) {
                        NodeExecutor nodeExecutor = this.getRequiredNodeExecutor(node);
                        do {
                            this.eventPublisher.publish((Object)new ExecutingNodeEvent(this.flowName, node, context));
                            node = nodeExecutor.execute(this.flow, context);
                            if (node == null) break;
                            nodeExecutor = this.getRequiredNodeExecutor(node);
                            this.eventPublisher.publish((Object)new DecidedNodeEvent(this.flowName, node, context));
                            if (!nodeExecutor.isHaveState()) continue;
                            this.eventPublisher.publish((Object)new DecidedStateNodeEvent(this.flowName, node, context));
                            if (!nodeExecutor.isAutoExecute()) continue;
                            this.afterState(context);
                            node = this.beforeState(context, node);
                            nodeExecutor = this.getRequiredNodeExecutor(node);
                        } while (nodeExecutor.isAutoExecute());
                    }
                    this.afterState(context);
                }
                catch (Throwable e) {
                    this.afterStateException(context);
                    throw e;
                }
            }
            finally {
                this.afterFlow(context);
            }
        }
        catch (Throwable e) {
            this.eventPublisher.publish((Object)new FlowExceptionEvent(this.flowName, e, context));
            throw e;
        }
        finally {
            this.eventPublisher.publish((Object)new FlowEndEvent(this.flowName, context));
        }
    }

    private String mappingNode(FlowContext<?> context, String defaultNode) throws Throwable {
        String node = defaultNode;
        if (this.mapperExecutor != null) {
            node = this.mapperExecutor.execute(context);
        }
        return node;
    }

    private String beforeFlow(FlowContext<?> context, String defaultNode) throws Throwable {
        String node = defaultNode;
        if (this.lockerExecutor != null && this.lockerExecutor.contain(FlowLock.class)) {
            Object newTarget = this.lockerExecutor.execute(FlowLock.class, context);
            context.refreshTarget(newTarget);
            node = this.mappingNode(context, node);
        }
        return node;
    }

    private String beforeState(FlowContext<?> context, String defaultNode) throws Throwable {
        String node = defaultNode;
        this.txExecutor.createTx();
        if (this.lockerExecutor != null && this.lockerExecutor.contain(StateLock.class)) {
            Object newTarget = this.lockerExecutor.execute(StateLock.class, context);
            context.refreshTarget(newTarget);
            node = this.mappingNode(context, node);
        }
        return node;
    }

    private NodeExecutor getRequiredNodeExecutor(String node) {
        NodeExecutor nodeExecutor = this.nodeExecutorMap.get(node);
        if (nodeExecutor == null) {
            throw new IllegalStateException(String.format("\u6d41\u7a0b[%s]\u4e0d\u5b58\u5728\u8282\u70b9[%s]", this.flowName, node));
        }
        return nodeExecutor;
    }

    private void afterState(FlowContext<?> context) throws Throwable {
        if (this.lockerExecutor != null && this.lockerExecutor.contain(StateUnlock.class)) {
            this.lockerExecutor.execute(StateUnlock.class, context);
        }
        this.txExecutor.commitTx();
    }

    private void afterStateException(FlowContext<?> context) throws Throwable {
        try {
            if (this.lockerExecutor != null && this.lockerExecutor.contain(StateUnlock.class)) {
                this.lockerExecutor.execute(StateUnlock.class, context);
            }
        }
        finally {
            this.txExecutor.rollbackTx();
        }
    }

    private void afterFlow(FlowContext<?> context) throws Throwable {
        if (this.lockerExecutor != null && this.lockerExecutor.contain(FlowUnlock.class)) {
            this.lockerExecutor.execute(FlowUnlock.class, context);
        }
    }

    public FlowExecutor(String flowName, Object flow, String startNode, Set<String> endNodes, Map<String, NodeExecutor> nodeExecutorMap, TheFlowMapperExecutor mapperExecutor, TheFlowLockerExecutor lockerExecutor, TxExecutor txExecutor, EventPublisher eventPublisher) {
        this.flowName = flowName;
        this.flow = flow;
        this.startNode = startNode;
        this.endNodes = endNodes;
        this.nodeExecutorMap = nodeExecutorMap;
        this.mapperExecutor = mapperExecutor;
        this.lockerExecutor = lockerExecutor;
        this.txExecutor = txExecutor;
        this.eventPublisher = eventPublisher;
    }

    public String getFlowName() {
        return this.flowName;
    }

    public Object getFlow() {
        return this.flow;
    }

    public static class NodeExecutor {
        private final String nodeName;
        private final boolean haveState;
        private final boolean autoExecute;
        private final ProcessorExecutor processorExecutor;
        private final NodeDeciderExecutor nodeDeciderExecutor;

        public String execute(Object flow, FlowContext<?> context) throws Throwable {
            Object processResult = null;
            if (this.processorExecutor != null) {
                processResult = this.processorExecutor.execute(context);
            }
            return this.nodeDeciderExecutor.execute(flow, processResult, context);
        }

        public NodeExecutor(String nodeName, boolean haveState, boolean autoExecute, ProcessorExecutor processorExecutor, NodeDeciderExecutor nodeDeciderExecutor) {
            this.nodeName = nodeName;
            this.haveState = haveState;
            this.autoExecute = autoExecute;
            this.processorExecutor = processorExecutor;
            this.nodeDeciderExecutor = nodeDeciderExecutor;
        }

        public String getNodeName() {
            return this.nodeName;
        }

        public boolean isHaveState() {
            return this.haveState;
        }

        public boolean isAutoExecute() {
            return this.autoExecute;
        }

        public static class NodeDeciderExecutor
        extends MethodExecutor {
            private final ParameterType parameterType;

            public NodeDeciderExecutor(ParameterType parameterType, Method nodeDeciderMethod) {
                super(nodeDeciderMethod);
                this.parameterType = parameterType;
            }

            public String execute(Object flow, Object processResult, FlowContext<?> context) throws Throwable {
                switch (this.parameterType) {
                    case NONE: {
                        return (String)this.execute(flow, new Object[0]);
                    }
                    case ONLY_PROCESS_RESULT: {
                        return (String)this.execute(flow, new Object[]{processResult});
                    }
                    case ONLY_FLOW_CONTEXT: {
                        return (String)this.execute(flow, new Object[]{context});
                    }
                    case PROCESS_RESULT_AND_FLOW_CONTEXT: {
                        return (String)this.execute(flow, new Object[]{processResult, context});
                    }
                }
                throw new IllegalStateException("\u8282\u70b9\u51b3\u7b56\u5668\u6267\u884c\u5668\u5185\u90e8\u8981\u7d20\u4e0d\u5bf9");
            }

            public static enum ParameterType {
                NONE,
                ONLY_PROCESS_RESULT,
                ONLY_FLOW_CONTEXT,
                PROCESS_RESULT_AND_FLOW_CONTEXT;

            }
        }
    }
}

