/*
 * Decompiled with CFR 0.152.
 */
package org.bekit.flow.flow;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.bekit.common.transaction.TransactionManager;
import org.bekit.common.transaction.TxExecutor;
import org.bekit.event.EventPublisher;
import org.bekit.event.bus.EventBusHub;
import org.bekit.event.publisher.DefaultEventPublisher;
import org.bekit.flow.annotation.flow.EndNode;
import org.bekit.flow.annotation.flow.Flow;
import org.bekit.flow.annotation.flow.Node;
import org.bekit.flow.annotation.flow.StartNode;
import org.bekit.flow.engine.FlowContext;
import org.bekit.flow.flow.FlowExecutor;
import org.bekit.flow.listener.FlowListenerType;
import org.bekit.flow.locker.TheFlowLockerExecutor;
import org.bekit.flow.locker.TheFlowLockerRegistrar;
import org.bekit.flow.mapper.TheFlowMapperExecutor;
import org.bekit.flow.mapper.TheFlowMapperRegistrar;
import org.bekit.flow.processor.ProcessorExecutor;
import org.bekit.flow.processor.ProcessorRegistrar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

public class FlowParser {
    private static final Logger log = LoggerFactory.getLogger(FlowParser.class);

    public static FlowExecutor parseFlow(Object flow, ProcessorRegistrar processorRegistrar, TheFlowMapperRegistrar mapperRegistrar, TheFlowLockerRegistrar lockerRegistrar, TransactionManager transactionManager, EventBusHub eventBusHub) {
        Class flowClass = AopUtils.getTargetClass((Object)flow);
        log.debug("\u89e3\u6790\u6d41\u7a0b\uff1a{}", (Object)flowClass);
        Flow flowAnnotation = (Flow)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)flowClass, Flow.class);
        String flowName = flowAnnotation.name();
        if (StringUtils.isEmpty((CharSequence)flowName)) {
            flowName = ClassUtils.getShortNameAsProperty((Class)flowClass);
        }
        Map<Class<?>, Map<String, FlowExecutor.NodeExecutor>> map = FlowParser.parseToNodeExecutors(flowClass, processorRegistrar);
        return new FlowExecutor(flowName, flow, map.get(StartNode.class).keySet().iterator().next(), map.get(EndNode.class).keySet(), map.get(Node.class), (TheFlowMapperExecutor)((Object)mapperRegistrar.get(flowName)), (TheFlowLockerExecutor)lockerRegistrar.get(flowName), new TxExecutor(transactionManager, TransactionManager.TransactionType.REQUIRED), (EventPublisher)new DefaultEventPublisher(eventBusHub.getEventBus(FlowListenerType.class)));
    }

    private static Map<Class<?>, Map<String, FlowExecutor.NodeExecutor>> parseToNodeExecutors(Class<?> flowClass, ProcessorRegistrar processorRegistrar) {
        HashMap map = new HashMap();
        map.put(Node.class, new HashMap());
        map.put(StartNode.class, new HashMap());
        map.put(EndNode.class, new HashMap());
        ReflectionUtils.doWithLocalMethods(flowClass, method -> {
            Node nodeAnnotation = (Node)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, Node.class);
            if (nodeAnnotation != null) {
                FlowExecutor.NodeExecutor nodeExecutor = FlowParser.parseNode(nodeAnnotation, method, processorRegistrar);
                Map nodeExecutorMap = (Map)map.get(Node.class);
                Assert.isTrue((!nodeExecutorMap.containsKey(nodeExecutor.getNodeName()) ? 1 : 0) != 0, (String)String.format("\u6d41\u7a0b[%s]\u5b58\u5728\u91cd\u540d\u7684\u8282\u70b9[%s]", flowClass, nodeExecutor.getNodeName()));
                nodeExecutorMap.put(nodeExecutor.getNodeName(), nodeExecutor);
                if (AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, StartNode.class) != null) {
                    ((Map)map.get(StartNode.class)).put(nodeExecutor.getNodeName(), nodeExecutor);
                } else if (AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, EndNode.class) != null) {
                    ((Map)map.get(EndNode.class)).put(nodeExecutor.getNodeName(), nodeExecutor);
                }
            }
        });
        Assert.isTrue((((Map)map.get(StartNode.class)).size() == 1 ? 1 : 0) != 0, (String)String.format("\u6d41\u7a0b[%s]\u5fc5\u987b\u5b58\u5728\u552f\u4e00\u7684\u4e00\u4e2a\u5f00\u59cb\u8282\u70b9\uff08@StartNode\uff09", flowClass));
        return map;
    }

    private static FlowExecutor.NodeExecutor parseNode(Node nodeAnnotation, Method nodeMethod, ProcessorRegistrar processorRegistrar) {
        log.debug("\u89e3\u6790\u6d41\u7a0b\u8282\u70b9\uff1anode={}\uff0cmethod={}", (Object)nodeAnnotation, (Object)nodeMethod);
        String nodeName = nodeAnnotation.name();
        if (StringUtils.isEmpty((CharSequence)nodeName)) {
            nodeName = nodeMethod.getName();
        }
        ProcessorExecutor processorExecutor = null;
        if (StringUtils.isNotEmpty((CharSequence)nodeAnnotation.processor())) {
            processorExecutor = (ProcessorExecutor)((Object)processorRegistrar.get(nodeAnnotation.processor()));
            Assert.notNull((Object)((Object)processorExecutor), (String)String.format("\u4e0d\u5b58\u5728\u5904\u7406\u5668[%s]", processorExecutor.getProcessorName()));
        }
        FlowExecutor.NodeExecutor.NodeDeciderExecutor nodeDeciderExecutor = FlowParser.parseNodeDecider(nodeMethod, processorExecutor);
        return new FlowExecutor.NodeExecutor(nodeName, nodeAnnotation.haveState(), nodeAnnotation.autoExecute(), processorExecutor, nodeDeciderExecutor);
    }

    private static FlowExecutor.NodeExecutor.NodeDeciderExecutor parseNodeDecider(Method nodeDeciderMethod, ProcessorExecutor processorExecutor) {
        FlowExecutor.NodeExecutor.NodeDeciderExecutor.ParameterType parameterType;
        Assert.isTrue((boolean)Modifier.isPublic(nodeDeciderMethod.getModifiers()), (String)String.format("\u8282\u70b9\u51b3\u7b56\u5668[%s]\u5fc5\u987b\u662fpublic\u7c7b\u578b", nodeDeciderMethod));
        Class<?>[] parameterTypes = nodeDeciderMethod.getParameterTypes();
        if (parameterTypes.length == 0) {
            parameterType = FlowExecutor.NodeExecutor.NodeDeciderExecutor.ParameterType.NONE;
        } else {
            Assert.isTrue((AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)nodeDeciderMethod, EndNode.class) == null ? 1 : 0) != 0, (String)String.format("\u7ed3\u675f\u8282\u70b9\u7684\u51b3\u7b56\u5668[%s]\u7684\u5165\u53c2\u7c7b\u578b\u5fc5\u987b\u4e3a()", nodeDeciderMethod));
            if (parameterTypes.length == 1) {
                if (parameterTypes[0] == FlowContext.class) {
                    parameterType = FlowExecutor.NodeExecutor.NodeDeciderExecutor.ParameterType.ONLY_FLOW_CONTEXT;
                } else {
                    Assert.isTrue((processorExecutor != null ? 1 : 0) != 0, (String)String.format("\u8282\u70b9\u51b3\u7b56\u5668[%s]\u4e0d\u80fd\u6709\u975eFlowContext\u5165\u53c2\uff0c\u56e0\u4e3a\u8fd9\u4e2a\u8282\u70b9\u6ca1\u6709\u5904\u7406\u5668", nodeDeciderMethod));
                    Assert.isAssignable(parameterTypes[0], (Class)processorExecutor.getReturnType(), (String)String.format("\u8282\u70b9\u51b3\u7b56\u5668[%s]\u7684\u5165\u53c2\u7c7b\u578b\u5fc5\u987b\u80fd\u88ab\u5176\u5904\u7406\u5668\u8fd4\u56de\u7c7b\u578b\u8d4b\u503c", nodeDeciderMethod));
                    parameterType = FlowExecutor.NodeExecutor.NodeDeciderExecutor.ParameterType.ONLY_PROCESS_RESULT;
                }
            } else if (parameterTypes.length == 2) {
                Assert.isTrue((processorExecutor != null ? 1 : 0) != 0, (String)String.format("\u8282\u70b9\u51b3\u7b56\u5668[%s]\u4e0d\u80fd\u6709\u975eFlowContext\u5165\u53c2\uff0c\u56e0\u4e3a\u8fd9\u4e2a\u8282\u70b9\u6ca1\u6709\u5904\u7406\u5668", nodeDeciderMethod));
                Assert.isAssignable(parameterTypes[0], (Class)processorExecutor.getReturnType(), (String)String.format("\u8282\u70b9\u51b3\u7b56\u5668[%s]\u7684\u7b2c\u4e00\u4e2a\u5165\u53c2\u7c7b\u578b\u5fc5\u987b\u80fd\u88ab\u5176\u5904\u7406\u5668\u8fd4\u56de\u7c7b\u578b\u8d4b\u503c", nodeDeciderMethod));
                Assert.isTrue((parameterTypes[1] == FlowContext.class ? 1 : 0) != 0, (String)String.format("\u8282\u70b9\u51b3\u7b56\u5668[%s]\u7684\u7b2c\u4e8c\u4e2a\u5165\u53c2\u7c7b\u578b\u5fc5\u987b\u662fFlowContext", nodeDeciderMethod));
                parameterType = FlowExecutor.NodeExecutor.NodeDeciderExecutor.ParameterType.PROCESS_RESULT_AND_FLOW_CONTEXT;
            } else {
                throw new IllegalArgumentException(String.format("\u8282\u70b9\u51b3\u7b56\u5668[%s]\u7684\u5165\u53c2\u7c7b\u578b\u5fc5\u987b\u4e3a\uff1a()\u3001(FlowContext)\u3001(T)\u3001(T, FlowContext)\u2014\u2014\u2014\u2014T\u8868\u793a\u80fd\u88ab\u5904\u7406\u5668\u8fd4\u56de\u7ed3\u679c\u8d4b\u503c\u7684\u7c7b\u578b", nodeDeciderMethod));
            }
        }
        if (AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)nodeDeciderMethod, EndNode.class) == null) {
            Assert.isTrue((nodeDeciderMethod.getReturnType() == String.class ? 1 : 0) != 0, (String)String.format("\u8282\u70b9\u51b3\u7b56\u5668[%s]\u7684\u8fd4\u56de\u7c7b\u578b\u5fc5\u987b\u662fString", nodeDeciderMethod));
        } else {
            Assert.isTrue((nodeDeciderMethod.getReturnType() == Void.TYPE ? 1 : 0) != 0, (String)String.format("\u7ed3\u675f\u8282\u70b9\uff08@EndNode\uff09\u7684\u51b3\u7b56\u5668[%s]\u7684\u8fd4\u56de\u7c7b\u578b\u5fc5\u987b\u662fvoid", nodeDeciderMethod));
        }
        return new FlowExecutor.NodeExecutor.NodeDeciderExecutor(parameterType, nodeDeciderMethod);
    }
}

