/*
 * Decompiled with CFR 0.152.
 */
package org.bekit.flow.locker;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import org.bekit.flow.annotation.locker.FlowLock;
import org.bekit.flow.annotation.locker.FlowUnlock;
import org.bekit.flow.annotation.locker.StateLock;
import org.bekit.flow.annotation.locker.StateUnlock;
import org.bekit.flow.annotation.locker.TheFlowLocker;
import org.bekit.flow.engine.FlowContext;
import org.bekit.flow.locker.TheFlowLockerExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.core.ResolvableType;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

public final class TheFlowLockerParser {
    private static final Logger log = LoggerFactory.getLogger(TheFlowLockerParser.class);
    private static final Class<? extends Annotation>[] LOCK_UNLOCK_TYPES = new Class[]{FlowLock.class, FlowUnlock.class, StateLock.class, StateUnlock.class};

    public static TheFlowLockerExecutor parseTheFlowLocker(Object theFlowLocker) {
        Class theFlowLockerClass = AopUtils.getTargetClass((Object)theFlowLocker);
        log.debug("\u89e3\u6790\u7279\u5b9a\u6d41\u7a0b\u52a0\u9501\u5668\uff1a{}", (Object)theFlowLockerClass);
        TheFlowLocker theFlowLockerAnnotation = (TheFlowLocker)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)theFlowLockerClass, TheFlowLocker.class);
        Map<Class<?>, TheFlowLockerExecutor.LockOrUnlockExecutor> lockOrUnlockExecutorMap = TheFlowLockerParser.parseToLockOrUnlockExecutors(theFlowLockerClass);
        return new TheFlowLockerExecutor(theFlowLockerAnnotation.flow(), theFlowLocker, lockOrUnlockExecutorMap);
    }

    private static Map<Class<?>, TheFlowLockerExecutor.LockOrUnlockExecutor> parseToLockOrUnlockExecutors(Class<?> theFlowLockerClass) {
        HashMap executorMap = new HashMap();
        ReflectionUtils.doWithLocalMethods(theFlowLockerClass, method -> {
            for (Class<? extends Annotation> type : LOCK_UNLOCK_TYPES) {
                if (AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, type) == null) continue;
                executorMap.put(type, TheFlowLockerParser.parseLockOrUnlock(type, method));
            }
        });
        return executorMap;
    }

    private static TheFlowLockerExecutor.LockOrUnlockExecutor parseLockOrUnlock(Class<?> type, Method lockOrUnlockMethod) {
        log.debug("\u89e3\u6790\u52a0\u89e3\u9501\u65b9\u6cd5{}", (Object)lockOrUnlockMethod);
        Assert.isTrue((boolean)Modifier.isPublic(lockOrUnlockMethod.getModifiers()), (String)String.format("@%s\u65b9\u6cd5[%s]\u5fc5\u987b\u662fpublic\u7c7b\u578b", type.getSimpleName(), lockOrUnlockMethod));
        Class<?>[] parameterTypes = lockOrUnlockMethod.getParameterTypes();
        if (parameterTypes.length != 1 || parameterTypes[0] != FlowContext.class) {
            throw new IllegalArgumentException(String.format("@%s\u65b9\u6cd5[%s]\u5165\u53c2\u7c7b\u578b\u5fc5\u987b\u662f(FlowContext<T>)", type.getSimpleName(), lockOrUnlockMethod));
        }
        ResolvableType resolvableType = ResolvableType.forMethodParameter((Method)lockOrUnlockMethod, (int)0);
        Class targetType = resolvableType.getGeneric(new int[]{0}).resolve(Object.class);
        if (type == FlowLock.class || type == StateLock.class) {
            Assert.isTrue((lockOrUnlockMethod.getReturnType() == targetType ? 1 : 0) != 0, (String)String.format("@%s\u65b9\u6cd5[%s]\u8fd4\u56de\u7c7b\u578b\u4e0eFlowContext\u7684\u76ee\u6807\u5bf9\u8c61\u7c7b\u578b\u5fc5\u987b\u4e00\u81f4", type.getSimpleName(), lockOrUnlockMethod));
        } else {
            Assert.isTrue((lockOrUnlockMethod.getReturnType() == Void.TYPE ? 1 : 0) != 0, (String)String.format("@%s\u65b9\u6cd5[%s]\u8fd4\u56de\u7c7b\u578b\u5fc5\u987b\u4e3avoid", type.getSimpleName(), lockOrUnlockMethod));
        }
        return new TheFlowLockerExecutor.LockOrUnlockExecutor(lockOrUnlockMethod);
    }
}

