/*
 * Decompiled with CFR 0.152.
 */
package org.bekit.flow.mapper;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.bekit.flow.annotation.mapper.MappingNode;
import org.bekit.flow.annotation.mapper.TheFlowMapper;
import org.bekit.flow.engine.FlowContext;
import org.bekit.flow.mapper.TheFlowMapperExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.util.Assert;

public final class TheFlowMapperParser {
    private static final Logger log = LoggerFactory.getLogger(TheFlowMapperParser.class);

    public static TheFlowMapperExecutor parseTheFlowMapper(Object theFlowMapper) {
        Class theFlowMapperClass = AopUtils.getTargetClass((Object)theFlowMapper);
        log.debug("\u89e3\u6790\u7279\u5b9a\u6d41\u7a0b\u6620\u5c04\u5668\uff1a{}", (Object)theFlowMapperClass);
        TheFlowMapper theFlowMapperAnnotation = (TheFlowMapper)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)theFlowMapperClass, TheFlowMapper.class);
        Method mappingNodeMethod = TheFlowMapperParser.parseToMappingNodeMethod(theFlowMapperClass);
        return new TheFlowMapperExecutor(theFlowMapperAnnotation.flow(), theFlowMapper, mappingNodeMethod);
    }

    private static Method parseToMappingNodeMethod(Class<?> theFlowMapperClass) {
        for (Method method : theFlowMapperClass.getDeclaredMethods()) {
            if (AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, MappingNode.class) == null) continue;
            Assert.isTrue((boolean)Modifier.isPublic(method.getModifiers()), (String)String.format("@MappingNode\u65b9\u6cd5[%s]\u5fc5\u987b\u662fpublic\u7c7b\u578b", method));
            Assert.isTrue((method.getReturnType() == String.class ? 1 : 0) != 0, (String)String.format("@MappingNode\u65b9\u6cd5[%s]\u8fd4\u56de\u7c7b\u578b\u5fc5\u987b\u662fString", method));
            Class<?>[] parameterTypes = method.getParameterTypes();
            if (parameterTypes.length != 1 || parameterTypes[0] != FlowContext.class) {
                throw new IllegalArgumentException(String.format("@ProcessorExecute\u65b9\u6cd5[%s]\u7684\u5165\u53c2\u5fc5\u987b\u662f(FlowContext<T> context)", method));
            }
            return method;
        }
        throw new IllegalArgumentException(String.format("\u7279\u5b9a\u6d41\u7a0b\u6620\u5c04\u5668[%s]\u4e0d\u5b58\u5728@MappingNode\u6cd5", theFlowMapperClass));
    }
}

