/*
 * Decompiled with CFR 0.152.
 */
package org.bekit.flow.processor;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.apache.commons.lang3.StringUtils;
import org.bekit.flow.annotation.processor.Processor;
import org.bekit.flow.annotation.processor.ProcessorExecute;
import org.bekit.flow.engine.FlowContext;
import org.bekit.flow.processor.ProcessorExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public final class ProcessorParser {
    private static final Logger log = LoggerFactory.getLogger(ProcessorParser.class);

    public static ProcessorExecutor parseProcessor(Object processor) {
        Class processorClass = AopUtils.getTargetClass((Object)processor);
        log.debug("\u89e3\u6790\u5904\u7406\u5668\uff1a{}", (Object)processorClass);
        Processor processorAnnotation = (Processor)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)processorClass, Processor.class);
        String processorName = processorAnnotation.name();
        if (StringUtils.isEmpty((CharSequence)processorName)) {
            processorName = ClassUtils.getShortNameAsProperty((Class)processorClass);
        }
        Method executeMethod = ProcessorParser.parseToExecuteMethod(processorClass);
        return new ProcessorExecutor(processorName, processor, executeMethod);
    }

    private static Method parseToExecuteMethod(Class<?> processorClass) {
        for (Method method : processorClass.getDeclaredMethods()) {
            if (AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, ProcessorExecute.class) == null) continue;
            Assert.isTrue((boolean)Modifier.isPublic(method.getModifiers()), (String)String.format("@ProcessorExecute\u65b9\u6cd5[%s]\u5fc5\u987b\u662fpublic\u7c7b\u578b", method));
            Class<?>[] parameterTypes = method.getParameterTypes();
            if (parameterTypes.length != 1 || parameterTypes[0] != FlowContext.class) {
                throw new IllegalArgumentException(String.format("@ProcessorExecute\u65b9\u6cd5[%s]\u7684\u5165\u53c2\u5fc5\u987b\u662f(FlowContext<T> context)", method));
            }
            return method;
        }
        throw new IllegalArgumentException(String.format("\u5904\u7406\u5668[%s]\u4e0d\u5b58\u5728@ProcessorExecute\u65b9\u6cd5", processorClass));
    }
}

