/*
 * Decompiled with CFR 0.152.
 */
package org.benf.cfr.reader.bytecode;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement;
import org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.AssertRewriter;
import org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.EnumClassRewriter;
import org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.IllegalGenericRewriter;
import org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.InlinedConstantRewriter;
import org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.J14ClassObjectRewriter;
import org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.NonStaticLifter;
import org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.ScopeHidingVariableRewriter;
import org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.StaticLifter;
import org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.matchutil.DeadMethodRemover;
import org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.util.ConstructorUtils;
import org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.util.MiscStatementTools;
import org.benf.cfr.reader.bytecode.analysis.parse.Expression;
import org.benf.cfr.reader.bytecode.analysis.parse.expression.LValueExpression;
import org.benf.cfr.reader.bytecode.analysis.parse.literal.TypedLiteral;
import org.benf.cfr.reader.bytecode.analysis.parse.lvalue.AbstractFieldVariable;
import org.benf.cfr.reader.bytecode.analysis.parse.lvalue.FieldVariable;
import org.benf.cfr.reader.bytecode.analysis.parse.lvalue.StaticVariable;
import org.benf.cfr.reader.bytecode.analysis.structured.StructuredStatement;
import org.benf.cfr.reader.bytecode.analysis.types.InnerClassInfo;
import org.benf.cfr.reader.bytecode.analysis.types.JavaRefTypeInstance;
import org.benf.cfr.reader.bytecode.analysis.types.JavaTypeInstance;
import org.benf.cfr.reader.bytecode.analysis.types.MethodPrototype;
import org.benf.cfr.reader.bytecode.analysis.types.TypeConstants;
import org.benf.cfr.reader.entities.AccessFlag;
import org.benf.cfr.reader.entities.AccessFlagMethod;
import org.benf.cfr.reader.entities.ClassFile;
import org.benf.cfr.reader.entities.ClassFileField;
import org.benf.cfr.reader.entities.Field;
import org.benf.cfr.reader.entities.Method;
import org.benf.cfr.reader.entities.constantpool.ConstantPool;
import org.benf.cfr.reader.state.ClassCache;
import org.benf.cfr.reader.state.DCCommonState;
import org.benf.cfr.reader.util.Functional;
import org.benf.cfr.reader.util.Predicate;
import org.benf.cfr.reader.util.SetFactory;
import org.benf.cfr.reader.util.functors.UnaryFunction;
import org.benf.cfr.reader.util.getopt.Options;
import org.benf.cfr.reader.util.getopt.OptionsImpl;

public class CodeAnalyserWholeClass {
    public static void wholeClassAnalysisPass1(ClassFile classFile, DCCommonState state) {
        Options options = state.getOptions();
        EnumClassRewriter.rewriteEnumClass(classFile, state);
        if (((Boolean)options.getOption(OptionsImpl.REMOVE_BAD_GENERICS)).booleanValue()) {
            CodeAnalyserWholeClass.removeIllegalGenerics(classFile, options);
        }
        if (((Boolean)options.getOption(OptionsImpl.SUGAR_ASSERTS)).booleanValue()) {
            CodeAnalyserWholeClass.resugarAsserts(classFile, options);
        }
        if (((Boolean)options.getOption(OptionsImpl.LIFT_CONSTRUCTOR_INIT)).booleanValue()) {
            CodeAnalyserWholeClass.liftStaticInitialisers(classFile, options);
            CodeAnalyserWholeClass.liftNonStaticInitialisers(classFile, options);
        }
        if (options.getOption(OptionsImpl.JAVA_4_CLASS_OBJECTS, classFile.getClassFileVersion()).booleanValue()) {
            CodeAnalyserWholeClass.resugarJava14classObjects(classFile, state);
        }
        if (((Boolean)options.getOption(OptionsImpl.REMOVE_BOILERPLATE)).booleanValue()) {
            CodeAnalyserWholeClass.removeBoilerplateMethods(classFile);
        }
        if (((Boolean)options.getOption(OptionsImpl.REMOVE_INNER_CLASS_SYNTHETICS)).booleanValue()) {
            if (classFile.isInnerClass()) {
                CodeAnalyserWholeClass.removeInnerClassOuterThis(classFile);
            }
            CodeAnalyserWholeClass.removeInnerClassSyntheticConstructorFriends(classFile);
        }
    }

    private static void replaceNestedSyntheticOuterRefs(ClassFile classFile) {
        for (Method method : classFile.getMethods()) {
            if (!method.hasCodeAttribute()) continue;
            Op04StructuredStatement code = method.getAnalysis();
            Op04StructuredStatement.replaceNestedSyntheticOuterRefs(code);
        }
    }

    private static void inlineAccessors(DCCommonState state, ClassFile classFile) {
        for (Method method : classFile.getMethods()) {
            if (!method.hasCodeAttribute()) continue;
            Op04StructuredStatement code = method.getAnalysis();
            Op04StructuredStatement.inlineSyntheticAccessors(state, method, code);
        }
    }

    private static void renameAnonymousScopeHidingVariables(ClassFile classFile, ClassCache classCache) {
        List<ClassFileField> fields = Functional.filter(classFile.getFields(), new Predicate<ClassFileField>(){

            @Override
            public boolean test(ClassFileField in) {
                return in.isSyntheticOuterRef();
            }
        });
        if (fields.isEmpty()) {
            return;
        }
        for (Method method : classFile.getMethods()) {
            if (!method.hasCodeAttribute()) continue;
            ScopeHidingVariableRewriter rewriter = new ScopeHidingVariableRewriter(fields, method, classCache);
            rewriter.rewrite(method.getAnalysis());
        }
    }

    private static void fixInnerClassConstructorSyntheticOuterArgs(ClassFile classFile) {
        if (classFile.isInnerClass()) {
            Set<MethodPrototype> processed = SetFactory.newSet();
            for (Method method : classFile.getConstructors()) {
                Op04StructuredStatement.fixInnerClassConstructorSyntheticOuterArgs(classFile, method, method.getAnalysis(), processed);
            }
        }
    }

    private static void removeInnerClassSyntheticConstructorFriends(ClassFile classFile) {
        for (Method method : classFile.getConstructors()) {
            InnerClassInfo innerClassInfo;
            MethodPrototype prototype;
            List<JavaTypeInstance> argsThis;
            MethodPrototype chainPrototype;
            Set<AccessFlagMethod> flags = method.getAccessFlags();
            if (!flags.contains((Object)AccessFlagMethod.ACC_SYNTHETIC) || flags.contains((Object)AccessFlagMethod.ACC_PUBLIC) || (chainPrototype = ConstructorUtils.getDelegatingPrototype(method)) == null || (argsThis = (prototype = method.getMethodPrototype()).getArgs()).isEmpty()) continue;
            List<JavaTypeInstance> argsThat = chainPrototype.getArgs();
            if (argsThis.size() != argsThat.size() + 1) continue;
            JavaTypeInstance last = argsThis.get(argsThis.size() - 1);
            UnaryFunction<JavaTypeInstance, JavaTypeInstance> degenerifier = new UnaryFunction<JavaTypeInstance, JavaTypeInstance>(){

                @Override
                public JavaTypeInstance invoke(JavaTypeInstance arg) {
                    return arg.getDeGenerifiedType();
                }
            };
            argsThis = Functional.map(argsThis, degenerifier);
            argsThat = Functional.map(argsThat, degenerifier);
            argsThis.remove(argsThis.size() - 1);
            if (!((Object)argsThis).equals(argsThat) || !(innerClassInfo = last.getInnerClassHereInfo()).isInnerClass()) continue;
            innerClassInfo.hideSyntheticFriendClass();
            prototype.hide(argsThis.size());
            method.hideSynthetic();
        }
    }

    private static void removeInnerClassOuterThis(ClassFile classFile) {
        if (classFile.testAccessFlag(AccessFlag.ACC_STATIC)) {
            return;
        }
        AbstractFieldVariable foundOuterThis = null;
        ClassFileField classFileField = null;
        for (Method method : classFile.getConstructors()) {
            if (ConstructorUtils.isDelegating(method)) continue;
            FieldVariable outerThis = Op04StructuredStatement.findInnerClassOuterThis(method, method.getAnalysis());
            if (outerThis == null) {
                return;
            }
            if (foundOuterThis == null) {
                foundOuterThis = outerThis;
                classFileField = foundOuterThis.getClassFileField();
                continue;
            }
            if (classFileField == outerThis.getClassFileField()) continue;
            return;
        }
        if (foundOuterThis == null) {
            return;
        }
        classFileField.markHidden();
        classFileField.markSyntheticOuterRef();
        for (Method method : classFile.getConstructors()) {
            if (ConstructorUtils.isDelegating(method)) {
                MethodPrototype prototype = method.getMethodPrototype();
                prototype.setInnerOuterThis();
                prototype.hide(0);
            }
            Op04StructuredStatement.removeInnerClassOuterThis(method, method.getAnalysis());
        }
        String originalName = foundOuterThis.getFieldName();
        JavaTypeInstance fieldType = foundOuterThis.getInferredJavaType().getJavaTypeInstance();
        if (!(fieldType instanceof JavaRefTypeInstance)) {
            return;
        }
        JavaRefTypeInstance fieldRefType = (JavaRefTypeInstance)fieldType.getDeGenerifiedType();
        String name = fieldRefType.getRawShortName();
        classFileField.overrideName(name + ".this");
        classFileField.markSyntheticOuterRef();
        try {
            ClassFileField localClassFileField = classFile.getFieldByName(originalName, fieldType);
            localClassFileField.overrideName(name + ".this");
            localClassFileField.markSyntheticOuterRef();
        }
        catch (NoSuchFieldException e) {
            // empty catch block
        }
        classFile.getClassType().getInnerClassHereInfo().setHideSyntheticThis();
    }

    private static Method getStaticConstructor(ClassFile classFile) {
        Method staticInit;
        try {
            staticInit = classFile.getMethodByName("<clinit>").get(0);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        return staticInit;
    }

    private static void liftStaticInitialisers(ClassFile classFile, Options state) {
        Method staticInit = CodeAnalyserWholeClass.getStaticConstructor(classFile);
        if (staticInit == null) {
            return;
        }
        new StaticLifter(classFile).liftStatics(staticInit);
    }

    private static void liftNonStaticInitialisers(ClassFile classFile, Options state) {
        new NonStaticLifter(classFile).liftNonStatics();
    }

    private static void removeDeadMethods(ClassFile classFile) {
        Method staticInit = CodeAnalyserWholeClass.getStaticConstructor(classFile);
        if (staticInit != null) {
            DeadMethodRemover.removeDeadMethod(classFile, staticInit);
        }
        CodeAnalyserWholeClass.tryRemoveConstructor(classFile);
    }

    private static void removeBoilerplateMethods(ClassFile classFile) {
        String[] removeThese;
        for (String methName : removeThese = new String[]{"$deserializeLambda$"}) {
            List<Method> methods = classFile.getMethodsByNameOrNull(methName);
            if (methods == null) continue;
            for (Method method : methods) {
                method.hideSynthetic();
            }
        }
    }

    private static void relinkConstantStrings(ClassFile classFile, DCCommonState state) {
        HashMap<String, Expression> rewrites = new HashMap<String, Expression>();
        HashSet<String> dupes = new HashSet<String>();
        ClassFile currClass = classFile;
        boolean local = true;
        while (currClass != null) {
            for (ClassFileField f : currClass.getFields()) {
                TypedLiteral lit;
                Object o;
                Field field = f.getField();
                boolean use = field.testAccessFlag(AccessFlag.ACC_STATIC) && field.testAccessFlag(AccessFlag.ACC_FINAL) && field.getJavaTypeInstance() == TypeConstants.STRING;
                if (!use || (o = (lit = field.getConstantValue()) == null ? null : lit.getValue()) == null) continue;
                if (!(o instanceof String)) {
                    return;
                }
                String val = (String)o;
                if (rewrites.containsKey(val)) {
                    dupes.add(val);
                    continue;
                }
                rewrites.put(val, new LValueExpression(new StaticVariable(currClass, f, local)));
            }
            if (!currClass.isInnerClass()) break;
            JavaRefTypeInstance parent = currClass.getClassType().getInnerClassHereInfo().getOuterClass();
            try {
                currClass = state.getClassFile(parent);
            }
            catch (Exception ignore) {
                currClass = null;
            }
            local = false;
        }
        for (String val : dupes) {
            rewrites.remove(val);
        }
        if (rewrites.isEmpty()) {
            return;
        }
        InlinedConstantRewriter rewriter = new InlinedConstantRewriter(rewrites);
        for (Method m : classFile.getMethods()) {
            if (!m.hasCodeAttribute()) {
                return;
            }
            Op04StructuredStatement code = m.getAnalysis();
            if (!code.isFullyStructured()) continue;
            rewriter.rewrite(code);
        }
    }

    private static void tryRemoveConstructor(ClassFile classFile) {
        List<Method> constructors = classFile.getConstructors();
        if (constructors.size() != 1) {
            return;
        }
        Method constructor = constructors.get(0);
        MethodPrototype methodPrototype = constructor.getMethodPrototype();
        if (methodPrototype.getVisibleArgCount() > 0) {
            return;
        }
        if (constructor.testAccessFlag(AccessFlagMethod.ACC_FINAL)) {
            return;
        }
        if (!constructor.testAccessFlag(AccessFlagMethod.ACC_PUBLIC)) {
            return;
        }
        if (!MiscStatementTools.isDeadCode(constructor.getAnalysis())) {
            return;
        }
        classFile.removePointlessMethod(constructor);
    }

    private static void removeIllegalGenerics(ClassFile classFile, Options state) {
        ConstantPool cp = classFile.getConstantPool();
        IllegalGenericRewriter r = new IllegalGenericRewriter(cp);
        for (Method m : classFile.getMethods()) {
            if (!m.hasCodeAttribute()) {
                return;
            }
            Op04StructuredStatement code = m.getAnalysis();
            if (!code.isFullyStructured()) continue;
            List<StructuredStatement> statements = MiscStatementTools.linearise(code);
            if (statements == null) {
                return;
            }
            for (StructuredStatement statement : statements) {
                statement.rewriteExpressions(r);
            }
            Op04StructuredStatement.removePrimitiveDeconversion(state, m, code);
        }
    }

    private static void resugarAsserts(ClassFile classFile, Options state) {
        Method staticInit = CodeAnalyserWholeClass.getStaticConstructor(classFile);
        if (staticInit != null) {
            new AssertRewriter(classFile).sugarAsserts(staticInit);
        }
    }

    private static void resugarJava14classObjects(ClassFile classFile, DCCommonState state) {
        new J14ClassObjectRewriter(classFile, state).rewrite();
    }

    public static void wholeClassAnalysisPass2(ClassFile classFile, DCCommonState state) {
        Options options = state.getOptions();
        if (((Boolean)options.getOption(OptionsImpl.REMOVE_INNER_CLASS_SYNTHETICS)).booleanValue()) {
            if (classFile.isInnerClass()) {
                CodeAnalyserWholeClass.fixInnerClassConstructorSyntheticOuterArgs(classFile);
            }
            CodeAnalyserWholeClass.replaceNestedSyntheticOuterRefs(classFile);
            CodeAnalyserWholeClass.inlineAccessors(state, classFile);
            CodeAnalyserWholeClass.renameAnonymousScopeHidingVariables(classFile, state.getClassCache());
        }
        if (((Boolean)options.getOption(OptionsImpl.REMOVE_DEAD_METHODS)).booleanValue()) {
            CodeAnalyserWholeClass.removeDeadMethods(classFile);
        }
        if (((Boolean)options.getOption(OptionsImpl.RELINK_CONSTANT_STRINGS)).booleanValue()) {
            CodeAnalyserWholeClass.relinkConstantStrings(classFile, state);
        }
    }
}

