/*
 * Decompiled with CFR 0.152.
 */
package org.benf.cfr.reader.bytecode.analysis.parse.utils.scope;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement;
import org.benf.cfr.reader.bytecode.analysis.parse.Expression;
import org.benf.cfr.reader.bytecode.analysis.parse.LValue;
import org.benf.cfr.reader.bytecode.analysis.parse.StatementContainer;
import org.benf.cfr.reader.bytecode.analysis.parse.lvalue.LocalVariable;
import org.benf.cfr.reader.bytecode.analysis.parse.lvalue.SentinelLocalClassLValue;
import org.benf.cfr.reader.bytecode.analysis.parse.lvalue.StackSSALabel;
import org.benf.cfr.reader.bytecode.analysis.parse.utils.Pair;
import org.benf.cfr.reader.bytecode.analysis.parse.utils.scope.LValueScopeDiscoverer;
import org.benf.cfr.reader.bytecode.analysis.structured.StructuredStatement;
import org.benf.cfr.reader.bytecode.analysis.structured.statement.Block;
import org.benf.cfr.reader.bytecode.analysis.types.JavaTypeInstance;
import org.benf.cfr.reader.bytecode.analysis.types.MethodPrototype;
import org.benf.cfr.reader.bytecode.analysis.types.discovery.InferredJavaType;
import org.benf.cfr.reader.bytecode.analysis.variables.NamedVariable;
import org.benf.cfr.reader.bytecode.analysis.variables.VariableFactory;
import org.benf.cfr.reader.util.Functional;
import org.benf.cfr.reader.util.ListFactory;
import org.benf.cfr.reader.util.MapFactory;
import org.benf.cfr.reader.util.functors.UnaryFunction;
import org.benf.cfr.reader.util.output.Dumper;

public class LValueScopeDiscovererImpl
implements LValueScopeDiscoverer {
    private final Map<NamedVariable, ScopeDefinition> earliestDefinition = MapFactory.newIdentityMap();
    private final Map<Integer, Map<NamedVariable, Boolean>> earliestDefinitionsByLevel = MapFactory.newLazyMap(new UnaryFunction<Integer, Map<NamedVariable, Boolean>>(){

        @Override
        public Map<NamedVariable, Boolean> invoke(Integer arg) {
            return MapFactory.newIdentityMap();
        }
    });
    private transient int currentDepth = 0;
    private transient Stack<StatementContainer<StructuredStatement>> currentBlock = new Stack();
    private final List<ScopeDefinition> discoveredCreations = ListFactory.newList();
    private final VariableFactory variableFactory;
    private StatementContainer<StructuredStatement> currentMark = null;

    public LValueScopeDiscovererImpl(MethodPrototype prototype, VariableFactory variableFactory) {
        List<LocalVariable> parameters = prototype.getComputedParameters();
        this.variableFactory = variableFactory;
        for (LocalVariable parameter : parameters) {
            InferredJavaType inferredJavaType = parameter.getInferredJavaType();
            ScopeDefinition prototypeScope = new ScopeDefinition(0, null, null, (LValue)parameter, inferredJavaType, parameter.getName());
            this.earliestDefinition.put(parameter.getName(), prototypeScope);
        }
    }

    @Override
    public void enterBlock(StructuredStatement structuredStatement) {
        Op04StructuredStatement container = structuredStatement.getContainer();
        this.currentBlock.push(container);
        ++this.currentDepth;
    }

    @Override
    public void mark(StatementContainer<StructuredStatement> mark) {
        this.currentMark = mark;
    }

    @Override
    public void leaveBlock(StructuredStatement structuredStatement) {
        for (NamedVariable definedHere : this.earliestDefinitionsByLevel.get(this.currentDepth).keySet()) {
            this.earliestDefinition.remove(definedHere);
        }
        this.earliestDefinitionsByLevel.remove(this.currentDepth);
        StatementContainer<StructuredStatement> oldContainer = this.currentBlock.pop();
        if (structuredStatement.getContainer() != oldContainer) {
            throw new IllegalStateException();
        }
        --this.currentDepth;
    }

    @Override
    public void collect(StackSSALabel lValue, StatementContainer<StructuredStatement> statementContainer, Expression value) {
    }

    @Override
    public void collectMultiUse(StackSSALabel lValue, StatementContainer<StructuredStatement> statementContainer, Expression value) {
    }

    @Override
    public void collectMutatedLValue(LValue lValue, StatementContainer<StructuredStatement> statementContainer, Expression value) {
    }

    @Override
    public void collectLocalVariableAssignment(LocalVariable localVariable, StatementContainer<StructuredStatement> statementContainer, Expression value) {
        JavaTypeInstance newType;
        localVariable.getInferredJavaType().collapseTypeClash();
        NamedVariable name = localVariable.getName();
        ScopeDefinition previousDef = this.earliestDefinition.get(name);
        if (previousDef == null) {
            JavaTypeInstance type = localVariable.getInferredJavaType().getJavaTypeInstance();
            ScopeDefinition scopeDefinition = new ScopeDefinition(this.currentDepth, this.currentBlock, statementContainer, localVariable, type, name, null);
            this.earliestDefinition.put(name, scopeDefinition);
            this.earliestDefinitionsByLevel.get(this.currentDepth).put(name, true);
            this.discoveredCreations.add(scopeDefinition);
            return;
        }
        JavaTypeInstance oldType = previousDef.getJavaTypeInstance();
        if (!oldType.equals(newType = localVariable.getInferredJavaType().getJavaTypeInstance())) {
            this.earliestDefinitionsByLevel.get(previousDef.getDepth()).remove(previousDef.getName());
            if (previousDef.getDepth() == this.currentDepth) {
                this.variableFactory.mutatingRenameUnClash(localVariable);
                name = localVariable.getName();
            }
            InferredJavaType inferredJavaType = localVariable.getInferredJavaType();
            ScopeDefinition scopeDefinition = new ScopeDefinition(this.currentDepth, this.currentBlock, statementContainer, (LValue)localVariable, inferredJavaType, name);
            this.earliestDefinition.put(name, scopeDefinition);
            this.earliestDefinitionsByLevel.get(this.currentDepth).put(name, true);
            this.discoveredCreations.add(scopeDefinition);
        }
    }

    public void markDiscoveredCreations() {
        Map<ScopeKey, List<ScopeDefinition>> definitionsByType = Functional.groupToMapBy(this.discoveredCreations, new UnaryFunction<ScopeDefinition, ScopeKey>(){

            @Override
            public ScopeKey invoke(ScopeDefinition arg) {
                return arg.getScopeKey();
            }
        });
        for (Map.Entry<ScopeKey, List<ScopeDefinition>> entry : definitionsByType.entrySet()) {
            StatementContainer hint;
            ScopeKey scopeKey = entry.getKey();
            List<ScopeDefinition> definitions = entry.getValue();
            List<StatementContainer<StructuredStatement>> commonScope = null;
            ScopeDefinition bestDefn = null;
            LValue scopedEntity = scopeKey.getlValue();
            for (ScopeDefinition definition : definitions) {
                StructuredStatement statement = definition.getStatementContainer().getStatement();
                if (statement.alwaysDefines(scopedEntity)) {
                    statement.markCreator(scopedEntity, null);
                    continue;
                }
                List<StatementContainer<StructuredStatement>> scopeList = definition.getNestedScope();
                if (scopeList.isEmpty()) {
                    scopeList = null;
                }
                if (scopeList == null) {
                    commonScope = null;
                    bestDefn = definition;
                    break;
                }
                if (commonScope == null) {
                    commonScope = scopeList;
                    bestDefn = definition;
                    continue;
                }
                if ((commonScope = LValueScopeDiscovererImpl.getCommonPrefix(commonScope, scopeList)).size() == scopeList.size()) {
                    bestDefn = definition;
                    continue;
                }
                bestDefn = null;
            }
            if (bestDefn != definitions.get(0)) {
                bestDefn = null;
            }
            StatementContainer<StructuredStatement> creationContainer = null;
            if (scopedEntity instanceof SentinelLocalClassLValue) {
                List<StatementContainer<StructuredStatement>> scope = null;
                if (bestDefn != null) {
                    scope = bestDefn.getNestedScope();
                } else if (commonScope != null) {
                    scope = commonScope;
                }
                if (scope != null) {
                    for (int i = scope.size() - 1; i >= 0; --i) {
                        StatementContainer<StructuredStatement> thisItem = scope.get(i);
                        if (!(thisItem.getStatement() instanceof Block)) continue;
                        Block block = (Block)thisItem.getStatement();
                        block.setIndenting(true);
                        creationContainer = thisItem;
                        break;
                    }
                }
            } else if (bestDefn != null) {
                creationContainer = bestDefn.getStatementContainer();
            } else if (commonScope != null) {
                creationContainer = (StatementContainer<StructuredStatement>)commonScope.get(commonScope.size() - 1);
            }
            StatementContainer statementContainer = hint = bestDefn == null ? null : bestDefn.localHint;
            if (creationContainer == null) continue;
            ((StructuredStatement)creationContainer.getStatement()).markCreator(scopedEntity, hint);
        }
    }

    private static <T> List<T> getCommonPrefix(List<T> a, List<T> b) {
        List<T> lb;
        List<T> la;
        if (a.size() < b.size()) {
            la = a;
            lb = b;
        } else {
            la = b;
            lb = a;
        }
        int maxRes = Math.min(la.size(), lb.size());
        int sameLen = 0;
        int x = 0;
        while (x < maxRes && la.get(x).equals(lb.get(x))) {
            ++x;
            ++sameLen;
        }
        if (sameLen == la.size()) {
            return la;
        }
        return la.subList(0, sameLen);
    }

    @Override
    public void collect(LValue lValue) {
        Class<?> lValueClass = lValue.getClass();
        if (lValueClass == LocalVariable.class) {
            LocalVariable localVariable = (LocalVariable)lValue;
            NamedVariable name = localVariable.getName();
            if (name.getStringName().equals("this")) {
                return;
            }
            ScopeDefinition previousDef = this.earliestDefinition.get(name);
            if (previousDef != null) {
                return;
            }
            InferredJavaType inferredJavaType = lValue.getInferredJavaType();
            ScopeDefinition scopeDefinition = new ScopeDefinition(this.currentDepth, this.currentBlock, this.currentBlock.peek(), lValue, inferredJavaType, name);
            this.earliestDefinition.put(name, scopeDefinition);
            this.earliestDefinitionsByLevel.get(this.currentDepth).put(name, true);
            this.discoveredCreations.add(scopeDefinition);
        } else if (lValueClass == SentinelLocalClassLValue.class) {
            SentinelLocalClassLValue localClassLValue = (SentinelLocalClassLValue)lValue;
            SentinelNV name = new SentinelNV(localClassLValue.getLocalClassType());
            ScopeDefinition previousDef = this.earliestDefinition.get(name);
            if (previousDef != null) {
                return;
            }
            JavaTypeInstance type = localClassLValue.getLocalClassType();
            ScopeDefinition scopeDefinition = new ScopeDefinition(this.currentDepth, this.currentBlock, this.currentBlock.peek(), lValue, type, name, this.currentMark);
            this.earliestDefinition.put(name, scopeDefinition);
            this.earliestDefinitionsByLevel.get(this.currentDepth).put(name, true);
            this.discoveredCreations.add(scopeDefinition);
        }
    }

    private static class ScopeDefinition {
        private final int depth;
        private final List<StatementContainer<StructuredStatement>> nestedScope;
        private final StatementContainer<StructuredStatement> exactStatement;
        private final StatementContainer<StructuredStatement> localHint;
        private final LValue lValue;
        private final JavaTypeInstance lValueType;
        private final NamedVariable name;
        private final ScopeKey scopeKey;

        private ScopeDefinition(int depth, Stack<StatementContainer<StructuredStatement>> nestedScope, StatementContainer<StructuredStatement> exactStatement, LValue lValue, InferredJavaType inferredJavaType, NamedVariable name) {
            this(depth, nestedScope, exactStatement, lValue, ScopeDefinition.getUnclashedType(inferredJavaType), name, null);
        }

        private static JavaTypeInstance getUnclashedType(InferredJavaType inferredJavaType) {
            if (inferredJavaType.isClash()) {
                inferredJavaType.collapseTypeClash();
            }
            return inferredJavaType.getJavaTypeInstance();
        }

        private ScopeDefinition(int depth, Stack<StatementContainer<StructuredStatement>> nestedScope, StatementContainer<StructuredStatement> exactStatement, LValue lValue, JavaTypeInstance type, NamedVariable name, StatementContainer<StructuredStatement> hint) {
            this.depth = depth;
            Pair<List<StatementContainer<StructuredStatement>>, StatementContainer<StructuredStatement>> adjustedScope = ScopeDefinition.getBestScopeFor(lValue, nestedScope, exactStatement);
            this.nestedScope = adjustedScope.getFirst();
            this.exactStatement = adjustedScope.getSecond();
            this.lValue = lValue;
            this.lValueType = type;
            this.name = name;
            this.localHint = hint;
            this.scopeKey = new ScopeKey(lValue, type);
        }

        private static Pair<List<StatementContainer<StructuredStatement>>, StatementContainer<StructuredStatement>> getBestScopeFor(LValue lValue, Collection<StatementContainer<StructuredStatement>> nestedScope, StatementContainer<StructuredStatement> exactStatement) {
            StatementContainer<StructuredStatement> scopeTest;
            if (nestedScope == null) {
                return Pair.make(null, exactStatement);
            }
            List<StatementContainer<StructuredStatement>> scope = ListFactory.newList(nestedScope);
            if (exactStatement != null && exactStatement.getStatement().alwaysDefines(lValue)) {
                return Pair.make(scope, exactStatement);
            }
            if (scope.isEmpty()) {
                return Pair.make(scope, exactStatement);
            }
            for (int x = scope.size() - 1; x >= 0 && !(scopeTest = scope.get(x)).getStatement().canDefine(lValue); --x) {
                scope.remove(x);
            }
            if (scope.size() == nestedScope.size()) {
                return Pair.make(scope, exactStatement);
            }
            if (scope.isEmpty()) {
                return Pair.make(null, exactStatement);
            }
            exactStatement = scope.get(scope.size() - 1);
            return Pair.make(scope, exactStatement);
        }

        public JavaTypeInstance getJavaTypeInstance() {
            return this.lValueType;
        }

        public StatementContainer<StructuredStatement> getStatementContainer() {
            return this.exactStatement;
        }

        public LValue getlValue() {
            return this.lValue;
        }

        public int getDepth() {
            return this.depth;
        }

        public NamedVariable getName() {
            return this.name;
        }

        public ScopeKey getScopeKey() {
            return this.scopeKey;
        }

        public List<StatementContainer<StructuredStatement>> getNestedScope() {
            return this.nestedScope;
        }

        public String toString() {
            return this.name + " : " + this.lValueType.getRawName();
        }
    }

    private static class SentinelNV
    implements NamedVariable {
        private final JavaTypeInstance typeInstance;

        private SentinelNV(JavaTypeInstance typeInstance) {
            this.typeInstance = typeInstance;
        }

        @Override
        public void forceName(String name) {
        }

        @Override
        public String getStringName() {
            return this.typeInstance.getRawName();
        }

        @Override
        public boolean isGoodName() {
            return true;
        }

        @Override
        public Dumper dump(Dumper d) {
            return null;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SentinelNV that = (SentinelNV)o;
            return !(this.typeInstance != null ? !this.typeInstance.equals(that.typeInstance) : that.typeInstance != null);
        }

        public int hashCode() {
            return this.typeInstance != null ? this.typeInstance.hashCode() : 0;
        }
    }

    private static class ScopeKey {
        private final LValue lValue;
        private final JavaTypeInstance type;

        private ScopeKey(LValue lValue, JavaTypeInstance type) {
            this.lValue = lValue;
            this.type = type;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ScopeKey scopeKey = (ScopeKey)o;
            if (!this.lValue.equals(scopeKey.lValue)) {
                return false;
            }
            return this.type.equals(scopeKey.type);
        }

        private LValue getlValue() {
            return this.lValue;
        }

        public int hashCode() {
            int result = this.lValue.hashCode();
            result = 31 * result + this.type.hashCode();
            return result;
        }
    }
}

