/*
 * Decompiled with CFR 0.152.
 */
package org.benf.cfr.reader.util.output;

import java.util.List;
import java.util.Set;
import org.benf.cfr.reader.bytecode.analysis.parse.utils.Pair;
import org.benf.cfr.reader.bytecode.analysis.types.JavaTypeInstance;
import org.benf.cfr.reader.state.CaseSensitiveFileSystemHelper;
import org.benf.cfr.reader.state.TypeUsageInformation;
import org.benf.cfr.reader.util.DecompilerComment;
import org.benf.cfr.reader.util.DecompilerCommentSource;
import org.benf.cfr.reader.util.ListFactory;
import org.benf.cfr.reader.util.SetFactory;
import org.benf.cfr.reader.util.Troolean;
import org.benf.cfr.reader.util.getopt.Options;
import org.benf.cfr.reader.util.getopt.OptionsImpl;
import org.benf.cfr.reader.util.output.Dumper;
import org.benf.cfr.reader.util.output.DumperFactory;
import org.benf.cfr.reader.util.output.FileDumper;
import org.benf.cfr.reader.util.output.FileSummaryDumper;
import org.benf.cfr.reader.util.output.IllegalIdentifierDump;
import org.benf.cfr.reader.util.output.NopSummaryDumper;
import org.benf.cfr.reader.util.output.ProgressDumper;
import org.benf.cfr.reader.util.output.ProgressDumperNop;
import org.benf.cfr.reader.util.output.ProgressDumperStdErr;
import org.benf.cfr.reader.util.output.StdIODumper;
import org.benf.cfr.reader.util.output.SummaryDumper;

public class DumperFactoryImpl
implements DumperFactory {
    private final boolean checkDupes;
    private Set<String> seen = SetFactory.newSet();
    private boolean seenCaseDupe = false;
    private final Options options;
    private final ProgressDumper progressDumper;

    public DumperFactoryImpl(Options options) {
        this.checkDupes = CaseSensitiveFileSystemHelper.IsCaseSensitive() && (Boolean)options.getOption(OptionsImpl.CASE_INSENSITIVE_FS_RENAME) == false;
        this.options = options;
        this.progressDumper = (Boolean)options.getOption(OptionsImpl.SILENT) == false && (options.optionIsSet(OptionsImpl.OUTPUT_DIR) || options.optionIsSet(OptionsImpl.OUTPUT_PATH)) ? new ProgressDumperStdErr() : ProgressDumperNop.INSTANCE;
    }

    private static Pair<String, Boolean> getPathAndClobber(Options options) {
        Troolean clobber = (Troolean)((Object)options.getOption(OptionsImpl.CLOBBER_FILES));
        if (options.optionIsSet(OptionsImpl.OUTPUT_DIR)) {
            return Pair.make(options.getOption(OptionsImpl.OUTPUT_DIR), clobber.boolValue(true));
        }
        if (options.optionIsSet(OptionsImpl.OUTPUT_PATH)) {
            return Pair.make(options.getOption(OptionsImpl.OUTPUT_PATH), clobber.boolValue(false));
        }
        return null;
    }

    @Override
    public Dumper getNewTopLevelDumper(JavaTypeInstance classType, SummaryDumper summaryDumper, TypeUsageInformation typeUsageInformation, IllegalIdentifierDump illegalIdentifierDump) {
        Pair<String, Boolean> targetInfo = DumperFactoryImpl.getPathAndClobber(this.options);
        if (targetInfo == null) {
            return new StdIODumper(typeUsageInformation, this.options, illegalIdentifierDump);
        }
        FileDumper res = new FileDumper(targetInfo.getFirst(), targetInfo.getSecond(), classType, summaryDumper, typeUsageInformation, this.options, illegalIdentifierDump);
        if (this.checkDupes && this.seen.add(res.getFileName().toLowerCase())) {
            this.seenCaseDupe = true;
        }
        return res;
    }

    @Override
    public SummaryDumper getSummaryDumper() {
        Pair<String, Boolean> targetInfo = DumperFactoryImpl.getPathAndClobber(this.options);
        if (targetInfo == null) {
            return new NopSummaryDumper();
        }
        return new FileSummaryDumper(targetInfo.getFirst(), this.options, new AdditionalComments());
    }

    @Override
    public ProgressDumper getProgressDumper() {
        return this.progressDumper;
    }

    private class AdditionalComments
    implements DecompilerCommentSource {
        private AdditionalComments() {
        }

        @Override
        public List<DecompilerComment> getComments() {
            if (DumperFactoryImpl.this.seenCaseDupe) {
                List<DecompilerComment> res = ListFactory.newList();
                res.add(DecompilerComment.CASE_CLASH_FS);
                return res;
            }
            return null;
        }
    }
}

