/*
 * Decompiled with CFR 0.152.
 */
package org.benf.cfr.reader.state;

import java.util.Set;
import org.benf.cfr.reader.bytecode.analysis.types.InnerClassInfo;
import org.benf.cfr.reader.bytecode.analysis.types.JavaRefTypeInstance;
import org.benf.cfr.reader.bytecode.analysis.types.JavaTypeInstance;
import org.benf.cfr.reader.entities.ClassFile;
import org.benf.cfr.reader.state.AbstractTypeUsageCollector;
import org.benf.cfr.reader.state.TypeUsageInformation;
import org.benf.cfr.reader.state.TypeUsageInformationImpl;
import org.benf.cfr.reader.util.collections.SetFactory;
import org.benf.cfr.reader.util.getopt.Options;

public class TypeUsageCollectorImpl
extends AbstractTypeUsageCollector {
    private final Options options;
    private final JavaRefTypeInstance analysisType;
    private final Set<JavaRefTypeInstance> typeInstanceSet = SetFactory.newSet();
    private final Set<JavaTypeInstance> seen = SetFactory.newSet();

    public TypeUsageCollectorImpl(Options options, ClassFile analysisClass) {
        this.options = options;
        this.analysisType = (JavaRefTypeInstance)analysisClass.getClassType().getDeGenerifiedType();
    }

    @Override
    public void collectRefType(JavaRefTypeInstance type) {
        this.typeInstanceSet.add(type);
    }

    @Override
    public void collect(JavaTypeInstance type) {
        if (type == null) {
            return;
        }
        if (this.seen.add(type)) {
            type.collectInto(this);
            InnerClassInfo innerClassInfo = type.getInnerClassHereInfo();
            if (innerClassInfo.isInnerClass()) {
                this.collect(innerClassInfo.getOuterClass());
            }
        }
    }

    @Override
    public TypeUsageInformation getTypeUsageInformation() {
        return new TypeUsageInformationImpl(this.options, this.analysisType, this.typeInstanceSet);
    }

    @Override
    public boolean isStatementRecursive() {
        return true;
    }
}

