//  Copyright © 2014-present BetterJapanese
//  
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.

package org.betterjapanese.spock.extension

import java.lang.annotation.Retention
import java.lang.annotation.RetentionPolicy
import java.lang.annotation.ElementType
import java.lang.annotation.Target
import java.lang.annotation.Documented

/**
 * Annotates a feature method, runs {@code cleanupFeature()} 
 * (or a specified method) once after the feature method.
 */
@Documented
@org.spockframework.runtime.extension.ExtensionAnnotation(CleanupFeatureExtension)
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.METHOD)
public @interface CleanupFeature {
    String value() default 'cleanupFeature'
}
