//  Copyright © 2014-present BetterJapanese
//  
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.

package org.betterjapanese.spock.extension

import org.spockframework.runtime.extension.AbstractMethodInterceptor
import org.spockframework.runtime.extension.IMethodInvocation

class SetupFeatureInterceptor extends AbstractMethodInterceptor {

    String invokee

    @Override
    void interceptFeatureExecution(IMethodInvocation invocation) 
    throws Throwable {
        invocation.sharedInstance."$invokee"()
        invocation.proceed()
    }
}
