/*
 * Decompiled with CFR 0.152.
 */
package com.embeddedunveiled.serial;

import com.embeddedunveiled.serial.SerialComException;
import com.embeddedunveiled.serial.SerialComManager;
import com.embeddedunveiled.serial.internal.ISerialIOStream;
import com.embeddedunveiled.serial.internal.SerialComPortHandleInfo;
import java.io.IOException;
import java.io.InputStream;

public final class SerialComInByteStream
extends InputStream
implements ISerialIOStream {
    private final SerialComManager scm;
    private final SerialComPortHandleInfo portHandleInfo;
    private final long handle;
    private final Object lock = new Object();
    private boolean isOpened;
    private boolean isBlocking;
    private long context;

    public SerialComInByteStream(SerialComManager scm, SerialComPortHandleInfo portHandleInfo, long handle, SerialComManager.SMODE streamMode) throws SerialComException {
        this.scm = scm;
        this.portHandleInfo = portHandleInfo;
        this.handle = handle;
        if (streamMode.getValue() == 1) {
            this.context = scm.createBlockingIOContext();
            this.isBlocking = true;
        }
        this.isOpened = true;
    }

    @Override
    public int available() throws IOException {
        if (!this.isOpened) {
            throw new IOException("The byte stream has been closed !");
        }
        int[] numBytesAvailable = new int[2];
        try {
            numBytesAvailable = this.scm.getByteCountInPortIOBuffer(this.handle);
        }
        catch (SerialComException e) {
            throw new IOException(e.getExceptionMsg());
        }
        return numBytesAvailable[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (!this.isOpened) {
            throw new IOException("The byte stream has been closed !");
        }
        if (this.isBlocking) {
            this.scm.unblockBlockingIOOperation(this.context);
            Object object = this.lock;
            synchronized (object) {
                this.scm.destroyBlockingIOContext(this.context);
            }
        }
        this.portHandleInfo.setSerialComInByteStream(null);
        this.isOpened = false;
    }

    @Override
    public void mark(int a) {
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public int read() throws IOException {
        if (!this.isOpened) {
            throw new IOException("The byte stream has been closed !");
        }
        try {
            if (this.isBlocking) {
                Object object = this.lock;
                synchronized (object) {
                    byte[] data;
                    try {
                        data = this.scm.readBytesBlocking(this.handle, 1, this.context);
                    }
                    catch (SerialComException e) {
                        if ("I/O operation unblocked !".equals(e.getExceptionMsg())) {
                            return -1;
                        }
                        throw new IOException(e.getExceptionMsg());
                    }
                    if (data != null) {
                        return data[0];
                    }
                    throw new IOException("Unknown error occured in native layer !");
                }
            }
            byte[] data = this.scm.readBytes(this.handle, 1);
            if (data != null) {
                return data[0];
            }
            return -1;
        }
        catch (SerialComException e) {
            throw new IOException(e.getExceptionMsg());
        }
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (!this.isOpened) {
            throw new IOException("The byte stream has been closed !");
        }
        if (b == null) {
            throw new NullPointerException("Null data buffer passed to read operation !");
        }
        if (off < 0 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException("Index violation detected in given byte array !");
        }
        if (len == 0) {
            return 0;
        }
        if (!(b instanceof byte[])) {
            throw new IllegalArgumentException("The given data array is not byte type array !");
        }
        int i = off;
        try {
            if (this.isBlocking) {
                Object object = this.lock;
                synchronized (object) {
                    byte[] data;
                    try {
                        data = this.scm.readBytesBlocking(this.handle, len, this.context);
                    }
                    catch (SerialComException e) {
                        if ("I/O operation unblocked !".equals(e.getExceptionMsg())) {
                            return -1;
                        }
                        throw new IOException(e.getExceptionMsg());
                    }
                    if (data != null) {
                        for (int x = 0; x < data.length; ++x) {
                            b[i] = data[x];
                            ++i;
                        }
                        return data.length;
                    }
                    throw new IOException("Unknown error occured in native layer !");
                }
            }
            byte[] data = this.scm.readBytes(this.handle, len);
            if (data != null) {
                for (int x = 0; x < data.length; ++x) {
                    b[i] = data[x];
                    ++i;
                }
                return data.length;
            }
            return -1;
        }
        catch (SerialComException e) {
            throw new IOException(e.getExceptionMsg());
        }
    }

    @Override
    public synchronized void reset() throws IOException {
    }

    @Override
    public long skip(long number) {
        return 0L;
    }
}

