/*
 * Decompiled with CFR 0.152.
 */
package com.embeddedunveiled.serial;

import com.embeddedunveiled.serial.ISerialComDataListener;
import com.embeddedunveiled.serial.ISerialComEventListener;
import com.embeddedunveiled.serial.ISerialComUSBHotPlugListener;
import com.embeddedunveiled.serial.SerialComException;
import com.embeddedunveiled.serial.SerialComIOCTLExecutor;
import com.embeddedunveiled.serial.SerialComInByteStream;
import com.embeddedunveiled.serial.SerialComLoadException;
import com.embeddedunveiled.serial.SerialComOutByteStream;
import com.embeddedunveiled.serial.SerialComUnexpectedException;
import com.embeddedunveiled.serial.bluetooth.SerialComBluetooth;
import com.embeddedunveiled.serial.bluetooth.SerialComBluetoothSPPDevNode;
import com.embeddedunveiled.serial.comdb.SerialComDBRelease;
import com.embeddedunveiled.serial.ftp.ISerialComXmodemProgress;
import com.embeddedunveiled.serial.ftp.ISerialComYmodemProgress;
import com.embeddedunveiled.serial.ftp.SerialComFTPCMDAbort;
import com.embeddedunveiled.serial.ftp.SerialComXModem;
import com.embeddedunveiled.serial.ftp.SerialComXModem1K;
import com.embeddedunveiled.serial.ftp.SerialComXModemCRC;
import com.embeddedunveiled.serial.ftp.SerialComYModem1K;
import com.embeddedunveiled.serial.ftp.SerialComYModemCRC;
import com.embeddedunveiled.serial.hid.SerialComHID;
import com.embeddedunveiled.serial.hid.SerialComRawHID;
import com.embeddedunveiled.serial.internal.ISerialComFTPProgress;
import com.embeddedunveiled.serial.internal.ISerialIOStream;
import com.embeddedunveiled.serial.internal.SerialComBluetoothJNIBridge;
import com.embeddedunveiled.serial.internal.SerialComCompletionDispatcher;
import com.embeddedunveiled.serial.internal.SerialComDBReleaseJNIBridge;
import com.embeddedunveiled.serial.internal.SerialComHIDJNIBridge;
import com.embeddedunveiled.serial.internal.SerialComLooper;
import com.embeddedunveiled.serial.internal.SerialComPlatform;
import com.embeddedunveiled.serial.internal.SerialComPortHandleInfo;
import com.embeddedunveiled.serial.internal.SerialComPortJNIBridge;
import com.embeddedunveiled.serial.internal.SerialComPortMapperJNIBridge;
import com.embeddedunveiled.serial.internal.SerialComPortsList;
import com.embeddedunveiled.serial.internal.SerialComSystemProperty;
import com.embeddedunveiled.serial.mapper.SerialComPortMapper;
import com.embeddedunveiled.serial.nullmodem.SerialComNullModem;
import com.embeddedunveiled.serial.usb.SerialComUSB;
import com.embeddedunveiled.serial.usb.SerialComUSBdevice;
import com.embeddedunveiled.serial.vendor.SerialComVendorLib;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.TreeMap;

public final class SerialComManager {
    public static final String JAVA_LIB_VERSION = "1.0.4";
    public static final int OS_UNKNOWN = 0;
    public static final int OS_LINUX = 1;
    public static final int OS_WINDOWS = 2;
    public static final int OS_SOLARIS = 3;
    public static final int OS_MAC_OS_X = 4;
    public static final int OS_FREEBSD = 5;
    public static final int OS_NETBSD = 6;
    public static final int OS_OPENBSD = 7;
    public static final int OS_IBM_AIX = 8;
    public static final int OS_HP_UX = 9;
    public static final int OS_ANDROID = 10;
    public static final int ARCH_UNKNOWN = 0;
    public static final int ARCH_X86 = 1;
    public static final int ARCH_AMD64 = 2;
    public static final int ARCH_IA64 = 3;
    public static final int ARCH_IA64_32 = 4;
    public static final int ARCH_PPC32 = 5;
    public static final int ARCH_PPC64 = 6;
    public static final int ARCH_PPC64LE = 6;
    public static final int ARCH_SPARC32 = 7;
    public static final int ARCH_SPARC64 = 8;
    public static final int ARCH_PA_RISC32 = 9;
    public static final int ARCH_PA_RISC64 = 10;
    public static final int ARCH_S390 = 11;
    public static final int ARCH_S390X = 12;
    public static final int ARCH_ARMV5 = 13;
    public static final int ARCH_ARMV6 = 14;
    public static final int ARCH_ARMV7 = 15;
    public static final int ABI_ARMHF = 1;
    public static final int ABI_ARMEL = 2;
    public static final int DEFAULT_READBYTECOUNT = 1024;
    public static final int CTS = 1;
    public static final int DSR = 2;
    public static final int DCD = 4;
    public static final int RI = 8;
    public static final int LOOP = 16;
    public static final int RTS = 32;
    public static final int DTR = 64;
    public static final int InputStream = 50;
    public static final int OutputStream = 51;
    public static final String EXP_UNBLOCKIO = "I/O operation unblocked !";
    private final TreeMap<Long, SerialComPortHandleInfo> mPortHandleInfo = new TreeMap();
    private SerialComIOCTLExecutor mSerialComIOCTLExecutor;
    private SerialComUSB mSerialComUSB;
    private SerialComPlatform mSerialComPlatform;
    private final SerialComSystemProperty mSerialComSystemProperty;
    private final SerialComPortJNIBridge mComPortJNIBridge;
    private final SerialComCompletionDispatcher mEventCompletionDispatcher;
    private final SerialComPortsList mSerialComPortsList;
    private final Object lockB = new Object();
    private static int osType;
    private static int cpuArch;
    private static int javaABIType;
    private static final Object lockA;
    private static boolean nativeLibLoadAndInitAlready;
    private static SerialComVendorLib mSerialComVendorLib;
    private static SerialComNullModem mSerialComNullModem;
    private static SerialComHIDJNIBridge mSerialComHIDJNIBridge;
    private static SerialComBluetoothJNIBridge mSerialComBluetoothJNIBridge;
    private static SerialComPortMapperJNIBridge mSerialComPortMapperJNIBridge;
    private static SerialComDBReleaseJNIBridge mSerialComDBReleaseJNIBridge;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SerialComManager() throws SecurityException, IOException {
        this.mSerialComSystemProperty = new SerialComSystemProperty();
        Object object = lockA;
        synchronized (object) {
            if (osType <= 0) {
                this.mSerialComPlatform = new SerialComPlatform(this.mSerialComSystemProperty);
                osType = this.mSerialComPlatform.getOSType();
                if (osType == 0) {
                    throw new SerialComException("Could not identify operating system. Please report to us your environemnt so that we can add support for it !");
                }
                cpuArch = this.mSerialComPlatform.getCPUArch(osType);
                if (cpuArch == 0) {
                    throw new SerialComException("Could not identify CPU architecture. Please report to us your environemnt so that we can add support for it !");
                }
                if ((cpuArch == 15 || cpuArch == 14 || cpuArch == 13) && osType == 1) {
                    javaABIType = this.mSerialComPlatform.getJAVAABIType();
                }
            }
        }
        this.mComPortJNIBridge = new SerialComPortJNIBridge();
        if (!nativeLibLoadAndInitAlready) {
            SerialComPortJNIBridge.loadNativeLibrary(null, null, this.mSerialComSystemProperty, osType, cpuArch, javaABIType);
            this.mComPortJNIBridge.initNativeLib();
            nativeLibLoadAndInitAlready = true;
        }
        this.mEventCompletionDispatcher = new SerialComCompletionDispatcher(this.mComPortJNIBridge, this.mPortHandleInfo);
        this.mSerialComPortsList = new SerialComPortsList(this.mComPortJNIBridge, osType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SerialComManager(String loadedLibName, String directoryPath, boolean createDirectory) throws SecurityException, IOException {
        if (directoryPath == null) {
            throw new IllegalArgumentException("Argument directoryPath can not be null !");
        }
        if (directoryPath.length() == 0) {
            throw new IllegalArgumentException("Argument directoryPath can not be empty string !");
        }
        if (createDirectory) {
            File extractionDirectory = new File(directoryPath);
            extractionDirectory.mkdirs();
        }
        if (loadedLibName == null) {
            throw new IllegalArgumentException("Argument loadedLibName can not be null !");
        }
        if (loadedLibName.length() == 0) {
            throw new IllegalArgumentException("Argument loadedLibName can not be empty string !");
        }
        this.mSerialComSystemProperty = new SerialComSystemProperty();
        Object object = lockA;
        synchronized (object) {
            if (osType <= 0) {
                this.mSerialComPlatform = new SerialComPlatform(this.mSerialComSystemProperty);
                osType = this.mSerialComPlatform.getOSType();
                if (osType == 0) {
                    throw new SerialComException("Could not identify operating system. Please report to us your environemnt so that we can add support for it !");
                }
                cpuArch = this.mSerialComPlatform.getCPUArch(osType);
                if (cpuArch == 0) {
                    throw new SerialComException("Could not identify CPU architecture. Please report to us your environemnt so that we can add support for it !");
                }
                if ((cpuArch == 15 || cpuArch == 14 || cpuArch == 13) && osType == 1) {
                    javaABIType = this.mSerialComPlatform.getJAVAABIType();
                }
            }
        }
        this.mComPortJNIBridge = new SerialComPortJNIBridge();
        if (!nativeLibLoadAndInitAlready) {
            SerialComPortJNIBridge.loadNativeLibrary(directoryPath, loadedLibName, this.mSerialComSystemProperty, osType, cpuArch, javaABIType);
            this.mComPortJNIBridge.initNativeLib();
            nativeLibLoadAndInitAlready = true;
        }
        this.mEventCompletionDispatcher = new SerialComCompletionDispatcher(this.mComPortJNIBridge, this.mPortHandleInfo);
        this.mSerialComPortsList = new SerialComPortsList(this.mComPortJNIBridge, osType);
    }

    public String getLibraryVersions() throws SerialComException {
        String version = null;
        String nativeLibversion = this.mComPortJNIBridge.getNativeLibraryVersion();
        version = nativeLibversion != null ? "Java lib version: 1.0.4\nNative lib version: " + nativeLibversion : "Java lib version: 1.0.4\nNative lib version: ?????";
        return version;
    }

    public int getOSType() {
        return osType;
    }

    public int getCPUArchitecture() {
        return cpuArch;
    }

    public String[] listAvailableComPorts() throws SerialComException {
        String[] availablePorts = this.mSerialComPortsList.listAvailableComPorts();
        if (availablePorts != null) {
            return availablePorts;
        }
        return new String[0];
    }

    public SerialComUSBdevice[] listUSBdevicesWithInfo(int vendorFilter) throws SerialComException {
        int i = 0;
        int numOfDevices = 0;
        SerialComUSBdevice[] usbDevicesFound = null;
        if (vendorFilter < 0 || vendorFilter > 65535) {
            throw new IllegalArgumentException("Argument vendorFilter can not be negative or greater than 0xFFFF !");
        }
        String[] usbDevicesInfo = this.mComPortJNIBridge.listUSBdevicesWithInfo(vendorFilter);
        if (usbDevicesInfo != null) {
            if (usbDevicesInfo.length < 4) {
                return new SerialComUSBdevice[0];
            }
            numOfDevices = usbDevicesInfo.length / 6;
            usbDevicesFound = new SerialComUSBdevice[numOfDevices];
            for (int x = 0; x < numOfDevices; ++x) {
                usbDevicesFound[x] = new SerialComUSBdevice(usbDevicesInfo[i], usbDevicesInfo[i + 1], usbDevicesInfo[i + 2], usbDevicesInfo[i + 3], usbDevicesInfo[i + 4], usbDevicesInfo[i + 5]);
                i += 6;
            }
            return usbDevicesFound;
        }
        throw new SerialComException("Could not find USB devices. Please retry !");
    }

    public String[] findComPortFromUSBAttributes(int usbVidToMatch, int usbPidToMatch, String serialNumber) throws SerialComException {
        String[] comPortsInfo;
        if (usbVidToMatch < 0 || usbVidToMatch > 65535) {
            throw new IllegalArgumentException("Argument usbVidToMatch can not be negative or greater than 0xFFFF !");
        }
        if (usbPidToMatch < 0 || usbPidToMatch > 65535) {
            throw new IllegalArgumentException("Argument usbPidToMatch can not be negative or greater than 0xFFFF !");
        }
        String serialNum = null;
        if (serialNumber != null) {
            serialNum = serialNumber.toLowerCase();
        }
        if ((comPortsInfo = this.mComPortJNIBridge.findComPortFromUSBAttribute(usbVidToMatch, usbPidToMatch, serialNum)) == null) {
            throw new SerialComException("Could not find COM port for given device. Please retry !");
        }
        return comPortsInfo;
    }

    public SerialComBluetoothSPPDevNode[] listBTSPPDevNodesWithInfo() throws SerialComException {
        int i = 0;
        int numOfDevices = 0;
        SerialComBluetoothSPPDevNode[] btSerialNodesFound = null;
        String[] btSerialNodesInfo = this.mComPortJNIBridge.listBTSPPDevNodesWithInfo();
        if (btSerialNodesInfo != null) {
            if (btSerialNodesInfo.length < 2) {
                return new SerialComBluetoothSPPDevNode[0];
            }
            numOfDevices = btSerialNodesInfo.length / 3;
            btSerialNodesFound = new SerialComBluetoothSPPDevNode[numOfDevices];
            for (int x = 0; x < numOfDevices; ++x) {
                btSerialNodesFound[x] = new SerialComBluetoothSPPDevNode(btSerialNodesInfo[i], btSerialNodesInfo[i + 1], btSerialNodesInfo[i + 2]);
                i += 3;
            }
            return btSerialNodesFound;
        }
        throw new SerialComException("Could not find HID devices. Please retry !");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long openComPort(String portName, boolean enableRead, boolean enableWrite, boolean exclusiveOwnerShip) throws SerialComException {
        long handle = 0L;
        SerialComPortHandleInfo handleInfo = null;
        if (portName == null) {
            throw new IllegalArgumentException("Argument portName can not be null !");
        }
        String portNameVal = portName.trim();
        if (portNameVal.length() == 0) {
            throw new IllegalArgumentException("Name of the port to be opened can not be empty string !");
        }
        if (!enableRead && !enableWrite) {
            throw new IllegalArgumentException("Arguments enableRead and enableWrite both can not be set to false !");
        }
        if (this.getOSType() == 2 && !exclusiveOwnerShip) {
            throw new IllegalArgumentException("Windows OS does not allow port sharing; exclusiveOwnerShip must be true !");
        }
        Object object = this.lockB;
        synchronized (object) {
            if (exclusiveOwnerShip) {
                for (Map.Entry<Long, SerialComPortHandleInfo> entry : this.mPortHandleInfo.entrySet()) {
                    handleInfo = entry.getValue();
                    if (handleInfo == null || !handleInfo.containsPort(portNameVal)) continue;
                    throw new IllegalStateException("The port " + portNameVal + " is already opened. Exclusive ownership can not be claimed !");
                }
            }
            if ((handle = this.mComPortJNIBridge.openComPort(portNameVal, enableRead, enableWrite, exclusiveOwnerShip)) < 0L) {
                throw new SerialComException("Could not open the port " + portNameVal + ". Please retry !");
            }
            this.mPortHandleInfo.put(handle, new SerialComPortHandleInfo(portNameVal, handle, null, null, null));
        }
        return handle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean closeComPort(long handle) throws SerialComException {
        SerialComPortHandleInfo handleInfo = null;
        Object object = this.lockB;
        synchronized (object) {
            handleInfo = this.mPortHandleInfo.get(handle);
            if (handleInfo == null) {
                throw new SerialComException("Given handle does not represent a serial port opened through SCM !");
            }
            if (handleInfo.getDataListener() != null) {
                throw new IllegalStateException("Closing port without unregistering data listener is not allowed to prevent inconsistency !");
            }
            if (handleInfo.getEventListener() != null) {
                throw new IllegalStateException("Closing port without unregistering event listener is not allowed to prevent inconsistency !");
            }
            if (handleInfo.getSerialComInByteStream() != null) {
                throw new IllegalStateException("Input byte stream must be closed before closing the serial port !");
            }
            if (handleInfo.getSerialComOutByteStream() != null) {
                throw new IllegalStateException("Output byte stream must be closed before closing the serial port !");
            }
            int ret = this.mComPortJNIBridge.closeComPort(handle);
            if (ret < 0) {
                throw new SerialComException("Could not close the given serial port. Please retry !");
            }
            this.mPortHandleInfo.remove(handle);
        }
        return true;
    }

    public boolean writeBytes(long handle, byte[] buffer, int delay) throws SerialComException {
        if (buffer == null) {
            throw new IllegalArgumentException("Argumenet buffer can not be null !");
        }
        if (buffer.length == 0) {
            return false;
        }
        if (delay < 0) {
            throw new IllegalArgumentException("Argument delay can not be negative !");
        }
        int ret = this.mComPortJNIBridge.writeBytes(handle, buffer, delay);
        if (ret < 0) {
            throw new SerialComException("Could not write data to serial port. Please retry !");
        }
        return true;
    }

    public boolean writeBytes(long handle, byte[] buffer) throws SerialComException {
        return this.writeBytes(handle, buffer, 0);
    }

    public boolean writeSingleByte(long handle, byte dataByte) throws SerialComException {
        int ret = this.mComPortJNIBridge.writeSingleByte(handle, dataByte);
        if (ret < 0) {
            throw new SerialComException("Could not write given byte to serial port. Please retry !");
        }
        return true;
    }

    public boolean writeString(long handle, String data, int delay) throws SerialComException {
        if (data == null) {
            throw new IllegalArgumentException("writeString(), Argument data can not be null");
        }
        return this.writeBytes(handle, data.getBytes(), delay);
    }

    public boolean writeString(long handle, String data, Charset charset, int delay) throws UnsupportedEncodingException, SerialComException {
        if (data == null) {
            throw new IllegalArgumentException("Argument data can not be null !");
        }
        return this.writeBytes(handle, data.getBytes(charset), delay);
    }

    public boolean writeSingleInt(long handle, int data, int delay, ENDIAN endianness, NUMOFBYTES numOfBytes) throws SerialComException {
        byte[] buffer = null;
        if (endianness == null) {
            throw new IllegalArgumentException("Argument endianness can not be null !");
        }
        if (numOfBytes == null) {
            throw new IllegalArgumentException("Argument numOfBytes can not be null !");
        }
        if (numOfBytes.getValue() == 2) {
            buffer = new byte[2];
            if (endianness.getValue() == 1) {
                buffer[1] = (byte)(data >>> 8);
                buffer[0] = (byte)data;
            } else {
                buffer[1] = (byte)data;
                buffer[0] = (byte)(data >>> 8);
            }
            return this.writeBytes(handle, buffer, delay);
        }
        buffer = new byte[4];
        if (endianness.getValue() == 1) {
            buffer[3] = (byte)(data >>> 24);
            buffer[2] = (byte)(data >>> 16);
            buffer[1] = (byte)(data >>> 8);
            buffer[0] = (byte)data;
        } else {
            buffer[3] = (byte)data;
            buffer[2] = (byte)(data >>> 8);
            buffer[1] = (byte)(data >>> 16);
            buffer[0] = (byte)(data >>> 24);
        }
        return this.writeBytes(handle, buffer, delay);
    }

    public boolean writeIntArray(long handle, int[] buffer, int delay, ENDIAN endianness, NUMOFBYTES numOfBytes) throws SerialComException {
        byte[] localBuf = null;
        if (endianness == null) {
            throw new IllegalArgumentException("Argument endianness can not be null !");
        }
        if (numOfBytes == null) {
            throw new IllegalArgumentException("Argument numOfBytes can not be null !");
        }
        if (numOfBytes.getValue() == 2) {
            localBuf = new byte[2 * buffer.length];
            if (endianness.getValue() == 1) {
                int a = 0;
                for (int b = 0; b < buffer.length; ++b) {
                    localBuf[a] = (byte)buffer[b];
                    localBuf[++a] = (byte)(buffer[b] >>> 8);
                    ++a;
                }
            } else {
                int c = 0;
                for (int d = 0; d < buffer.length; ++d) {
                    localBuf[c] = (byte)(buffer[d] >>> 8);
                    localBuf[++c] = (byte)buffer[d];
                    ++c;
                }
            }
            return this.writeBytes(handle, localBuf, delay);
        }
        localBuf = new byte[4 * buffer.length];
        if (endianness.getValue() == 1) {
            int e = 0;
            for (int f = 0; f < buffer.length; ++f) {
                localBuf[e] = (byte)buffer[f];
                localBuf[++e] = (byte)(buffer[f] >>> 8);
                localBuf[++e] = (byte)(buffer[f] >>> 16);
                localBuf[++e] = (byte)(buffer[f] >>> 24);
                ++e;
            }
        } else {
            int g = 0;
            for (int h = 0; h < buffer.length; ++h) {
                localBuf[g] = (byte)buffer[h];
                localBuf[++g] = (byte)(buffer[h] >>> 8);
                localBuf[++g] = (byte)(buffer[h] >>> 16);
                localBuf[++g] = (byte)(buffer[h] >>> 24);
                ++g;
            }
        }
        return this.writeBytes(handle, localBuf, delay);
    }

    public int writeBytesDirect(long handle, ByteBuffer buffer, int offset, int length) throws SerialComException {
        if (buffer == null) {
            throw new IllegalArgumentException("Argument buffer can not be null !");
        }
        if (offset < 0 || length < 0) {
            throw new IllegalArgumentException("Argument offset or length can not be negative !");
        }
        if (!buffer.isDirect()) {
            throw new IllegalArgumentException("Given buffer is not a direct byte buffer !");
        }
        if (length > buffer.capacity() - offset) {
            throw new IllegalArgumentException("Index violation detected !");
        }
        if (length == 0) {
            return 0;
        }
        int ret = this.mComPortJNIBridge.writeBytesDirect(handle, buffer, offset, length);
        if (ret < 0) {
            throw new SerialComException("Could not write given data to serial port. Please retry !");
        }
        return ret;
    }

    public boolean writeBytesBlocking(long handle, byte[] buffer, long context) throws SerialComException {
        return this.writeBytes(handle, buffer, 0);
    }

    public int readBytesDirect(long handle, ByteBuffer buffer, int offset, int length) throws SerialComException {
        if (buffer == null) {
            throw new IllegalArgumentException("Argument buffer can not be null !");
        }
        if (offset < 0 || length < 0) {
            throw new IllegalArgumentException("Argument offset or length can not be negative !");
        }
        if (!buffer.isDirect()) {
            throw new IllegalArgumentException("Argument buffer is not direct byte buffer !");
        }
        if (length > buffer.capacity() - offset) {
            throw new IllegalArgumentException("Index violation detected !");
        }
        if (length == 0) {
            return 0;
        }
        int ret = this.mComPortJNIBridge.readBytesDirect(handle, buffer, offset, length);
        if (ret < 0) {
            throw new SerialComException("Could not read data from serial port and place into direct byte buffer. Please retry !");
        }
        return ret;
    }

    public long createBlockingIOContext() throws SerialComException {
        long ret = this.mComPortJNIBridge.createBlockingIOContext();
        if (ret < 0L) {
            throw new SerialComException("Could not create blocking I/O context. Please retry !");
        }
        return ret;
    }

    public boolean unblockBlockingIOOperation(long context) throws SerialComException {
        int ret = this.mComPortJNIBridge.unblockBlockingIOOperation(context);
        if (ret < 0) {
            throw new SerialComException("Could not unblock the blocked I/O operation. Please retry !");
        }
        return true;
    }

    public boolean destroyBlockingIOContext(long context) throws SerialComException {
        int ret = this.mComPortJNIBridge.destroyBlockingIOContext(context);
        if (ret < 0) {
            throw new SerialComException("Could not destroy blocking I/O context. Please retry !");
        }
        return true;
    }

    public byte[] readBytesBlocking(long handle, int byteCount, long context) throws SerialComException {
        if (byteCount > 2048) {
            throw new SerialComException("Number of bytes to read can not be greater than 2048 !");
        }
        byte[] buffer = null;
        buffer = this.mComPortJNIBridge.readBytesBlocking(handle, byteCount, context);
        if (buffer != null) {
            return buffer;
        }
        return null;
    }

    public byte[] readBytes(long handle, int byteCount) throws SerialComException {
        if (byteCount > 2048) {
            throw new SerialComException("Number of bytes to read can not be greater than 2048 !");
        }
        byte[] buffer = this.mComPortJNIBridge.readBytes(handle, byteCount);
        if (buffer != null) {
            return buffer;
        }
        return null;
    }

    public byte[] readBytes(long handle) throws SerialComException {
        return this.readBytes(handle, 1024);
    }

    public String readString(long handle, int byteCount) throws SerialComException {
        byte[] buffer = this.readBytes(handle, byteCount);
        if (buffer != null) {
            return new String(buffer);
        }
        return null;
    }

    public String readString(long handle) throws SerialComException {
        return this.readString(handle, 1024);
    }

    public byte[] readSingleByte(long handle) throws SerialComException {
        return this.readBytes(handle, 1);
    }

    public int readBytes(long handle, byte[] buffer, int offset, int length, long context) throws SerialComException {
        if (buffer == null) {
            throw new NullPointerException("Null data buffer passed to read operation !");
        }
        if (offset < 0 || length < 0 || length > buffer.length - offset) {
            throw new IndexOutOfBoundsException("Index violation detected in given byte array !");
        }
        if (length > 2048) {
            throw new IllegalArgumentException("Argument length can not be greater than 2048 !");
        }
        if (length == 0) {
            return 0;
        }
        int numberOfBytesRead = this.mComPortJNIBridge.readBytesP(handle, buffer, offset, length, context);
        if (numberOfBytesRead < 0) {
            throw new SerialComException("Could not read data from serial port. Please retry !");
        }
        return numberOfBytesRead;
    }

    public boolean configureComPortData(long handle, DATABITS dataBits, STOPBITS stopBits, PARITY parity, BAUDRATE baudRate, int custBaud) throws SerialComException {
        int baudRateTranslated = 0;
        int custBaudTranslated = 0;
        int baudRateGiven = 0;
        if (dataBits == null) {
            throw new IllegalArgumentException("Argument dataBits can not be null !");
        }
        if (stopBits == null) {
            throw new IllegalArgumentException("Argument stopBits can not be null !");
        }
        if (parity == null) {
            throw new IllegalArgumentException("Argument parity can not be null !");
        }
        if (baudRate == null) {
            throw new IllegalArgumentException("Argument baudRate can not be null !");
        }
        if (this.mPortHandleInfo.get(handle) == null) {
            throw new SerialComException("Given handle does not represent a serial port opened through SCM !");
        }
        baudRateGiven = baudRate.getValue();
        if (baudRateGiven != 251) {
            baudRateTranslated = baudRateGiven;
            custBaudTranslated = 0;
        } else {
            if (custBaud <= 0) {
                throw new IllegalArgumentException("Argument baudRate can not be negative or zero !");
            }
            baudRateTranslated = baudRateGiven;
            custBaudTranslated = custBaud;
        }
        int ret = this.mComPortJNIBridge.configureComPortData(handle, dataBits.getValue(), stopBits.getValue(), parity.getValue(), baudRateTranslated, custBaudTranslated);
        if (ret < 0) {
            throw new SerialComException("Could not configure the serial port. Please retry !");
        }
        return true;
    }

    public boolean configureComPortControl(long handle, FLOWCONTROL flowctrl, char xon, char xoff, boolean ParFraError, boolean overFlowErr) throws SerialComException {
        if (flowctrl == null) {
            throw new IllegalArgumentException("Argument flowctrl can not be null !");
        }
        if (this.mPortHandleInfo.get(handle) == null) {
            throw new SerialComException("Given handle does not represent a serial port opened through SCM !");
        }
        char xonCh = xon;
        char xoffCh = xoff;
        int ret = this.mComPortJNIBridge.configureComPortControl(handle, flowctrl.getValue(), (byte)xonCh, (byte)xoffCh, ParFraError, overFlowErr);
        if (ret < 0) {
            throw new SerialComException("Could not configure serial port. Please retry !");
        }
        return true;
    }

    public String[] getCurrentConfiguration(long handle) throws SerialComException {
        if (this.mPortHandleInfo.get(handle) == null) {
            throw new SerialComException("Given handle does not represent a serial port opened through SCM !");
        }
        if (this.getOSType() != 2) {
            int[] config = this.mComPortJNIBridge.getCurrentConfigurationU(handle);
            String[] configuration = new String[config.length];
            if (config[0] < 0) {
                throw new SerialComException("Could not determine current configuration. Please retry !");
            }
            for (int x = 0; x < config.length; ++x) {
                configuration[x] = "" + config[x];
            }
            return configuration;
        }
        String[] configuration = this.mComPortJNIBridge.getCurrentConfigurationW(handle);
        return configuration;
    }

    public boolean setRTS(long handle, boolean enabled) throws SerialComException {
        int ret = this.mComPortJNIBridge.setRTS(handle, enabled);
        if (ret < 0) {
            throw new SerialComException("Could not set RTS line to desired state. Please retry !");
        }
        return true;
    }

    public boolean setDTR(long handle, boolean enabled) throws SerialComException {
        int ret = this.mComPortJNIBridge.setDTR(handle, enabled);
        if (ret < 0) {
            throw new SerialComException("Could not set DTR line to desired state. Please retry !");
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean registerDataListener(long handle, ISerialComDataListener dataListener) throws SerialComException {
        SerialComPortHandleInfo handleInfo = null;
        if (dataListener == null) {
            throw new IllegalArgumentException("Argument dataListener can not be null !");
        }
        Object object = this.lockB;
        synchronized (object) {
            handleInfo = this.mPortHandleInfo.get(handle);
            if (handleInfo == null) {
                throw new SerialComException("Given handle does not represent a serial port opened through SCM !");
            }
            if (handleInfo.getDataListener() != null) {
                throw new SerialComException("Data listener already exist for this handle. A handle can have only one data listener !");
            }
            return this.mEventCompletionDispatcher.setUpDataLooper(handle, handleInfo, dataListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unregisterDataListener(long handle, ISerialComDataListener dataListener) throws SerialComException {
        SerialComPortHandleInfo handleInfo = null;
        if (dataListener == null) {
            throw new IllegalArgumentException("Argument dataListener can not be null !");
        }
        Object object = this.lockB;
        synchronized (object) {
            handleInfo = this.mPortHandleInfo.get(handle);
            if (handleInfo == null) {
                throw new SerialComException("Given handle does not represent a serial port opened through SCM !");
            }
            if (this.mEventCompletionDispatcher.destroyDataLooper(handle, handleInfo, dataListener)) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean registerLineEventListener(long handle, ISerialComEventListener eventListener) throws SerialComException {
        SerialComPortHandleInfo handleInfo = null;
        if (eventListener == null) {
            throw new IllegalArgumentException("Argument eventListener can not be null !");
        }
        Object object = this.lockB;
        synchronized (object) {
            handleInfo = this.mPortHandleInfo.get(handle);
            if (this.mPortHandleInfo.get(handle) == null) {
                throw new SerialComException("Given handle does not represent a serial port opened through SCM !");
            }
            if (handleInfo.getEventListener() != null) {
                throw new SerialComException("Event listener already exist for this handle. A handle can have only one event listener !");
            }
            return this.mEventCompletionDispatcher.setUpEventLooper(handle, handleInfo, eventListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unregisterLineEventListener(long handle, ISerialComEventListener eventListener) throws SerialComException {
        SerialComPortHandleInfo handleInfo = null;
        if (eventListener == null) {
            throw new IllegalArgumentException("Argument eventListener can not be null !");
        }
        Object object = this.lockB;
        synchronized (object) {
            handleInfo = this.mPortHandleInfo.get(handle);
            if (handleInfo == null) {
                throw new SerialComException("Given handle does not represent a serial port opened through SCM !");
            }
            if (this.mEventCompletionDispatcher.destroyEventLooper(handle, handleInfo, eventListener)) {
                return true;
            }
        }
        return false;
    }

    public boolean pauseListeningEvents(ISerialComEventListener eventListener) throws SerialComException {
        if (eventListener == null) {
            throw new IllegalArgumentException("Argument eventListener can not be null !");
        }
        return this.mEventCompletionDispatcher.pauseListeningEvents(eventListener);
    }

    public boolean resumeListeningEvents(ISerialComEventListener eventListener) throws SerialComException {
        if (eventListener == null) {
            throw new IllegalArgumentException("Argument eventListener can not be null !");
        }
        return this.mEventCompletionDispatcher.resumeListeningEvents(eventListener);
    }

    public boolean fineTuneReadBehaviour(long handle, int vmin, int vtime, int rit, int rttm, int rttc) throws SerialComException {
        int ret = 0;
        if (osType == 2) {
            if (rit < 0 || rttm < 0 || rttc < 0) {
                throw new IllegalArgumentException("Argument(s) rit, rttm and rttc can not be neagative !");
            }
        } else {
            if (vmin == 0 && vtime == 0) {
                throw new IllegalArgumentException("Invalid combination of vmin and vtime arguments passed !");
            }
            if (vmin < 0 || vtime < 0) {
                throw new IllegalArgumentException("Argument(s) vmin and vtime can not be negative !");
            }
        }
        if (this.mPortHandleInfo.get(handle) == null) {
            throw new SerialComException("Given handle does not represent a serial port opened through SCM !");
        }
        ret = this.mComPortJNIBridge.fineTuneRead(handle, vmin, vtime, rit, rttm, rttc);
        if (ret < 0) {
            throw new SerialComException("Could not set the given parameters. Please retry !");
        }
        return true;
    }

    public boolean setEventsMask(ISerialComEventListener eventListener, int newMask) throws SerialComException {
        SerialComPortHandleInfo handleInfo = null;
        SerialComLooper looper = null;
        ISerialComEventListener mEventListener = null;
        if (eventListener == null) {
            throw new IllegalArgumentException("Argument eventListener can not be null !");
        }
        for (Map.Entry<Long, SerialComPortHandleInfo> entry : this.mPortHandleInfo.entrySet()) {
            handleInfo = entry.getValue();
            if (handleInfo == null || !handleInfo.containsEventListener(eventListener)) continue;
            looper = handleInfo.getLooper();
            mEventListener = handleInfo.getEventListener();
            break;
        }
        if (looper != null && mEventListener != null) {
            looper.setEventsMask(newMask);
            return true;
        }
        throw new SerialComException("This listener is not registered !");
    }

    public int getEventsMask(ISerialComEventListener eventListener) throws SerialComException {
        SerialComPortHandleInfo handleInfo = null;
        SerialComLooper looper = null;
        ISerialComEventListener mEventListener = null;
        if (eventListener == null) {
            throw new IllegalArgumentException("Argument eventListener can not be null !");
        }
        for (Map.Entry<Long, SerialComPortHandleInfo> entry : this.mPortHandleInfo.entrySet()) {
            handleInfo = entry.getValue();
            if (handleInfo == null || !handleInfo.containsEventListener(eventListener)) continue;
            looper = handleInfo.getLooper();
            mEventListener = handleInfo.getEventListener();
            break;
        }
        if (looper != null && mEventListener != null) {
            return looper.getEventsMask();
        }
        throw new SerialComException("This listener is not registered !");
    }

    public boolean clearPortIOBuffers(long handle, boolean clearRxBuffer, boolean clearTxBuffer) throws SerialComException {
        if (this.mPortHandleInfo.get(handle) == null) {
            throw new SerialComException("Given handle does not represent a serial port opened through SCM !");
        }
        if (!clearRxBuffer && !clearTxBuffer) {
            throw new IllegalArgumentException("Both arguments clearRxBuffer and clearTxBuffer can not be false !");
        }
        int ret = this.mComPortJNIBridge.clearPortIOBuffers(handle, clearRxBuffer, clearTxBuffer);
        if (ret < 0) {
            throw new SerialComException("Could not clear the buffers for the given port. Please retry !");
        }
        return true;
    }

    public boolean sendBreak(long handle, int duration) throws SerialComException {
        if (this.mPortHandleInfo.get(handle) == null) {
            throw new SerialComException("Given handle does not represent a serial port opened through SCM !");
        }
        if (duration < 0 || duration == 0) {
            throw new IllegalArgumentException("Argument duration can not be negative or zero !");
        }
        this.mComPortJNIBridge.sendBreak(handle, duration);
        return true;
    }

    public int[] getInterruptCount(long handle) throws SerialComException {
        if (this.mPortHandleInfo.get(handle) == null) {
            throw new SerialComException("Given handle does not represent a serial port opened through SCM !");
        }
        int[] interruptsCount = this.mComPortJNIBridge.getInterruptCount(handle);
        if (interruptsCount == null) {
            throw new SerialComException("Unknown error occurred !");
        }
        return interruptsCount;
    }

    public int[] getLinesStatus(long handle) throws SerialComException {
        int[] status = null;
        if (this.mPortHandleInfo.get(handle) == null) {
            throw new SerialComException("Given handle does not represent a serial port opened through SCM !");
        }
        status = this.mComPortJNIBridge.getLinesStatus(handle);
        if (status == null) {
            throw new SerialComException("Failed to get line status for the given handle. Please retry !");
        }
        return status;
    }

    public String findDriverServingComPort(String comPortName) throws SerialComException {
        if (comPortName == null) {
            throw new IllegalArgumentException("Argument comPortName can not be null !");
        }
        if (comPortName.length() == 0) {
            throw new IllegalArgumentException("Argument comPortName can not be empty string !");
        }
        if (comPortName.length() > 256) {
            throw new IllegalArgumentException("Argument comPortName string can not be greater than 256 in length !");
        }
        String driverName = this.mComPortJNIBridge.findDriverServingComPort(comPortName);
        if (driverName == null) {
            throw new SerialComException("Failed to find driver serving the given serial port. Please retry !");
        }
        return driverName;
    }

    public String findIRQnumberForComPort(long handle) throws SerialComException {
        String addressAndIRQ = this.mComPortJNIBridge.findIRQnumberForComPort(handle);
        if (addressAndIRQ == null) {
            throw new SerialComException("Failed to find IRQ and address for the given serial port. Please retry !");
        }
        return addressAndIRQ;
    }

    public int[] getByteCountInPortIOBuffer(long handle) throws SerialComException {
        if (this.mPortHandleInfo.get(handle) == null) {
            throw new SerialComException("Given handle does not represent a serial port opened through SCM !");
        }
        int[] numBytesInfo = this.mComPortJNIBridge.getByteCount(handle);
        if (numBytesInfo == null) {
            throw new SerialComException("Could not determine number of bytes in buffer. Please retry !");
        }
        return numBytesInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int registerUSBHotPlugEventListener(ISerialComUSBHotPlugListener hotPlugListener, int filterVID, int filterPID, String serialNumber) throws SerialComException {
        int opaqueHandle = 0;
        if (hotPlugListener == null) {
            throw new IllegalArgumentException("Argument hotPlugListener can not be null !");
        }
        if (filterVID < 0 || filterPID < 0 || filterVID > 65535 || filterPID > 65535) {
            throw new IllegalArgumentException("USB VID or PID can not be negative number(s) or greater than 0xFFFF !");
        }
        Object object = this.lockB;
        synchronized (object) {
            opaqueHandle = this.mComPortJNIBridge.registerUSBHotPlugEventListener(hotPlugListener, filterVID, filterPID, serialNumber);
            if (opaqueHandle < 0) {
                throw new SerialComException("Could not register USB device hotplug listener. Please retry !");
            }
        }
        return opaqueHandle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unregisterUSBHotPlugEventListener(int opaqueHandle) throws SerialComException {
        int ret = 0;
        if (opaqueHandle < 0) {
            throw new IllegalArgumentException("Argument opaqueHandle can not be negative !");
        }
        Object object = this.lockB;
        synchronized (object) {
            ret = this.mComPortJNIBridge.unregisterUSBHotPlugEventListener(opaqueHandle);
        }
        if (ret < 0) {
            throw new SerialComException("Could not un-register USB device hotplug listener. Please retry !");
        }
        return true;
    }

    public String getPortName(long handle) throws SerialComException {
        SerialComPortHandleInfo handleInfo = null;
        handleInfo = this.mPortHandleInfo.get(handle);
        if (handleInfo == null) {
            throw new SerialComException("Given handle is unknown to this library !");
        }
        return handleInfo.getOpenedPortName();
    }

    public boolean sendFile(long handle, File[] fileToSend, FTPPROTO ftpProto, FTPVAR ftpVariant, boolean textMode, ISerialComFTPProgress progressListener, SerialComFTPCMDAbort transferState) throws IOException {
        if (fileToSend == null || fileToSend.length == 0) {
            throw new IllegalArgumentException("Argument fileToSend can not be null or of zero length !");
        }
        if (ftpProto == null) {
            throw new IllegalArgumentException("Argument ftpProto can not be null !");
        }
        if (ftpVariant == null) {
            throw new IllegalArgumentException("Argument ftpVariant can not be null !");
        }
        if (this.mPortHandleInfo.get(handle) == null) {
            throw new SerialComException("Given handle does not represent a serial port opened through SCM !");
        }
        int protocol = ftpProto.getValue();
        int variant = ftpVariant.getValue();
        if (protocol == 1) {
            if (!fileToSend[0].isFile()) {
                throw new IllegalArgumentException("For Xmodem fileToSend[0] must be an existing regular file !");
            }
            if (progressListener != null && !(progressListener instanceof ISerialComXmodemProgress)) {
                throw new IllegalArgumentException("Implement ISerialComXmodemProgress for non-null progressListener !");
            }
            switch (variant) {
                case 1: {
                    SerialComXModem xmodem = new SerialComXModem(this, handle, fileToSend[0], textMode, (ISerialComXmodemProgress)progressListener, transferState, osType);
                    return xmodem.sendFileX();
                }
                case 2: {
                    SerialComXModemCRC xmodemc = new SerialComXModemCRC(this, handle, fileToSend[0], textMode, (ISerialComXmodemProgress)progressListener, transferState, osType);
                    return xmodemc.sendFileX();
                }
                case 3: {
                    SerialComXModem1K xmodemk = new SerialComXModem1K(this, handle, fileToSend[0], textMode, (ISerialComXmodemProgress)progressListener, transferState, osType);
                    return xmodemk.sendFileX();
                }
            }
            throw new IllegalArgumentException("This variant is not applicable for Xmodem transfer !");
        }
        if (protocol == 2) {
            switch (variant) {
                case 2: {
                    SerialComYModemCRC ymodemc = new SerialComYModemCRC(this, handle, fileToSend, textMode, (ISerialComYmodemProgress)progressListener, transferState, osType);
                    return ymodemc.sendFileY();
                }
                case 3: {
                    SerialComYModem1K ymodemk = new SerialComYModem1K(this, handle, fileToSend, textMode, (ISerialComYmodemProgress)progressListener, transferState, osType);
                    return ymodemk.sendFileY();
                }
            }
            throw new IllegalArgumentException("This variant is not applicable for Ymodem transfer !");
        }
        if (protocol == 3) {
            // empty if block
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean receiveFile(long handle, File fileToReceive, FTPPROTO ftpProto, FTPVAR ftpVariant, boolean textMode, ISerialComFTPProgress progressListener, SerialComFTPCMDAbort transferState) throws IOException {
        boolean result = false;
        if (fileToReceive == null) {
            throw new IllegalArgumentException("Argument fileToReceive can not be null !");
        }
        if (ftpProto == null) {
            throw new IllegalArgumentException("Argument ftpProto can not be null !");
        }
        if (ftpVariant == null) {
            throw new IllegalArgumentException("Argument ftpVariant can not be null !");
        }
        if (this.mPortHandleInfo.get(handle) == null) {
            throw new SerialComException("Given handle does not represent a serial port opened through SCM !");
        }
        int protocol = ftpProto.getValue();
        int variant = ftpVariant.getValue();
        if (protocol == 1) {
            if (!fileToReceive.isFile()) {
                throw new IllegalArgumentException("The fileToReceive must be an existing regular file for Xmodem transfer !");
            }
            if (progressListener != null && !(progressListener instanceof ISerialComXmodemProgress)) {
                throw new IllegalArgumentException("Implement ISerialComXmodemProgress for non-null progressListener !");
            }
            if (variant == 1) {
                SerialComXModem xmodem = new SerialComXModem(this, handle, fileToReceive, textMode, (ISerialComXmodemProgress)progressListener, transferState, osType);
                return xmodem.receiveFileX();
            }
            if (variant == 2) {
                SerialComXModemCRC xmodemc = new SerialComXModemCRC(this, handle, fileToReceive, textMode, (ISerialComXmodemProgress)progressListener, transferState, osType);
                return xmodemc.receiveFileX();
            }
            if (variant != 3) throw new IllegalArgumentException("This variant is not applicable for for Xmodem transfer !");
            SerialComXModem1K xmodemk = new SerialComXModem1K(this, handle, fileToReceive, textMode, (ISerialComXmodemProgress)progressListener, transferState, osType);
            return xmodemk.receiveFileX();
        }
        if (protocol == 2) {
            if (!fileToReceive.isDirectory()) throw new IllegalArgumentException("The fileToReceive must be a writable directory for Ymodem transfer !");
            if (!fileToReceive.canWrite()) {
                throw new IllegalArgumentException("The fileToReceive must be a writable directory for Ymodem transfer !");
            }
            if (variant == 2) {
                SerialComYModemCRC ymodemc = new SerialComYModemCRC(this, handle, fileToReceive, textMode, (ISerialComYmodemProgress)progressListener, transferState, osType);
                return ymodemc.receiveFileY();
            }
            if (variant != 3) throw new IllegalArgumentException("This variant is not applicable for for Ymodem transfer !");
            SerialComYModem1K ymodemk = new SerialComYModem1K(this, handle, fileToReceive, textMode, (ISerialComYmodemProgress)progressListener, transferState, osType);
            return ymodemk.receiveFileY();
        }
        if (protocol != 3) return result;
        return result;
    }

    public ISerialIOStream getIOStreamInstance(int streamType, long handle, SMODE streamMode) throws SerialComException {
        if (streamMode == null) {
            throw new IllegalArgumentException("Argument streamMode can not be null !");
        }
        SerialComPortHandleInfo handleInfo = null;
        handleInfo = this.mPortHandleInfo.get(handle);
        if (handleInfo == null) {
            throw new SerialComException("Given handle does not represent a serial port opened through SCM !");
        }
        switch (streamType) {
            case 50: {
                SerialComInByteStream scis = null;
                scis = handleInfo.getSerialComInByteStream();
                if (scis != null) {
                    throw new SerialComException("Input byte stream already exist for this handle !");
                }
                scis = new SerialComInByteStream(this, handleInfo, handle, streamMode);
                handleInfo.setSerialComInByteStream(scis);
                return scis;
            }
            case 51: {
                SerialComOutByteStream scos = handleInfo.getSerialComOutByteStream();
                if (scos != null) {
                    throw new SerialComException("Output byte stream already exist for this handle !");
                }
                scos = new SerialComOutByteStream(this, handleInfo, handle, streamMode);
                handleInfo.setSerialComOutByteStream(scos);
                return scos;
            }
        }
        throw new IllegalArgumentException("Argument streamType is invalid !");
    }

    public SerialComIOCTLExecutor getIOCTLExecutor(long handle) throws SerialComException {
        if (this.mPortHandleInfo.get(handle) == null) {
            throw new SerialComException("Given handle does not represent a serial port opened through SCM !");
        }
        if (this.mSerialComIOCTLExecutor != null) {
            return this.mSerialComIOCTLExecutor;
        }
        this.mSerialComIOCTLExecutor = new SerialComIOCTLExecutor(this.mComPortJNIBridge);
        return this.mSerialComIOCTLExecutor;
    }

    public boolean isUSBDevConnected(int vendorID, int productID, String serialNumber) throws SerialComException {
        if (vendorID < 0 || vendorID > 65535) {
            throw new IllegalArgumentException("Argument vendorID can not be negative or greater than 0xFFFF !");
        }
        if (productID < 0 || productID > 65535) {
            throw new IllegalArgumentException("Argument productID can not be negative or greater than 0xFFFF !");
        }
        int ret = this.mComPortJNIBridge.isUSBDevConnected(vendorID, productID, serialNumber);
        if (ret < 0) {
            throw new SerialComException("Unknown error occurred !");
        }
        return ret == 1;
    }

    public SerialComVendorLib getVendorLibFromFactory(int vendorLibIdentifier, String libDirectory, String vlibName) throws SerialComLoadException, UnsatisfiedLinkError, SerialComUnexpectedException, SecurityException, FileNotFoundException {
        File baseDir = new File(libDirectory.trim());
        if (!baseDir.exists()) {
            throw new SerialComLoadException("The directory " + libDirectory + " does not exist !");
        }
        if (!baseDir.isDirectory()) {
            throw new SerialComLoadException("The location " + libDirectory + " is not a directory !");
        }
        if (!baseDir.canWrite()) {
            throw new SerialComLoadException("The directory " + libDirectory + " is not writeable (permissions ??) !");
        }
        if (vlibName == null) {
            throw new IllegalArgumentException("Argument vlibName can not be null !");
        }
        if (vlibName.length() == 0) {
            throw new IllegalArgumentException("Argument vlibName can not be empty string !");
        }
        if (mSerialComVendorLib != null) {
            return mSerialComVendorLib.getVendorLibInstance(vendorLibIdentifier, baseDir, vlibName, cpuArch, osType, this.mSerialComSystemProperty);
        }
        mSerialComVendorLib = new SerialComVendorLib();
        return mSerialComVendorLib.getVendorLibInstance(vendorLibIdentifier, baseDir, vlibName, cpuArch, osType, this.mSerialComSystemProperty);
    }

    public SerialComUSB getSerialComUSBInstance() throws SerialComException {
        if (this.mSerialComUSB != null) {
            return this.mSerialComUSB;
        }
        this.mSerialComUSB = new SerialComUSB(this.mComPortJNIBridge);
        return this.mSerialComUSB;
    }

    public SerialComBluetooth getSerialComBluetoothInstance(int btStack, String directoryPath, String loadedLibName) throws SecurityException, SerialComUnexpectedException, SerialComLoadException, UnsatisfiedLinkError, SerialComException, FileNotFoundException, IOException {
        if (osType == 1 && btStack != 1) {
            throw new IllegalArgumentException("Argument btStack does not indicate bluetooth stack supported by this library !");
        }
        if (mSerialComBluetoothJNIBridge == null) {
            mSerialComBluetoothJNIBridge = new SerialComBluetoothJNIBridge();
            SerialComBluetoothJNIBridge.loadNativeLibrary(directoryPath, loadedLibName, this.mSerialComSystemProperty, osType, cpuArch, javaABIType, btStack);
        }
        return new SerialComBluetooth(mSerialComBluetoothJNIBridge);
    }

    public SerialComHID getSerialComHIDInstance(int type, String directoryPath, String loadedLibName) throws SecurityException, SerialComUnexpectedException, SerialComLoadException, UnsatisfiedLinkError, SerialComException, FileNotFoundException, IOException {
        if (mSerialComHIDJNIBridge == null) {
            mSerialComHIDJNIBridge = new SerialComHIDJNIBridge();
            SerialComHIDJNIBridge.loadNativeLibrary(directoryPath, loadedLibName, this.mSerialComSystemProperty, osType, cpuArch, javaABIType);
            int ret = mSerialComHIDJNIBridge.initNativeLib();
            if (ret < 0) {
                throw new SerialComException("Failed to initilize the native library. Please retry !");
            }
        }
        if (type == 1) {
            return new SerialComRawHID(mSerialComHIDJNIBridge, osType);
        }
        throw new IllegalArgumentException("Argument type must be one of the constants SerialComHID.MODE_XXXXX !");
    }

    public SerialComPortMapper getSerialComPortMapperInstance(String directoryPath, String loadedLibName) throws SerialComException, SecurityException, SerialComUnexpectedException, SerialComLoadException, UnsatisfiedLinkError {
        if (mSerialComPortMapperJNIBridge == null) {
            mSerialComPortMapperJNIBridge = new SerialComPortMapperJNIBridge();
            SerialComPortMapperJNIBridge.loadNativeLibrary(directoryPath, loadedLibName, this.mSerialComSystemProperty, osType, cpuArch, javaABIType);
        }
        return new SerialComPortMapper(mSerialComPortMapperJNIBridge);
    }

    public SerialComDBRelease getSerialComDBReleaseInstance(String directoryPath, String loadedLibName) throws SerialComException, SecurityException, SerialComUnexpectedException, SerialComLoadException, UnsatisfiedLinkError {
        if (mSerialComDBReleaseJNIBridge == null) {
            mSerialComDBReleaseJNIBridge = new SerialComDBReleaseJNIBridge();
            SerialComDBReleaseJNIBridge.loadNativeLibrary(directoryPath, loadedLibName, this.mSerialComSystemProperty, osType, cpuArch, javaABIType);
        }
        return new SerialComDBRelease(mSerialComDBReleaseJNIBridge);
    }

    public SerialComNullModem getSerialComNullModemInstance() throws IOException {
        if (mSerialComNullModem == null) {
            mSerialComNullModem = new SerialComNullModem(osType);
        }
        return mSerialComNullModem;
    }

    static {
        lockA = new Object();
        nativeLibLoadAndInitAlready = false;
    }

    public static enum SMODE {
        BLOCKING(1),
        NONBLOCKING(2);

        private int value;

        private SMODE(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum FTPVAR {
        CHKSUM(1),
        CRC(2),
        VAR1K(3);

        private int value;

        private FTPVAR(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum FTPPROTO {
        XMODEM(1),
        YMODEM(2),
        ZMODEM(3);

        private int value;

        private FTPPROTO(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum NUMOFBYTES {
        NUM_2(2),
        NUM_4(4);

        private int value;

        private NUMOFBYTES(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum ENDIAN {
        E_LITTLE(1),
        E_BIG(2),
        E_DEFAULT(3);

        private int value;

        private ENDIAN(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum FLOWCONTROL {
        NONE(1),
        RTS_CTS(2),
        DTR_DSR(3),
        XON_XOFF(4);

        private int value;

        private FLOWCONTROL(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum PARITY {
        P_NONE(1),
        P_ODD(2),
        P_EVEN(3),
        P_MARK(4),
        P_SPACE(5);

        private int value;

        private PARITY(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum STOPBITS {
        SB_1(1),
        SB_1_5(4),
        SB_2(2);

        private int value;

        private STOPBITS(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum DATABITS {
        DB_5(5),
        DB_6(6),
        DB_7(7),
        DB_8(8);

        private int value;

        private DATABITS(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum BAUDRATE {
        B0(0),
        B50(50),
        B75(75),
        B110(110),
        B134(134),
        B150(150),
        B200(200),
        B300(300),
        B600(600),
        B1200(1200),
        B1800(1800),
        B2400(2400),
        B4800(4800),
        B9600(9600),
        B14400(14400),
        B19200(19200),
        B28800(28800),
        B38400(38400),
        B56000(56000),
        B57600(57600),
        B115200(115200),
        B128000(128000),
        B153600(153600),
        B230400(230400),
        B256000(256000),
        B460800(460800),
        B500000(500000),
        B576000(576000),
        B921600(921600),
        B1000000(1000000),
        B1152000(1152000),
        B1500000(1500000),
        B2000000(2000000),
        B2500000(2500000),
        B3000000(3000000),
        B3500000(3500000),
        B4000000(4000000),
        BCUSTOM(251);

        private int value;

        private BAUDRATE(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

