/*
 * Decompiled with CFR 0.152.
 */
package com.embeddedunveiled.serial;

import com.embeddedunveiled.serial.SerialComException;
import com.embeddedunveiled.serial.SerialComManager;
import com.embeddedunveiled.serial.internal.ISerialIOStream;
import com.embeddedunveiled.serial.internal.SerialComPortHandleInfo;
import java.io.IOException;
import java.io.OutputStream;

public final class SerialComOutByteStream
extends OutputStream
implements ISerialIOStream {
    private SerialComManager scm;
    private SerialComPortHandleInfo portHandleInfo;
    private long handle;
    private boolean isOpened;

    public SerialComOutByteStream(SerialComManager scm, SerialComPortHandleInfo portHandleInfo, long handle, SerialComManager.SMODE streamMode) throws SerialComException {
        this.scm = scm;
        this.portHandleInfo = portHandleInfo;
        this.handle = handle;
        this.isOpened = true;
    }

    @Override
    public void write(int data) throws IOException {
        if (!this.isOpened) {
            throw new IOException("The byte stream has been closed !");
        }
        try {
            this.scm.writeSingleByte(this.handle, (byte)data);
        }
        catch (SerialComException e) {
            throw new IOException(e.getExceptionMsg());
        }
    }

    @Override
    public void write(byte[] data) throws IOException {
        if (!this.isOpened) {
            throw new IOException("The byte stream has been closed !");
        }
        if (data == null) {
            throw new NullPointerException("Argument data can not be null !");
        }
        if (!(data instanceof byte[])) {
            throw new IllegalArgumentException("Argument data is not byte type array !");
        }
        try {
            this.scm.writeBytes(this.handle, data, 0);
        }
        catch (SerialComException e) {
            throw new IOException(e.getExceptionMsg());
        }
    }

    @Override
    public void write(byte[] data, int off, int len) throws IOException, IndexOutOfBoundsException {
        if (!this.isOpened) {
            throw new IOException("The byte stream has been closed !");
        }
        if (data == null) {
            throw new NullPointerException("Argument data can not be null !");
        }
        if (off < 0 || len < 0 || off + len > data.length) {
            throw new IndexOutOfBoundsException("Index violation detected !");
        }
        if (!(data instanceof byte[])) {
            throw new IllegalArgumentException("Argument data is not byte type array !");
        }
        try {
            int x = 0;
            int i = off;
            byte[] buf = new byte[len];
            for (x = 0; x < len; ++x) {
                buf[x] = data[i];
                ++i;
            }
            this.scm.writeBytes(this.handle, buf, 0);
        }
        catch (SerialComException e) {
            throw new IOException(e.getExceptionMsg());
        }
    }

    @Override
    public void flush() throws IOException {
        if (!this.isOpened) {
            throw new IOException("The byte stream has been closed !");
        }
    }

    @Override
    public void close() throws IOException {
        if (!this.isOpened) {
            throw new IOException("The byte stream has been closed !");
        }
        this.portHandleInfo.setSerialComOutByteStream(null);
        this.isOpened = false;
    }
}

