/*
 * Decompiled with CFR 0.152.
 */
package com.embeddedunveiled.serial.datalogger;

import com.embeddedunveiled.serial.SerialComManager;
import com.embeddedunveiled.serial.datalogger.ISerialComToFileErrListener;
import com.embeddedunveiled.serial.datalogger.SerialComLogSource;

public final class SerialComDataLogger {
    public static final int DP_START_ANY_CHAR = 1;
    public static final int DP_START_ALPHABETIC_CHAR = 2;
    public static final int DP_START_NUMERIC_CHAR = 3;
    public static final int DP_START_ALPHANUMERIC_CHAR = 4;
    public static final int DP_START_SPECIAL_CHAR = 5;
    public static final int DP_STOP_CRLF = 6;
    public static final int DP_STOP_TIME_DELAY = 7;
    public static final int DP_STOP_FIXED_LENGTH = 8;
    public static final int DP_STOP_CHAR = 9;
    public static final int DP_TYPE_SINGLE_FIELD = 16;
    public static final int DP_TYPE_MULTIPLE_DELIMITED_FIELDS = 17;
    public static final int DP_TYPE_MUPLTIPLE_FIXED_LENGTH_FIELDS = 18;
    public static final int FIELD_FILTER_NONE = 19;
    public static final int FIELD_FILTER_DROP = 20;
    public static final int FIELD_FILTER_NUM_ONLY = 21;
    public static final int FIELD_CONVERT_HEX_TO_DEC = 22;
    public static final int FIELD_CONVERT_OCT_TO_DEC = 23;
    public static final int FIELD_CONVERT_BIN_TO_HEX = 24;
    private final SerialComManager scm;
    private final SerialComLogSource source;
    private final ISerialComToFileErrListener errListener;
    private int dataPacketStartEvent;
    private int dataPacketStopEvent;
    private int dataPacketdelayTime;
    private char dataPacketEndChar;
    private int dataPacketLength;
    private int dataPacketStructure;
    private char fieldDelimiter;
    private int[] lengthOfEachField;
    private int dataFieldFilter;
    private int dataFieldFormConversion;

    public SerialComDataLogger(SerialComManager scm, SerialComLogSource scls, ISerialComToFileErrListener errListener) {
        this.scm = scm;
        this.source = scls;
        this.errListener = errListener;
    }

    public void setDataPacketStartEvent(int dataPacketStartEvent) {
        if (dataPacketStartEvent < 1 || dataPacketStartEvent > 5) {
            throw new IllegalArgumentException("Argument dataPacketStartEvent is invalid !");
        }
        this.dataPacketStartEvent = dataPacketStartEvent;
    }

    public void setDataPacketStopEvent(int dataPacketStopEvent, int dataPacketdelayTime, char dataPacketEndChar, int dataPacketLength) {
        if (this.dataPacketStartEvent < 6 || this.dataPacketStartEvent > 9) {
            throw new IllegalArgumentException("Argument dataPacketStopEvent is invalid !");
        }
        this.dataPacketStopEvent = dataPacketStopEvent;
        if (dataPacketStopEvent == 7 && dataPacketdelayTime < 0) {
            throw new IllegalArgumentException("Argument dataPacketdelayTime should be positive number !");
        }
        if (dataPacketStopEvent == 8 && dataPacketLength < 1) {
            throw new IllegalArgumentException("Argument dataPacketLength should be equal or greater than 1 !");
        }
        this.dataPacketdelayTime = dataPacketdelayTime;
        this.dataPacketEndChar = dataPacketEndChar;
        this.dataPacketLength = dataPacketLength;
    }

    public void setDataPacketOverallStructure(int dataPacketStructure, char fieldDelimiter, int[] lengthOfEachField) {
        if (dataPacketStructure < 16 || dataPacketStructure > 18) {
            throw new IllegalArgumentException("Argument dataPacketStructure is invalid !");
        }
        if (dataPacketStructure == 18) {
            if (lengthOfEachField == null) {
                throw new IllegalArgumentException("Argument lengthOfEachField can not be null for DP_TYPE_MUPLTIPLE_FIXED_LENGTH_FIELDS !");
            }
            if (lengthOfEachField.length < 1) {
                throw new IllegalArgumentException("Argument lengthOfEachField must specify at least one length for DP_TYPE_MUPLTIPLE_FIXED_LENGTH_FIELDS !");
            }
        }
        this.dataPacketStructure = dataPacketStructure;
        this.fieldDelimiter = fieldDelimiter;
        this.lengthOfEachField = lengthOfEachField;
    }

    public void setDataFieldFilter(int dataFieldFilter) {
        if (dataFieldFilter < 19 || dataFieldFilter > 21) {
            throw new IllegalArgumentException("Argument dataFieldFilter is invalid !");
        }
        this.dataFieldFilter = dataFieldFilter;
    }

    public void setDataFieldFormConverter(int dataFieldFormConversion) {
        if (dataFieldFormConversion < 22 || dataFieldFormConversion > 24) {
            throw new IllegalArgumentException("Argument dataFieldFormConversion is invalid !");
        }
        this.dataFieldFormConversion = dataFieldFormConversion;
    }
}

