/*
 * Decompiled with CFR 0.152.
 */
package com.embeddedunveiled.serial.datalogger;

import com.embeddedunveiled.serial.SerialComException;
import com.embeddedunveiled.serial.SerialComManager;

public final class SerialComLogSource {
    private final SerialComManager scm;
    private final int readingStyle;
    private final int pollingFrequency;
    private long comPortHandle;
    public static final int NONBLOCKING_PERIODIC = 1;
    public static final int BLOCKING = 2;
    public static final int DATALISTENER = 3;

    public SerialComLogSource(SerialComManager scm, int readingStyle, int pollingFrequency) {
        this.scm = scm;
        if (readingStyle < 1 || readingStyle > 3) {
            throw new IllegalArgumentException("Argument readingStyle is invalid !");
        }
        this.readingStyle = readingStyle;
        this.pollingFrequency = pollingFrequency;
    }

    public boolean createComPortSource(String comPort, SerialComManager.DATABITS dataBits, SerialComManager.STOPBITS stopBits, SerialComManager.BAUDRATE baudRate, SerialComManager.PARITY parity, SerialComManager.FLOWCONTROL flowctrl) throws SerialComException {
        this.comPortHandle = this.scm.openComPort(comPort, true, true, true);
        this.scm.configureComPortData(this.comPortHandle, dataBits, stopBits, parity, baudRate, 0);
        this.scm.configureComPortControl(this.comPortHandle, flowctrl, '\u0011', '\u0013', false, false);
        return true;
    }

    public boolean destroyComPortSource() throws SerialComException {
        this.scm.closeComPort(this.comPortHandle);
        return true;
    }
}

