/*
 * Decompiled with CFR 0.152.
 */
package com.embeddedunveiled.serial.hid;

import com.embeddedunveiled.serial.util.SerialComUtil;

public final class SerialComHIDdevice {
    private final String transport;
    private final String deviceNode;
    private final String idVendor;
    private final String idProduct;
    private final String serial;
    private final String product;
    private final String manufacturer;
    private final String location;

    public SerialComHIDdevice(String transport, String deviceNode, String idVendor, String idProduct, String serial, String product, String manufacturer, String location) {
        this.transport = transport;
        this.deviceNode = deviceNode;
        this.idVendor = idVendor;
        this.idProduct = idProduct;
        this.serial = serial;
        this.product = product;
        this.manufacturer = manufacturer;
        this.location = location;
    }

    public String getTransportType() {
        return this.transport;
    }

    public String getDeviceNode() {
        return this.deviceNode;
    }

    public int getVendorID() {
        if ("---".equals(this.idVendor)) {
            return -1;
        }
        return (int)SerialComUtil.hexStrToLongNumber(this.idVendor);
    }

    public int getProductID() {
        if ("---".equals(this.idProduct)) {
            return -1;
        }
        return (int)SerialComUtil.hexStrToLongNumber(this.idProduct);
    }

    public String getSerialNumber() {
        return this.serial;
    }

    public String getProductString() {
        return this.product;
    }

    public String getManufacturerString() {
        return this.manufacturer;
    }

    public String getLocation() {
        return this.location;
    }

    public void dumpDeviceInfo() {
        System.out.println("Transport : " + this.transport + "\nDevice node : " + this.deviceNode + "\nVendor id : 0x" + this.idVendor + "\nProduct id : 0x" + this.idProduct + "\nSerial number : " + this.serial + "\nProduct : " + this.product + "\nManufacturer : " + this.manufacturer + "\nLocation : " + this.location);
    }
}

