/*
 * Decompiled with CFR 0.152.
 */
package com.embeddedunveiled.serial.hid;

import com.embeddedunveiled.serial.SerialComException;
import com.embeddedunveiled.serial.hid.HIDInputReportReader;
import com.embeddedunveiled.serial.hid.IHIDInputReportListener;
import com.embeddedunveiled.serial.hid.SerialComHID;
import com.embeddedunveiled.serial.hid.SerialComHIDTransport;
import com.embeddedunveiled.serial.hid.SerialComHIDdevice;
import com.embeddedunveiled.serial.internal.HIDdevHandleInfo;
import com.embeddedunveiled.serial.internal.SerialComHIDJNIBridge;
import com.embeddedunveiled.serial.usb.SerialComUSBHID;
import com.embeddedunveiled.serial.util.SerialComUtil;
import java.util.HashMap;
import java.util.TreeMap;

public final class SerialComRawHID
extends SerialComHID {
    private final Object lock = new Object();
    private final TreeMap<Long, HIDdevHandleInfo> devInfo = new TreeMap();
    private final HashMap<IHIDInputReportListener, Long> listenerToHandleMap = new HashMap();

    public SerialComRawHID(SerialComHIDJNIBridge mHIDJNIBridge, int osType) {
        super(mHIDJNIBridge, osType);
    }

    public SerialComHIDdevice[] listHIDdevicesWithInfoR() throws SerialComException {
        int i = 0;
        int numOfDevices = 0;
        SerialComHIDdevice[] hidDevicesFound = null;
        String[] hidDevicesInfo = this.mHIDJNIBridge.listHIDdevicesWithInfoR();
        if (hidDevicesInfo != null) {
            if (hidDevicesInfo.length < 3) {
                return new SerialComHIDdevice[0];
            }
            numOfDevices = hidDevicesInfo.length / 8;
            hidDevicesFound = new SerialComHIDdevice[numOfDevices];
            for (int x = 0; x < numOfDevices; ++x) {
                hidDevicesFound[x] = new SerialComHIDdevice(hidDevicesInfo[i], hidDevicesInfo[i + 1], hidDevicesInfo[i + 2], hidDevicesInfo[i + 3], hidDevicesInfo[i + 4], hidDevicesInfo[i + 5], hidDevicesInfo[i + 6], hidDevicesInfo[i + 7]);
                i += 8;
            }
            return hidDevicesFound;
        }
        throw new SerialComException("Could not find HID devices. Please retry !");
    }

    public String formatReportToHexR(byte[] report, String separator) throws SerialComException {
        return SerialComUtil.byteArrayToHexString(report, separator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long openHidDeviceR(String pathName, boolean shared) throws SerialComException {
        if (pathName == null) {
            throw new IllegalArgumentException("Argument pathName can not be null !");
        }
        String pathNameVal = pathName.trim();
        if (pathNameVal.length() == 0) {
            throw new IllegalArgumentException("Argument pathName can not be empty string !");
        }
        long handle = this.mHIDJNIBridge.openHidDeviceR(pathNameVal, shared, this.osType);
        if (handle < 0L) {
            throw new SerialComException("Could not open the HID device " + pathNameVal + ". Please retry !");
        }
        Object object = this.lock;
        synchronized (object) {
            this.devInfo.put(handle, new HIDdevHandleInfo(null));
        }
        return handle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean closeHidDeviceR(long handle) throws SerialComException {
        HIDdevHandleInfo info = this.devInfo.get(handle);
        if (info == null) {
            throw new SerialComException("Given handle does not represent a HID device opened through SCM !");
        }
        if (info.getInputReportListener() != null) {
            throw new IllegalStateException("Closing device handle without unregistering input report listener is not allowed to prevent inconsistency !");
        }
        int ret = this.mHIDJNIBridge.closeHidDeviceR(handle);
        if (ret < 0) {
            throw new SerialComException("Could not close the given HID device. Please retry !");
        }
        Object object = this.lock;
        synchronized (object) {
            this.devInfo.remove(handle);
        }
        return true;
    }

    public long createBlockingHIDIOContextR() throws SerialComException {
        long ret = this.mHIDJNIBridge.createBlockingHIDIOContextR();
        if (ret < 0L) {
            throw new SerialComException("Could not create blocking HID I/O context. Please retry !");
        }
        return ret;
    }

    public boolean unblockBlockingHIDIOOperationR(long context) throws SerialComException {
        int ret = this.mHIDJNIBridge.unblockBlockingHIDIOOperationR(context);
        if (ret < 0) {
            throw new SerialComException("Could not unblock the blocked HID I/O operation. Please retry !");
        }
        return true;
    }

    public boolean destroyBlockingIOContextR(long context) throws SerialComException {
        int ret = this.mHIDJNIBridge.destroyBlockingIOContextR(context);
        if (ret < 0) {
            throw new SerialComException("Could not destroy blocking HID I/O context. Please retry !");
        }
        return true;
    }

    public int writeOutputReportR(long handle, byte reportId, byte[] report) throws SerialComException {
        if (report == null) {
            throw new IllegalArgumentException("Argumenet report can not be null !");
        }
        if (report.length == 0) {
            throw new IllegalArgumentException("Argumenet report can not be of zero length !");
        }
        int ret = this.mHIDJNIBridge.writeOutputReportR(handle, reportId, report, report.length);
        if (ret < 0) {
            throw new SerialComException("Could not write output report to the HID device. Please retry !");
        }
        return ret;
    }

    public int readInputReportR(long handle, byte[] reportBuffer, long context) throws SerialComException {
        if (reportBuffer == null) {
            throw new IllegalArgumentException("Argumenet reportBuffer can not be null !");
        }
        int ret = this.mHIDJNIBridge.readInputReportR(handle, reportBuffer, reportBuffer.length, context);
        if (ret < 0) {
            throw new SerialComException("Could not read input report from HID device. Please retry !");
        }
        return ret;
    }

    public int readInputReportWithTimeoutR(long handle, byte[] reportBuffer, int timeoutValue) throws SerialComException {
        if (reportBuffer == null) {
            throw new IllegalArgumentException("Argumenet reportBuffer can not be null !");
        }
        int ret = this.mHIDJNIBridge.readInputReportWithTimeoutR(handle, reportBuffer, reportBuffer.length, timeoutValue);
        if (ret < 0) {
            throw new SerialComException("Could not read input report from HID device. Please retry !");
        }
        return ret;
    }

    public int sendFeatureReportR(long handle, byte reportId, byte[] report) throws SerialComException {
        if (report == null) {
            throw new IllegalArgumentException("Argumenet report can not be null !");
        }
        if (report.length == 0) {
            throw new IllegalArgumentException("Argumenet report can not be of zero length !");
        }
        int ret = this.mHIDJNIBridge.sendFeatureReportR(handle, reportId, report, report.length);
        if (ret < 0) {
            throw new SerialComException("Could not send feature report to HID device. Please retry !");
        }
        return ret;
    }

    public int getFeatureReportR(long handle, byte reportId, byte[] report) throws SerialComException {
        if (report == null) {
            throw new IllegalArgumentException("Argumenet report can not be null !");
        }
        int ret = this.mHIDJNIBridge.getFeatureReportR(handle, reportId, report, report.length);
        if (ret < 0) {
            throw new SerialComException("Could not get feature report from HID device. Please retry !");
        }
        return ret;
    }

    public String getManufacturerStringR(long handle) throws SerialComException {
        String ret = this.mHIDJNIBridge.getManufacturerStringR(handle);
        if (ret == null) {
            throw new SerialComException("Could not get the manufacturer string from the HID device. Please retry !");
        }
        return ret;
    }

    public String getProductStringR(long handle) throws SerialComException {
        String ret = this.mHIDJNIBridge.getProductStringR(handle);
        if (ret == null) {
            throw new SerialComException("Could not get the product string from the HID device. Please retry !");
        }
        return ret;
    }

    public String getSerialNumberStringR(long handle) throws SerialComException {
        String ret = this.mHIDJNIBridge.getSerialNumberStringR(handle);
        if (ret == null) {
            throw new SerialComException("Could not get the serial number string from the HID device. Please retry !");
        }
        return ret;
    }

    public String getIndexedStringR(long handle, int index) throws SerialComException {
        if (this.osType == 2) {
            String ret = this.mHIDJNIBridge.getIndexedStringR(handle, index);
            if (ret == null) {
                throw new SerialComException("Could not get the string at given index from the HID device. Please retry !");
            }
            return ret;
        }
        throw new SerialComException("Not supported on this operating system !");
    }

    public String findDriverServingHIDDeviceR(String hidDeviceNode) throws SerialComException {
        if (hidDeviceNode == null) {
            throw new IllegalArgumentException("Argument hidDeviceNode can not be null !");
        }
        if (hidDeviceNode.length() == 0) {
            throw new IllegalArgumentException("Argument hidDeviceNode can not be empty string !");
        }
        if (hidDeviceNode.length() > 256) {
            throw new IllegalArgumentException("Argument hidDeviceNode string can not be greater than 256 in length !");
        }
        String driverName = this.mHIDJNIBridge.findDriverServingHIDDeviceR(hidDeviceNode);
        if (driverName == null) {
            throw new SerialComException("Failed to find driver serving the given HID device. Please retry !");
        }
        return driverName;
    }

    public byte[] getReportDescriptorR(long handle) throws SerialComException {
        byte[] reportDescriptorRead = this.mHIDJNIBridge.getReportDescriptorR(handle);
        if (reportDescriptorRead != null) {
            return reportDescriptorRead;
        }
        return new byte[0];
    }

    public byte[] getPhysicalDescriptorR(long handle) throws SerialComException {
        byte[] physicalDescriptorRead = this.mHIDJNIBridge.getPhysicalDescriptorR(handle);
        if (physicalDescriptorRead != null) {
            return physicalDescriptorRead;
        }
        return new byte[0];
    }

    public boolean flushInputReportQueueR(long handle) throws SerialComException {
        int ret = this.mHIDJNIBridge.flushInputReportQueueR(handle);
        if (ret < 0) {
            throw new SerialComException("Could not flush the input report queue. Please retry !");
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean registerInputReportListener(long handle, IHIDInputReportListener listener, byte[] inputReportBuffer) throws SerialComException {
        HIDdevHandleInfo info = this.devInfo.get(handle);
        if (info != null && info.getInputReportListener() != null) {
            throw new IllegalStateException("Input report listener already exist for given handle !");
        }
        if (listener == null) {
            throw new IllegalArgumentException("Argument listener can not be null !");
        }
        long context = this.createBlockingHIDIOContextR();
        Thread dataReaderThread = new Thread(new HIDInputReportReader(handle, listener, inputReportBuffer, context, this));
        Object object = this.lock;
        synchronized (object) {
            info.setInputReportListener(listener);
            info.setListenerContext(context);
            this.listenerToHandleMap.put(listener, handle);
            dataReaderThread.start();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unregisterInputReportListener(IHIDInputReportListener listener) throws SerialComException {
        if (listener == null) {
            throw new IllegalArgumentException("Argument listener can not be null !");
        }
        long handle = this.listenerToHandleMap.get(listener);
        HIDdevHandleInfo info = this.devInfo.get(handle);
        if (info == null) {
            throw new IllegalArgumentException("Invalid listener passed for unregistration !");
        }
        long context = info.getListenerContext();
        Object object = this.lock;
        synchronized (object) {
            this.unblockBlockingHIDIOOperationR(context);
            try {
                Thread.sleep(2L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            this.destroyBlockingIOContextR(context);
            info.setInputReportListener(null);
            this.listenerToHandleMap.remove(listener);
        }
        return true;
    }

    public SerialComHIDTransport getHIDTransportInstance(int transport) throws SerialComException {
        if (transport == 4) {
            return new SerialComUSBHID(this.mHIDJNIBridge, this.osType);
        }
        if (transport != 5) {
            throw new IllegalArgumentException("Argument transport must be one of the HID_XXX constants !");
        }
        return null;
    }

    public boolean readPlatformSpecificInputReportR(long handle, byte reportId, byte[] reportBuffer) throws SerialComException {
        if (reportBuffer == null) {
            throw new IllegalArgumentException("Argumenet reportBuffer can not be null !");
        }
        int ret = this.mHIDJNIBridge.readPlatformSpecificInputReportR(handle, reportId, reportBuffer, reportBuffer.length);
        if (ret < 0) {
            throw new SerialComException("Could not read input report from HID device. Please retry !");
        }
        return true;
    }

    public boolean writePlatformSpecificOutputReportR(long handle, byte reportId, byte[] reportBuffer) throws SerialComException {
        if (reportBuffer == null) {
            throw new IllegalArgumentException("Argumenet reportBuffer can not be null !");
        }
        int ret = this.mHIDJNIBridge.writePlatformSpecificOutputReportR(handle, reportId, reportBuffer, reportBuffer.length);
        if (ret < 0) {
            throw new SerialComException("Could not read input report from HID device. Please retry !");
        }
        return true;
    }
}

