/*
 * Decompiled with CFR 0.152.
 */
package com.embeddedunveiled.serial.internal;

import com.embeddedunveiled.serial.SerialComLoadException;
import com.embeddedunveiled.serial.SerialComUnexpectedException;
import com.embeddedunveiled.serial.internal.SerialComHIDJNIBridge;
import com.embeddedunveiled.serial.internal.SerialComSystemProperty;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;

public final class SerialComBluetoothJNIBridge {
    public static boolean loadNativeLibrary(String directoryPath, String loadedLibName, SerialComSystemProperty serialComSystemProperty, int osType, int cpuArch, int javaABIType, int btStack) throws SerialComUnexpectedException, SerialComLoadException {
        File libFile;
        block64: {
            String javaTmpDir = null;
            String userHomeDir = null;
            String fileSeparator = null;
            File baseDir = null;
            File workingDir = null;
            boolean isTmpDir = false;
            boolean isUserHomeDir = false;
            String libToExtractFromJar = null;
            libFile = null;
            String libExtension = null;
            InputStream input = null;
            FileOutputStream output = null;
            String stackName = null;
            if (btStack == 1) {
                stackName = "btbluez";
            }
            if ((fileSeparator = serialComSystemProperty.getfileSeparator()) == null) {
                throw new SerialComUnexpectedException("The file.separator java system property is null in the system !");
            }
            if (directoryPath == null) {
                javaTmpDir = serialComSystemProperty.getJavaIOTmpDir();
                if (javaTmpDir == null) {
                    throw new SerialComUnexpectedException("The java.io.tmpdir java system property is null in the system !");
                }
                baseDir = new File(javaTmpDir);
                if (baseDir.exists() && baseDir.isDirectory() && baseDir.canWrite()) {
                    isTmpDir = true;
                } else {
                    userHomeDir = serialComSystemProperty.getUserHome();
                    if (userHomeDir == null) {
                        throw new SerialComUnexpectedException("The user.home java system property is null in the system !");
                    }
                    baseDir = new File(userHomeDir);
                    if (!baseDir.exists()) {
                        throw new SerialComLoadException("User home directory does not exist. Also unable to access tmp/temp directory !");
                    }
                    if (!baseDir.isDirectory()) {
                        throw new SerialComLoadException("User home directory is not a directory. Also unable to access tmp/temp directory !");
                    }
                    if (!baseDir.canWrite()) {
                        throw new SerialComLoadException("User home directory is not writeable (permissions ??). Also unable to access tmp/temp directory !");
                    }
                    isUserHomeDir = true;
                }
                workingDir = new File(baseDir.toString() + fileSeparator + "scm_tuartx1");
                if (!workingDir.exists() && !workingDir.mkdir()) {
                    if (isTmpDir) {
                        throw new SerialComLoadException("Can not create scm_tuartx1 unique directory in temp directory !");
                    }
                    if (isUserHomeDir) {
                        throw new SerialComLoadException("Can not create scm_tuartx1 unique directory in user home directory !");
                    }
                }
            } else {
                baseDir = new File(directoryPath);
                if (!baseDir.exists()) {
                    throw new SerialComLoadException("Given " + directoryPath + " directory does not exist !");
                }
                if (!baseDir.isDirectory()) {
                    throw new SerialComLoadException("Given " + directoryPath + " is not a directory !");
                }
                if (!baseDir.canWrite()) {
                    throw new SerialComLoadException("Given " + directoryPath + " directory is not writeable !");
                }
                workingDir = baseDir;
            }
            if (cpuArch == 2) {
                switch (osType) {
                    case 2: {
                        libToExtractFromJar = "win" + stackName + "_" + "1.0.4" + "_x86_64.dll";
                        libExtension = ".dll";
                        break;
                    }
                    case 1: {
                        libToExtractFromJar = "linux" + stackName + "_" + "1.0.4" + "_x86_64.so";
                        libExtension = ".so";
                        break;
                    }
                    case 4: {
                        libToExtractFromJar = "mac" + stackName + "_" + "1.0.4" + "_x86_64.dylib";
                        libExtension = ".dylib";
                        break;
                    }
                }
            } else if (cpuArch == 1) {
                switch (osType) {
                    case 2: {
                        libToExtractFromJar = "win" + stackName + "_" + "1.0.4" + "_x86.dll";
                        libExtension = ".dll";
                        break;
                    }
                    case 1: {
                        libToExtractFromJar = "linux" + stackName + "_" + "1.0.4" + "_x86.so";
                        libExtension = ".so";
                        break;
                    }
                    case 4: {
                        libToExtractFromJar = "mac" + stackName + "_" + "1.0.4" + "_x86.dylib";
                        libExtension = ".dylib";
                        break;
                    }
                }
            } else if (cpuArch == 15) {
                if (osType == 1) {
                    libExtension = ".so";
                    if (javaABIType == 1) {
                        libToExtractFromJar = "linux" + stackName + "_" + "1.0.4" + "_armv7hf.so";
                    } else if (javaABIType == 2) {
                        libToExtractFromJar = "linux" + stackName + "_" + "1.0.4" + "_armv7el.so";
                    }
                }
            } else if (cpuArch == 14) {
                if (osType == 1) {
                    libExtension = ".so";
                    if (javaABIType == 1) {
                        libToExtractFromJar = "linux" + stackName + "_" + "1.0.4" + "_armv6hf.so";
                    } else if (javaABIType == 2) {
                        libToExtractFromJar = "linux" + stackName + "_" + "1.0.4" + "_armv6el.so";
                    }
                }
            } else if (cpuArch == 13 && osType == 1) {
                libExtension = ".so";
                libToExtractFromJar = "linux" + stackName + "_" + "1.0.4" + "_armv5.so";
            }
            try {
                libFile = loadedLibName == null ? new File(workingDir.getAbsolutePath() + fileSeparator + libToExtractFromJar) : new File(workingDir.getAbsolutePath() + fileSeparator + loadedLibName.trim() + libExtension);
                input = SerialComHIDJNIBridge.class.getResourceAsStream("/lib-bluetooth/" + libToExtractFromJar);
                output = new FileOutputStream(libFile);
                if (input != null) {
                    int read;
                    byte[] buffer = new byte[4096];
                    while ((read = input.read(buffer)) != -1) {
                        output.write(buffer, 0, read);
                    }
                    output.flush();
                    output.close();
                    output = null;
                    if (libFile != null && libFile.exists() && libFile.isFile()) {
                        break block64;
                    }
                    throw new SerialComLoadException("Can not extract native shared library " + libToExtractFromJar + " from scm-x.x.x.jar file !");
                }
                throw new SerialComLoadException("Can not get shared library " + libToExtractFromJar + " resource as stream from scm-x.x.x.jar file using class loader !");
            }
            catch (Exception e) {
                throw (SerialComLoadException)new SerialComLoadException(libFile.toString()).initCause(e);
            }
            finally {
                try {
                    if (output != null) {
                        output.close();
                    }
                }
                catch (Exception e) {}
                try {
                    if (input != null) {
                        input.close();
                    }
                }
                catch (Exception e) {}
            }
        }
        try {
            System.load(libFile.toString());
        }
        catch (Exception e) {
            throw (UnsatisfiedLinkError)new UnsatisfiedLinkError("Could not load " + libFile.toString() + " native library !").initCause(e);
        }
        return true;
    }

    public native String[] listBluetoothAdaptorsWithInfo();
}

