/*
 * Decompiled with CFR 0.152.
 */
package com.embeddedunveiled.serial.internal;

import com.embeddedunveiled.serial.SerialComLoadException;
import com.embeddedunveiled.serial.SerialComUnexpectedException;
import com.embeddedunveiled.serial.internal.SerialComPortJNIBridge;
import com.embeddedunveiled.serial.internal.SerialComSystemProperty;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;

public final class SerialComCP210xManufacturingJNIBridge {
    public static boolean loadNativeLibrary(File libDirectory, String vlibName, int cpuArch, int osType, SerialComSystemProperty serialComSystemProperty) throws SerialComUnexpectedException, SerialComLoadException {
        String fileSeparator;
        File vlibFile;
        File libFile;
        block36: {
            String libToExtractFromJar = null;
            libFile = null;
            vlibFile = null;
            InputStream input = null;
            FileOutputStream output = null;
            fileSeparator = null;
            fileSeparator = serialComSystemProperty.getfileSeparator();
            if (fileSeparator == null) {
                throw new SerialComUnexpectedException("The file.separator java system property is null in the system !");
            }
            if (cpuArch == 2) {
                switch (osType) {
                    case 2: {
                        libToExtractFromJar = "win_cp210xm_1.0.4_x86_64.dll";
                        break;
                    }
                    case 1: {
                        libToExtractFromJar = "linux_cp210xm_1.0.4_x86_64.so";
                        break;
                    }
                    case 4: {
                        libToExtractFromJar = "mac_cp210xm_1.0.4_x86_64.dylib";
                    }
                }
            } else if (cpuArch == 1) {
                switch (osType) {
                    case 2: {
                        libToExtractFromJar = "win_cp210xm_1.0.4_x86.dll";
                        break;
                    }
                    case 1: {
                        libToExtractFromJar = "linux_cp210xm_1.0.4_x86.so";
                        break;
                    }
                    case 4: {
                        libToExtractFromJar = "mac_cp210xm_1.0.4_x86.dylib";
                    }
                }
            }
            try {
                libFile = new File(libDirectory.getAbsolutePath() + fileSeparator + libToExtractFromJar);
                input = SerialComPortJNIBridge.class.getResourceAsStream("/lib-vendor/" + libToExtractFromJar);
                output = new FileOutputStream(libFile);
                if (input != null) {
                    int read;
                    byte[] buffer = new byte[4096];
                    while ((read = input.read(buffer)) != -1) {
                        output.write(buffer, 0, read);
                    }
                    output.flush();
                    output.close();
                    output = null;
                    if (libFile == null || !libFile.exists() || !libFile.isFile()) {
                        throw new SerialComLoadException("Can not extract native shared library from scm-x.x.x.jar file !");
                    }
                    break block36;
                }
                throw new SerialComLoadException("Can not get shared library resource as stream from scm-x.x.x.jar file using class loader !");
            }
            catch (Exception e) {
                throw (SerialComLoadException)new SerialComLoadException(libFile.toString()).initCause(e);
            }
            finally {
                try {
                    if (output != null) {
                        output.close();
                    }
                }
                catch (Exception e) {}
                try {
                    if (input != null) {
                        input.close();
                    }
                }
                catch (Exception e) {}
            }
        }
        try {
            vlibFile = new File(libDirectory.getAbsolutePath() + fileSeparator + vlibName);
            System.load(vlibFile.toString());
        }
        catch (Exception e) {
            throw (UnsatisfiedLinkError)new UnsatisfiedLinkError("Could not load " + vlibFile.toString() + " native library !").initCause(e);
        }
        try {
            System.load(libFile.toString());
        }
        catch (Exception e) {
            throw (UnsatisfiedLinkError)new UnsatisfiedLinkError("Could not load " + libFile.toString() + " native library !").initCause(e);
        }
        return true;
    }

    public native int getNumDevices();

    public native int reset(long var1);

    public native int createHexFile(long var1, String var3);

    public native String getPartNumber(long var1);

    public native String getDeviceManufacturerString(long var1);

    public native long open(int var1);

    public native int close(long var1);

    public native int setProductString(long var1, String var3);

    public native String getProductString(int var1, int var2);

    public native String getDeviceProductString(long var1);

    public native int setVid(long var1, int var3);

    public native int getDeviceVid(long var1);

    public native int setPid(long var1, int var3);

    public native int getDevicePid(long var1);

    public native int setSerialNumber(long var1, String var3);

    public native String getDeviceSerialNumber(long var1);

    public native int setInterfaceString(long var1, byte var3, String var4);

    public native String getDeviceInterfaceString(long var1, byte var3);

    public native int setSelfPower(long var1, boolean var3);

    public native int getSelfPower(long var1);

    public native int setMaxPower(long var1, byte var3);

    public native int getMaxPower(long var1);

    public native int setFlushBufferConfig(long var1, int var3);

    public native int getFlushBufferConfig(long var1);

    public native int setDeviceMode(long var1, byte var3, byte var4);

    public native byte[] getDeviceMode(long var1);

    public native int setDeviceVersion(long var1, int var3);

    public native int getDeviceVersion(long var1);

    public native int setBaudRateConfig(long var1, int var3, int var4, int var5, int var6);

    public native int[] getBaudRateConfig(long var1);

    public native int setPortConfig(long var1, int var3, int var4, int var5, int var6);

    public native int[] getPortConfig(long var1);

    public native int setDualPortConfig(long var1, int var3, int var4, int var5, int var6, int var7, int var8);

    public native int[] getDualPortConfig(long var1);

    public native int setQuadPortConfig(long var1, int[] var3, int[] var4, byte[] var5);

    public native int[] getQuadPortConfig(long var1);

    public native int setLockValue(long var1);

    public native int getLockValue(long var1);
}

