/*
 * Decompiled with CFR 0.152.
 */
package com.embeddedunveiled.serial.internal;

import com.embeddedunveiled.serial.SerialComLoadException;
import com.embeddedunveiled.serial.SerialComUnexpectedException;
import com.embeddedunveiled.serial.internal.SerialComPortJNIBridge;
import com.embeddedunveiled.serial.internal.SerialComSystemProperty;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;

public final class SerialComCP210xRuntimeJNIBridge {
    public static boolean loadNativeLibrary(File libDirectory, String vlibName, int cpuArch, int osType, SerialComSystemProperty serialComSystemProperty) throws SerialComUnexpectedException, SerialComLoadException {
        String fileSeparator;
        File vlibFile;
        File libFile;
        block36: {
            String libToExtractFromJar = null;
            libFile = null;
            vlibFile = null;
            InputStream input = null;
            FileOutputStream output = null;
            fileSeparator = null;
            fileSeparator = serialComSystemProperty.getfileSeparator();
            if (fileSeparator == null) {
                throw new SerialComUnexpectedException("The file.separator java system property is null in the system !");
            }
            if (cpuArch == 2) {
                switch (osType) {
                    case 2: {
                        libToExtractFromJar = "win_cp210xr_1.0.4_x86_64.dll";
                        break;
                    }
                    case 1: {
                        libToExtractFromJar = "linux_cp210xr_1.0.4_x86_64.so";
                        break;
                    }
                    case 4: {
                        libToExtractFromJar = "mac_cp210xr_1.0.4_x86_64.dylib";
                    }
                }
            } else if (cpuArch == 1) {
                switch (osType) {
                    case 2: {
                        libToExtractFromJar = "win_cp210xr_1.0.4_x86.dll";
                        break;
                    }
                    case 1: {
                        libToExtractFromJar = "linux_cp210xr_1.0.4_x86.so";
                        break;
                    }
                    case 4: {
                        libToExtractFromJar = "mac_cp210xr_1.0.4_x86.dylib";
                    }
                }
            }
            try {
                libFile = new File(libDirectory.getAbsolutePath() + fileSeparator + libToExtractFromJar);
                input = SerialComPortJNIBridge.class.getResourceAsStream("/lib-vendor/" + libToExtractFromJar);
                output = new FileOutputStream(libFile);
                if (input != null) {
                    int read;
                    byte[] buffer = new byte[4096];
                    while ((read = input.read(buffer)) != -1) {
                        output.write(buffer, 0, read);
                    }
                    output.flush();
                    output.close();
                    output = null;
                    if (libFile == null || !libFile.exists() || !libFile.isFile()) {
                        throw new SerialComLoadException("Can not extract native shared library from scm-x.x.x.jar file !");
                    }
                    break block36;
                }
                throw new SerialComLoadException("Can not get shared library resource as stream from scm-x.x.x.jar file using class loader !");
            }
            catch (Exception e) {
                throw (SerialComLoadException)new SerialComLoadException(libFile.toString()).initCause(e);
            }
            finally {
                try {
                    if (output != null) {
                        output.close();
                    }
                }
                catch (Exception e) {}
                try {
                    if (input != null) {
                        input.close();
                    }
                }
                catch (Exception e) {}
            }
        }
        try {
            vlibFile = new File(libDirectory.getAbsolutePath() + fileSeparator + vlibName);
            System.load(vlibFile.toString());
        }
        catch (Exception e) {
            throw (UnsatisfiedLinkError)new UnsatisfiedLinkError("Could not load " + vlibFile.toString() + " native library !").initCause(e);
        }
        try {
            System.load(libFile.toString());
        }
        catch (Exception e) {
            throw (UnsatisfiedLinkError)new UnsatisfiedLinkError("Could not load " + libFile.toString() + " native library !").initCause(e);
        }
        return true;
    }

    public native int readLatch(long var1);

    public native int writeLatch(long var1, long var3, long var5);

    public native String getPartNumber(long var1);

    public native String getDeviceProductString(long var1);

    public native String getDeviceSerialNumber(long var1);

    public native String getDeviceInterfaceString(long var1);
}

