/*
 * Decompiled with CFR 0.152.
 */
package com.embeddedunveiled.serial.internal;

import com.embeddedunveiled.serial.ISerialComDataListener;
import com.embeddedunveiled.serial.ISerialComEventListener;
import com.embeddedunveiled.serial.SerialComException;
import com.embeddedunveiled.serial.internal.SerialComLooper;
import com.embeddedunveiled.serial.internal.SerialComPortHandleInfo;
import com.embeddedunveiled.serial.internal.SerialComPortJNIBridge;
import java.util.Map;
import java.util.TreeMap;

public final class SerialComCompletionDispatcher {
    private SerialComPortJNIBridge mComPortJNIBridge = null;
    private TreeMap<Long, SerialComPortHandleInfo> mPortHandleInfo = null;

    public SerialComCompletionDispatcher(SerialComPortJNIBridge mComPortJNIBridge, TreeMap<Long, SerialComPortHandleInfo> portHandleInfo) {
        this.mComPortJNIBridge = mComPortJNIBridge;
        this.mPortHandleInfo = portHandleInfo;
    }

    public boolean setUpDataLooper(long handle, SerialComPortHandleInfo mHandleInfo, ISerialComDataListener dataListener) throws SerialComException {
        int ret = 0;
        SerialComLooper looper = mHandleInfo.getLooper();
        if (looper == null) {
            looper = new SerialComLooper(this.mComPortJNIBridge);
            mHandleInfo.setLooper(looper);
        }
        looper.startDataLooper(handle, dataListener, mHandleInfo.getOpenedPortName());
        mHandleInfo.setDataListener(dataListener);
        try {
            ret = this.mComPortJNIBridge.setUpDataLooperThread(handle, looper);
            if (ret < 0) {
                looper.stopDataLooper();
                mHandleInfo.setDataListener(null);
                if (mHandleInfo.getEventListener() == null) {
                    mHandleInfo.setLooper(null);
                }
                throw new SerialComException("Could not create native data worker thread. Please retry !");
            }
        }
        catch (SerialComException e) {
            looper.stopDataLooper();
            mHandleInfo.setDataListener(null);
            if (mHandleInfo.getEventListener() == null) {
                mHandleInfo.setLooper(null);
            }
            throw new SerialComException(e.getExceptionMsg());
        }
        return true;
    }

    public boolean destroyDataLooper(long handle, SerialComPortHandleInfo handleInfo, ISerialComDataListener dataListener) throws SerialComException {
        int ret = this.mComPortJNIBridge.destroyDataLooperThread(handle);
        if (ret < 0) {
            throw new SerialComException("Could not unregister data listener (termination of native thread failed.). Please retry !");
        }
        handleInfo.getLooper().stopDataLooper();
        handleInfo.setDataListener(null);
        if (handleInfo.getEventListener() == null && handleInfo.getDataListener() == null) {
            handleInfo.setLooper(null);
        }
        return true;
    }

    public boolean setUpEventLooper(long handle, SerialComPortHandleInfo mHandleInfo, ISerialComEventListener eventListener) throws SerialComException {
        int ret = 0;
        SerialComLooper looper = mHandleInfo.getLooper();
        if (looper == null) {
            looper = new SerialComLooper(this.mComPortJNIBridge);
            mHandleInfo.setLooper(looper);
        }
        looper.startEventLooper(handle, eventListener, mHandleInfo.getOpenedPortName());
        mHandleInfo.setEventListener(eventListener);
        try {
            ret = this.mComPortJNIBridge.setUpEventLooperThread(handle, looper);
            if (ret < 0) {
                looper.stopEventLooper();
                mHandleInfo.setEventListener(null);
                if (mHandleInfo.getDataListener() == null) {
                    mHandleInfo.setLooper(null);
                }
                throw new SerialComException("Could not create native event worker thread. Please retry !");
            }
        }
        catch (SerialComException e) {
            looper.stopEventLooper();
            mHandleInfo.setEventListener(null);
            if (mHandleInfo.getDataListener() == null) {
                mHandleInfo.setLooper(null);
            }
            throw new SerialComException(e.getExceptionMsg());
        }
        return true;
    }

    public boolean destroyEventLooper(long handle, SerialComPortHandleInfo handleInfo, ISerialComEventListener eventListener) throws SerialComException {
        int ret = this.mComPortJNIBridge.destroyEventLooperThread(handle);
        if (ret < 0) {
            throw new SerialComException("Could not unregister event listener (termination of native thread failed.). Please retry !");
        }
        handleInfo.getLooper().stopEventLooper();
        handleInfo.setEventListener(null);
        if (handleInfo.getEventListener() == null && handleInfo.getDataListener() == null) {
            handleInfo.setLooper(null);
        }
        return true;
    }

    public boolean pauseListeningEvents(ISerialComEventListener listener) throws SerialComException {
        long handle = -1L;
        SerialComLooper looper = null;
        SerialComPortHandleInfo handleInfo = null;
        for (Map.Entry<Long, SerialComPortHandleInfo> entry : this.mPortHandleInfo.entrySet()) {
            handleInfo = entry.getValue();
            if (handleInfo == null || handleInfo.getEventListener() != listener) continue;
            handle = handleInfo.getPortHandle();
            looper = handleInfo.getLooper();
            break;
        }
        if (handle != -1L) {
            int ret = this.mComPortJNIBridge.pauseListeningEvents(handle);
            if (ret < 0) {
                throw new SerialComException("Could not pause event thread !");
            }
        } else {
            throw new SerialComException("This event listener is not registered with SCM !");
        }
        looper.pause();
        return true;
    }

    public boolean resumeListeningEvents(ISerialComEventListener listener) throws SerialComException {
        long handle = -1L;
        SerialComLooper looper = null;
        SerialComPortHandleInfo handleInfo = null;
        for (Map.Entry<Long, SerialComPortHandleInfo> entry : this.mPortHandleInfo.entrySet()) {
            handleInfo = entry.getValue();
            if (handleInfo == null || handleInfo.getEventListener() != listener) continue;
            handle = handleInfo.getPortHandle();
            looper = handleInfo.getLooper();
            break;
        }
        if (handle != -1L) {
            looper.resume();
            int ret = this.mComPortJNIBridge.resumeListeningEvents(handle);
            if (ret < 0) {
                throw new SerialComException("Could not resume event thread !");
            }
        } else {
            throw new SerialComException("This event listener is not registered with SCM !");
        }
        return true;
    }
}

