/*
 * Decompiled with CFR 0.152.
 */
package com.embeddedunveiled.serial.internal;

import com.embeddedunveiled.serial.SerialComLoadException;
import com.embeddedunveiled.serial.SerialComUnexpectedException;
import com.embeddedunveiled.serial.internal.SerialComPortJNIBridge;
import com.embeddedunveiled.serial.internal.SerialComSystemProperty;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;

public final class SerialComFTDID2XXJNIBridge {
    public static boolean loadNativeLibrary(File libDirectory, String vlibName, int cpuArch, int osType, SerialComSystemProperty serialComSystemProperty) throws SerialComUnexpectedException, SerialComLoadException {
        String fileSeparator;
        File vlibFile;
        File libFile;
        block36: {
            String libToExtractFromJar = null;
            libFile = null;
            vlibFile = null;
            InputStream input = null;
            FileOutputStream output = null;
            fileSeparator = null;
            fileSeparator = serialComSystemProperty.getfileSeparator();
            if (fileSeparator == null) {
                throw new SerialComUnexpectedException("The file.separator java system property is null in the system !");
            }
            if (cpuArch == 2) {
                switch (osType) {
                    case 2: {
                        libToExtractFromJar = "win_d2xx_1.0.4_x86_64.dll";
                        break;
                    }
                    case 1: {
                        libToExtractFromJar = "linux_d2xx_1.0.4_x86_64.so";
                        break;
                    }
                    case 4: {
                        libToExtractFromJar = "mac_d2xx_1.0.4_x86_64.dylib";
                    }
                }
            } else if (cpuArch == 1) {
                switch (osType) {
                    case 2: {
                        libToExtractFromJar = "win_d2xx_1.0.4_x86.dll";
                        break;
                    }
                    case 1: {
                        libToExtractFromJar = "linux_d2xx_1.0.4_x86.so";
                        break;
                    }
                    case 4: {
                        libToExtractFromJar = "mac_d2xx_1.0.4_x86.dylib";
                    }
                }
            }
            try {
                libFile = new File(libDirectory.getAbsolutePath() + fileSeparator + libToExtractFromJar);
                input = SerialComPortJNIBridge.class.getResourceAsStream("/lib-vendor/" + libToExtractFromJar);
                output = new FileOutputStream(libFile);
                if (input != null) {
                    int read;
                    byte[] buffer = new byte[4096];
                    while ((read = input.read(buffer)) != -1) {
                        output.write(buffer, 0, read);
                    }
                    output.flush();
                    output.close();
                    output = null;
                    if (libFile == null || !libFile.exists() || !libFile.isFile()) {
                        throw new SerialComLoadException("Can not extract native shared library from scm-x.x.x.jar file !");
                    }
                    break block36;
                }
                throw new SerialComLoadException("Can not get shared library resource as stream from scm-x.x.x.jar file using class loader !");
            }
            catch (Exception e) {
                throw (SerialComLoadException)new SerialComLoadException(libFile.toString()).initCause(e);
            }
            finally {
                try {
                    if (output != null) {
                        output.close();
                    }
                }
                catch (Exception e) {}
                try {
                    if (input != null) {
                        input.close();
                    }
                }
                catch (Exception e) {}
            }
        }
        try {
            vlibFile = new File(libDirectory.getAbsolutePath() + fileSeparator + vlibName);
            System.load(vlibFile.toString());
        }
        catch (Exception e) {
            throw (UnsatisfiedLinkError)new UnsatisfiedLinkError("Could not load " + vlibFile.toString() + " native library !").initCause(e);
        }
        try {
            System.load(libFile.toString());
        }
        catch (Exception e) {
            throw (UnsatisfiedLinkError)new UnsatisfiedLinkError("Could not load " + libFile.toString() + " native library !").initCause(e);
        }
        return true;
    }

    public native int setVidPid(int var1, int var2);

    public native int[] getVidPid();

    public native int createDeviceInfoList();

    public native String[] getDeviceInfoList(int var1);

    public native String[] getDeviceInfoDetail(int var1);

    public native String[] listDevices(int var1, int var2);

    public native long open(int var1);

    public native long openEx(String var1, long var2, int var4);

    public native int close(long var1);

    public native int read(long var1, byte[] var3, int var4);

    public native int write(long var1, byte[] var3, int var4);

    public native int setBaudRate(long var1, int var3);

    public native int setDivisor(long var1, int var3);

    public native int setDataCharacteristics(long var1, int var3, int var4, int var5);

    public native int setTimeouts(long var1, long var3, long var5);

    public native int setFlowControl(long var1, int var3, byte var4, byte var5);

    public native int setDTR(long var1);

    public native int clearDTR(long var1);

    public native int setRTS(long var1);

    public native int clearRTS(long var1);

    public native int getModemStatus(long var1);

    public native int getQueueStatus(long var1);

    public native String[] getDeviceInfo(long var1);

    public native long getDriverVersion(long var1);

    public native long getLibraryVersion();

    public native long getComPortNumber(long var1);

    public native long[] getStatus(long var1);

    public native int setEventNotificationAndWait(long var1, int var3);

    public native int setChars(long var1, byte var3, byte var4, byte var5, byte var6);

    public native int setBreakOn(long var1);

    public native int setBreakOff(long var1);

    public native int purge(long var1, boolean var3, boolean var4);

    public native int resetDevice(long var1);

    public native int resetPort(long var1);

    public native int cyclePort(long var1);

    public native int rescan();

    public native int reload(int var1, int var2);

    public native int setResetPipeRetryCount(long var1, int var3);

    public native int stopInTask(long var1);

    public native int restartInTask(long var1);

    public native int setDeadmanTimeout(long var1, int var3);

    public native int readEE(long var1, int var3);

    public native int writeEE(long var1, int var3, int var4);

    public native int eraseEE(long var1);

    public native int[] eeRead(long var1, int var3, char[] var4, char[] var5, char[] var6, char[] var7);

    public native int eeProgram(long var1, String var3, String var4, String var5, String var6, int[] var7);

    public native int eeProgramEx(long var1, String var3, String var4, String var5, String var6, int[] var7);

    public native int eeUAsize(long var1);

    public native int eeUAread(long var1, byte[] var3, int var4);

    public native int eeUAwrite(long var1, byte[] var3, int var4);

    public native int[] eepromRead(long var1, int var3, char[] var4, char[] var5, char[] var6, char[] var7);

    public native int eepromProgram(long var1, int var3, int[] var4, String var5, String var6, String var7, String var8);

    public native int setLatencyTimer(long var1, int var3);

    public native int getLatencyTimer(long var1);

    public native int setBitMode(long var1, int var3, int var4);

    public native int getBitMode(long var1);

    public native int setUSBParameters(long var1, int var3, int var4);

    public native long w32CreateFile(String var1, String var2, long var3, int var5, int var6, boolean var7);

    public native int w32CloseHandle(long var1);

    public native int w32ReadFile(long var1, byte[] var3, int var4);

    public native int w32WriteFile(long var1, byte[] var3, int var4);

    public native int w32GetOverlappedResult(long var1, boolean var3);

    public native int w32EscapeCommFunction(long var1, short var3);

    public native int w32GetCommModemStatus(long var1);

    public native int w32SetupComm(long var1, int var3, int var4);

    public native int w32SetCommState(long var1, int[] var3);

    public native int[] w32GetCommState(long var1);

    public native int w32SetCommTimeouts(long var1, int var3, int var4, int var5, int var6, int var7);

    public native int[] w32GetCommTimeouts(long var1);

    public native int w32SetCommBreak(long var1);

    public native int w32ClearCommBreak(long var1);

    public native int w32SetCommMask(long var1, int var3);

    public native int w32GetCommMask(long var1);

    public native int w32WaitCommEvent(long var1, int var3);

    public native int w32PurgeComm(long var1, int var3);

    public native String w32GetLastError(long var1);

    public native int[] w32ClearCommError(long var1);
}

