/*
 * Decompiled with CFR 0.152.
 */
package com.embeddedunveiled.serial.internal;

import com.embeddedunveiled.serial.SerialComLoadException;
import com.embeddedunveiled.serial.SerialComUnexpectedException;
import com.embeddedunveiled.serial.internal.SerialComSystemProperty;
import com.embeddedunveiled.serial.util.SerialComUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;

public final class SerialComHIDJNIBridge {
    public static boolean loadNativeLibrary(String directoryPath, String loadedLibName, SerialComSystemProperty serialComSystemProperty, int osType, int cpuArch, int javaABIType) throws SerialComUnexpectedException, SerialComLoadException {
        File libFile;
        block63: {
            String javaTmpDir = null;
            String userHomeDir = null;
            String fileSeparator = null;
            File baseDir = null;
            File workingDir = null;
            boolean isTmpDir = false;
            boolean isUserHomeDir = false;
            String libToExtractFromJar = null;
            libFile = null;
            String libExtension = null;
            InputStream input = null;
            FileOutputStream output = null;
            fileSeparator = serialComSystemProperty.getfileSeparator();
            if (fileSeparator == null) {
                throw new SerialComUnexpectedException("The file.separator java system property is null in the system !");
            }
            if (directoryPath == null) {
                javaTmpDir = serialComSystemProperty.getJavaIOTmpDir();
                if (javaTmpDir == null) {
                    throw new SerialComUnexpectedException("The java.io.tmpdir java system property is null in the system !");
                }
                baseDir = new File(javaTmpDir);
                if (baseDir.exists() && baseDir.isDirectory() && baseDir.canWrite()) {
                    isTmpDir = true;
                } else {
                    userHomeDir = serialComSystemProperty.getUserHome();
                    if (userHomeDir == null) {
                        throw new SerialComUnexpectedException("The user.home java system property is null in the system !");
                    }
                    baseDir = new File(userHomeDir);
                    if (!baseDir.exists()) {
                        throw new SerialComLoadException("User home directory does not exist. Also unable to access tmp/temp directory !");
                    }
                    if (!baseDir.isDirectory()) {
                        throw new SerialComLoadException("User home directory is not a directory. Also unable to access tmp/temp directory !");
                    }
                    if (!baseDir.canWrite()) {
                        throw new SerialComLoadException("User home directory is not writeable (permissions ??). Also unable to access tmp/temp directory !");
                    }
                    isUserHomeDir = true;
                }
                workingDir = new File(baseDir.toString() + fileSeparator + "scm_tuartx1");
                if (!workingDir.exists() && !workingDir.mkdir()) {
                    if (isTmpDir) {
                        throw new SerialComLoadException("Can not create scm_tuartx1 unique directory in temp directory !");
                    }
                    if (isUserHomeDir) {
                        throw new SerialComLoadException("Can not create scm_tuartx1 unique directory in user home directory !");
                    }
                }
            } else {
                baseDir = new File(directoryPath);
                if (!baseDir.exists()) {
                    throw new SerialComLoadException("Given " + directoryPath + " directory does not exist !");
                }
                if (!baseDir.isDirectory()) {
                    throw new SerialComLoadException("Given " + directoryPath + " is not a directory !");
                }
                if (!baseDir.canWrite()) {
                    throw new SerialComLoadException("Given " + directoryPath + " directory is not writeable !");
                }
                workingDir = baseDir;
            }
            if (cpuArch == 2) {
                switch (osType) {
                    case 2: {
                        libToExtractFromJar = "winhid_1.0.4_x86_64.dll";
                        libExtension = ".dll";
                        break;
                    }
                    case 1: {
                        libToExtractFromJar = "linuxhid_1.0.4_x86_64.so";
                        libExtension = ".so";
                        break;
                    }
                    case 4: {
                        libToExtractFromJar = "machid_1.0.4_x86_64.dylib";
                        libExtension = ".dylib";
                        break;
                    }
                }
            } else if (cpuArch == 1) {
                switch (osType) {
                    case 2: {
                        libToExtractFromJar = "winhid_1.0.4_x86.dll";
                        libExtension = ".dll";
                        break;
                    }
                    case 1: {
                        libToExtractFromJar = "linuxhid_1.0.4_x86.so";
                        libExtension = ".so";
                        break;
                    }
                    case 4: {
                        libToExtractFromJar = "machid_1.0.4_x86.dylib";
                        libExtension = ".dylib";
                        break;
                    }
                }
            } else if (cpuArch == 15) {
                if (osType == 1) {
                    libExtension = ".so";
                    if (javaABIType == 1) {
                        libToExtractFromJar = "linuxhid_1.0.4_armv7hf.so";
                    } else if (javaABIType == 2) {
                        libToExtractFromJar = "linuxhid_1.0.4_armv7el.so";
                    }
                }
            } else if (cpuArch == 14) {
                if (osType == 1) {
                    libExtension = ".so";
                    if (javaABIType == 1) {
                        libToExtractFromJar = "linuxhid_1.0.4_armv6hf.so";
                    } else if (javaABIType == 2) {
                        libToExtractFromJar = "linuxhid_1.0.4_armv6el.so";
                    }
                }
            } else if (cpuArch == 13 && osType == 1) {
                libExtension = ".so";
                libToExtractFromJar = "linuxhid_1.0.4_armv5.so";
            }
            try {
                libFile = loadedLibName == null ? new File(workingDir.getAbsolutePath() + fileSeparator + libToExtractFromJar) : new File(workingDir.getAbsolutePath() + fileSeparator + loadedLibName.trim() + libExtension);
                input = SerialComHIDJNIBridge.class.getResourceAsStream("/lib-hid/" + libToExtractFromJar);
                output = new FileOutputStream(libFile);
                if (input != null) {
                    int read;
                    byte[] buffer = new byte[4096];
                    while ((read = input.read(buffer)) != -1) {
                        output.write(buffer, 0, read);
                    }
                    output.flush();
                    output.close();
                    output = null;
                    if (libFile != null && libFile.exists() && libFile.isFile()) {
                        break block63;
                    }
                    throw new SerialComLoadException("Can not extract native shared library " + libToExtractFromJar + " from scm-x.x.x.jar file !");
                }
                throw new SerialComLoadException("Can not get shared library " + libToExtractFromJar + " resource as stream from scm-x.x.x.jar file using class loader !");
            }
            catch (Exception e) {
                throw (SerialComLoadException)new SerialComLoadException(libFile.toString()).initCause(e);
            }
            finally {
                try {
                    if (output != null) {
                        output.close();
                    }
                }
                catch (Exception e) {}
                try {
                    if (input != null) {
                        input.close();
                    }
                }
                catch (Exception e) {}
            }
        }
        try {
            System.load(libFile.toString());
        }
        catch (Exception e) {
            throw (UnsatisfiedLinkError)new UnsatisfiedLinkError("Could not load " + libFile.toString() + " native library !").initCause(e);
        }
        return true;
    }

    public native int initNativeLib();

    public native String[] listUSBHIDdevicesWithInfo(int var1);

    public native long openHidDeviceByUSBAttributes(int var1, int var2, String var3, int var4, int var5, int var6);

    public long openHidDeviceR(String pathNameVal, boolean shared, int osType) {
        if (osType == 4 && "usb_".equals(pathNameVal.substring(0, 4))) {
            String[] attr = pathNameVal.split("_", 5);
            return this.openHidDeviceByUSBAttributes((short)SerialComUtil.hexStrToLongNumber(attr[1]), (short)SerialComUtil.hexStrToLongNumber(attr[2]), attr[3], (int)SerialComUtil.hexStrToLongNumber(attr[4]), -1, -1);
        }
        return this.openHidDeviceByPathR(pathNameVal, shared);
    }

    public native long openHidDeviceByPathR(String var1, boolean var2);

    public native int closeHidDeviceR(long var1);

    public native long createBlockingHIDIOContextR();

    public native int unblockBlockingHIDIOOperationR(long var1);

    public native int destroyBlockingIOContextR(long var1);

    public native int writeOutputReportR(long var1, byte var3, byte[] var4, int var5);

    public native int readInputReportR(long var1, byte[] var3, int var4, long var5);

    public native int readInputReportWithTimeoutR(long var1, byte[] var3, int var4, int var5);

    public native int readPlatformSpecificInputReportR(long var1, byte var3, byte[] var4, int var5);

    public native int writePlatformSpecificOutputReportR(long var1, byte var3, byte[] var4, int var5);

    public native int sendFeatureReportR(long var1, byte var3, byte[] var4, int var5);

    public native int getFeatureReportR(long var1, byte var3, byte[] var4, int var5);

    public native String[] listHIDdevicesWithInfoR();

    public native String getManufacturerStringR(long var1);

    public native String getProductStringR(long var1);

    public native String getSerialNumberStringR(long var1);

    public native String getIndexedStringR(long var1, int var3);

    public native String findDriverServingHIDDeviceR(String var1);

    public native int flushInputReportQueueR(long var1);

    public native byte[] getReportDescriptorR(long var1);

    public native byte[] getPhysicalDescriptorR(long var1);
}

