/*
 * Decompiled with CFR 0.152.
 */
package com.embeddedunveiled.serial.internal;

import com.embeddedunveiled.serial.ISerialComDataListener;
import com.embeddedunveiled.serial.ISerialComEventListener;
import com.embeddedunveiled.serial.SerialComException;
import com.embeddedunveiled.serial.SerialComLineEvent;
import com.embeddedunveiled.serial.internal.SerialComPortJNIBridge;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;

public final class SerialComLooper {
    private final int MAX_NUM_EVENTS = 5000;
    private SerialComPortJNIBridge mComPortJNIBridge;
    private BlockingQueue<byte[]> mDataQueue = null;
    private ISerialComDataListener mDataListener = null;
    private Object mDataLock = new Object();
    private Thread mDataLooperThread = null;
    private AtomicBoolean deliverDataEvent = new AtomicBoolean(true);
    private AtomicBoolean exitDataThread = new AtomicBoolean(false);
    private BlockingQueue<Integer> mDataErrorQueue = null;
    private Object mDataErrorLock = new Object();
    private Thread mDataErrorLooperThread = null;
    private AtomicBoolean exitDataErrorThread = new AtomicBoolean(false);
    private BlockingQueue<SerialComLineEvent> mEventQueue = null;
    private ISerialComEventListener mEventListener = null;
    private Thread mEventLooperThread = null;
    private AtomicBoolean exitEventThread = null;
    private int appliedMask = 15;
    private int oldLineState = 0;
    private int newLineState = 0;

    public SerialComLooper(SerialComPortJNIBridge mComPortJNIBridge) {
        this.mComPortJNIBridge = mComPortJNIBridge;
    }

    public void insertInDataQueue(byte[] newData) {
        try {
            if (this.mDataQueue.remainingCapacity() == 0) {
                this.mDataQueue.poll();
            }
            this.mDataQueue.offer(newData);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void insertInDataErrorQueue(int errorNum) {
        if (this.mDataErrorQueue.remainingCapacity() == 0) {
            this.mDataErrorQueue.poll();
        }
        try {
            this.mDataErrorQueue.offer(errorNum);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void insertInEventQueue(int newEvent) {
        this.newLineState = newEvent & this.appliedMask;
        if (this.mEventQueue.remainingCapacity() == 0) {
            this.mEventQueue.poll();
        }
        try {
            this.mEventQueue.offer(new SerialComLineEvent(this.oldLineState, this.newLineState));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.oldLineState = this.newLineState;
    }

    public void startDataLooper(long handle, ISerialComDataListener dataListener, String portName) {
        this.mDataListener = dataListener;
        this.mDataQueue = new ArrayBlockingQueue<byte[]>(5000);
        this.mDataErrorQueue = new ArrayBlockingQueue<Integer>(5000);
        this.mDataLooperThread = new Thread((Runnable)new DataLooper(), "SCM DataLooper for handle " + handle + " and port " + portName);
        this.mDataErrorLooperThread = new Thread((Runnable)new DataErrorLooper(), "SCM DataErrorLooper for handle " + handle + " and port " + portName);
        this.mDataLooperThread.start();
        this.mDataErrorLooperThread.start();
    }

    public void stopDataLooper() {
        this.exitDataThread.set(true);
        this.exitDataErrorThread.set(true);
        this.mDataLooperThread.interrupt();
        this.mDataErrorLooperThread.interrupt();
    }

    public void startEventLooper(long handle, ISerialComEventListener eventListener, String portName) throws SerialComException {
        int state = 0;
        int[] linestate = null;
        linestate = this.mComPortJNIBridge.getLinesStatus(handle);
        if (linestate == null) {
            throw new SerialComException("Could not read current state of lines. Please retry !");
        }
        state = linestate[0] | linestate[1] | linestate[2] | linestate[3];
        this.oldLineState = state & this.appliedMask;
        this.mEventQueue = new ArrayBlockingQueue<SerialComLineEvent>(5000);
        this.exitEventThread = new AtomicBoolean(false);
        this.mEventListener = eventListener;
        this.mEventLooperThread = new Thread((Runnable)new EventLooper(), "SCM EventLooper for handle " + handle + " and port " + portName);
        this.mEventLooperThread.start();
    }

    public void stopEventLooper() throws SerialComException {
        this.exitEventThread.set(true);
        this.mEventLooperThread.interrupt();
    }

    public void pause() {
        this.deliverDataEvent.set(false);
    }

    public void resume() {
        this.deliverDataEvent.set(true);
        this.mDataLock.notify();
        this.mDataErrorLock.notify();
    }

    public void setEventsMask(int newMask) {
        this.appliedMask = newMask;
    }

    public int getEventsMask() {
        return this.appliedMask;
    }

    class EventLooper
    implements Runnable {
        EventLooper() {
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        SerialComLooper.this.mEventListener.onNewSerialEvent((SerialComLineEvent)SerialComLooper.this.mEventQueue.take());
                    }
                }
                catch (InterruptedException e) {
                    if (!SerialComLooper.this.exitEventThread.get()) continue;
                    SerialComLooper.this.exitEventThread.set(false);
                    SerialComLooper.this.mEventQueue = null;
                    return;
                }
                break;
            }
        }
    }

    class DataErrorLooper
    implements Runnable {
        DataErrorLooper() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                Object object = SerialComLooper.this.mDataErrorLock;
                synchronized (object) {
                    block6: {
                        try {
                            SerialComLooper.this.mDataListener.onDataListenerError((Integer)SerialComLooper.this.mDataErrorQueue.take());
                            if (SerialComLooper.this.deliverDataEvent.get()) break block6;
                            SerialComLooper.this.mDataErrorLock.wait();
                        }
                        catch (InterruptedException e) {
                            if (!SerialComLooper.this.exitDataErrorThread.get()) break block6;
                            break;
                        }
                    }
                }
            }
            SerialComLooper.this.exitDataErrorThread.set(false);
            SerialComLooper.this.mDataErrorQueue = null;
        }
    }

    class DataLooper
    implements Runnable {
        DataLooper() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                Object object = SerialComLooper.this.mDataLock;
                synchronized (object) {
                    block6: {
                        try {
                            SerialComLooper.this.mDataListener.onNewSerialDataAvailable((byte[])SerialComLooper.this.mDataQueue.take());
                            if (SerialComLooper.this.deliverDataEvent.get()) break block6;
                            SerialComLooper.this.mDataLock.wait();
                        }
                        catch (InterruptedException e) {
                            if (!SerialComLooper.this.exitDataThread.get()) break block6;
                            break;
                        }
                    }
                }
            }
            SerialComLooper.this.exitDataThread.set(false);
            SerialComLooper.this.mDataQueue = null;
        }
    }
}

