/*
 * Decompiled with CFR 0.152.
 */
package com.embeddedunveiled.serial.internal;

import com.embeddedunveiled.serial.SerialComLoadException;
import com.embeddedunveiled.serial.SerialComUnexpectedException;
import com.embeddedunveiled.serial.internal.SerialComPortJNIBridge;
import com.embeddedunveiled.serial.internal.SerialComSystemProperty;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;

public final class SerialComMCHPSIOJNIBridge {
    public static boolean loadNativeLibrary(File libDirectory, String vlibName, int cpuArch, int osType, SerialComSystemProperty serialComSystemProperty) throws SerialComUnexpectedException, SerialComLoadException {
        String fileSeparator;
        File libFile;
        block36: {
            String libToExtractFromJar = null;
            libFile = null;
            InputStream input = null;
            FileOutputStream output = null;
            fileSeparator = null;
            fileSeparator = serialComSystemProperty.getfileSeparator();
            if (fileSeparator == null) {
                throw new SerialComUnexpectedException("The file.separator java system property is null in the system !");
            }
            if (cpuArch == 2) {
                switch (osType) {
                    case 2: {
                        libToExtractFromJar = "win_mchpsio_1.0.4_x86_64.dll";
                        break;
                    }
                    case 1: {
                        libToExtractFromJar = "linux_mchpsio_1.0.4_x86_64.so";
                        break;
                    }
                    case 4: {
                        libToExtractFromJar = "mac_mchpsio_1.0.4_x86_64.dylib";
                    }
                }
            } else if (cpuArch == 1) {
                switch (osType) {
                    case 2: {
                        libToExtractFromJar = "win_mchpsio_1.0.4_x86.dll";
                        break;
                    }
                    case 1: {
                        libToExtractFromJar = "linux_mchpsio_1.0.4_x86.so";
                        break;
                    }
                    case 4: {
                        libToExtractFromJar = "mac_mchpsio_1.0.4_x86.dylib";
                    }
                }
            }
            try {
                libFile = new File(libDirectory.getAbsolutePath() + fileSeparator + libToExtractFromJar);
                input = SerialComPortJNIBridge.class.getResourceAsStream("/lib-vendor/" + libToExtractFromJar);
                output = new FileOutputStream(libFile);
                if (input != null) {
                    int read;
                    byte[] buffer = new byte[4096];
                    while ((read = input.read(buffer)) != -1) {
                        output.write(buffer, 0, read);
                    }
                    output.flush();
                    output.close();
                    output = null;
                    if (libFile == null || !libFile.exists() || !libFile.isFile()) {
                        throw new SerialComLoadException("Can not extract native shared library from scm-x.x.x.jar file !");
                    }
                    break block36;
                }
                throw new SerialComLoadException("Can not get shared library resource as stream from scm-x.x.x.jar file using class loader !");
            }
            catch (Exception e) {
                throw (SerialComLoadException)new SerialComLoadException(libFile.toString()).initCause(e);
            }
            finally {
                try {
                    if (output != null) {
                        output.close();
                    }
                }
                catch (Exception e) {}
                try {
                    if (input != null) {
                        input.close();
                    }
                }
                catch (Exception e) {}
            }
        }
        try {
            System.load(libFile.toString());
        }
        catch (Exception e) {
            throw (UnsatisfiedLinkError)new UnsatisfiedLinkError("Could not load " + libFile.toString() + " native library !").initCause(e);
        }
        try {
            SerialComMCHPSIOJNIBridge.loadAndLinkSimpleIODLL(libDirectory.getAbsolutePath() + fileSeparator + vlibName);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new UnsatisfiedLinkError("Could not load/link " + vlibName + " native library !");
        }
        return true;
    }

    private static native int loadAndLinkSimpleIODLL(String var0);

    public native int initMCP2200(int var1, int var2);

    public native int isConnected();

    public native int configureMCP2200(byte var1, long var2, int var4, int var5, boolean var6, boolean var7, boolean var8, boolean var9);

    public native int setPin(int var1);

    public native int clearPin(int var1);

    public native int readPinValue(int var1);

    public native int readPin(int var1);

    public native int writePort(int var1);

    public native int readPort();

    public native int readPortValue();

    public native int selectDevice(int var1);

    public native int getSelectedDevice();

    public native int getNumOfDevices();

    public native String getDeviceInfo(int var1);

    public native String getSelectedDeviceInfo();

    public native int readEEPROM(int var1);

    public native int writeEEPROM(int var1, short var2);

    public native int fnRxLED(int var1);

    public native int fnTxLED(int var1);

    public native int hardwareFlowControl(int var1);

    public native int fnULoad(int var1);

    public native int fnSuspend(int var1);

    public native int fnInvertUartPol(int var1);

    public native int fnSetBaudRate(long var1);

    public native int configureIO(short var1);

    public native int configureIoDefaultOutput(short var1, short var2);
}

