/*
 * Decompiled with CFR 0.152.
 */
package com.embeddedunveiled.serial.internal;

import com.embeddedunveiled.serial.SerialComUnexpectedException;
import com.embeddedunveiled.serial.internal.SerialComSystemProperty;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Locale;

public final class SerialComPlatform {
    SerialComSystemProperty mSerialComSystemProperty = null;

    public SerialComPlatform(SerialComSystemProperty mSerialComSystemProperty) {
        this.mSerialComSystemProperty = mSerialComSystemProperty;
    }

    public final int getOSType() throws SecurityException, SerialComUnexpectedException {
        int osType = 0;
        String osName = this.mSerialComSystemProperty.getOSName();
        if (osName == null) {
            throw new SerialComUnexpectedException("The os.name java system property is null in the system !");
        }
        if (osName.contains("windows")) {
            osType = 2;
        } else if (osName.contains("linux")) {
            osType = this.isAndroid() ? 10 : 1;
        } else if (osName.contains("mac os") || osName.contains("macos") || osName.contains("darwin")) {
            osType = 4;
        } else if (osName.contains("solaris") || osName.contains("sunos")) {
            osType = 3;
        } else if (osName.contains("freebsd") || osName.contains("free bsd")) {
            osType = 5;
        } else if (osName.contains("netbsd")) {
            osType = 6;
        } else if (osName.contains("openbsd")) {
            osType = 7;
        } else if (osName.contains("aix")) {
            osType = 8;
        } else if (osName.contains("hp-ux")) {
            osType = 9;
        }
        return osType;
    }

    public final int getCPUArch(int osType) throws SecurityException, SerialComUnexpectedException, FileNotFoundException, IOException {
        int cpuArch = 0;
        BufferedReader cpuProperties = null;
        String line = null;
        String property = null;
        String osArch = this.mSerialComSystemProperty.getOSArch();
        if (osArch == null) {
            throw new SerialComUnexpectedException("The os.arch java system property is null in the system !");
        }
        if (osArch.startsWith("arm")) {
            if (osType == 1) {
                cpuProperties = new BufferedReader(new FileReader("/proc/cpuinfo"));
                while ((line = cpuProperties.readLine()) != null) {
                    property = line.toLowerCase(Locale.ENGLISH);
                    if (property.contains("armv7")) {
                        cpuArch = 15;
                        break;
                    }
                    if (property.contains("armv6")) {
                        cpuArch = 14;
                        break;
                    }
                    if (!property.contains("armv5")) continue;
                    cpuArch = 13;
                    break;
                }
                cpuProperties.close();
            }
        } else if (osArch.equals("x86") || osArch.equals("i386") || osArch.equals("i486") || osArch.equals("i586") || osArch.equals("i686") || osArch.equals("i786") || osArch.equals("i886") || osArch.equals("i986") || osArch.equals("pentium") || osArch.equals("i86pc")) {
            cpuArch = 1;
        } else if (osArch.equals("amd64") || osArch.equals("x86_64") || osArch.equals("em64t") || osArch.equals("x86-64") || osArch.equals("universal")) {
            cpuArch = 2;
        } else if (osArch.equals("ia64") || osArch.equals("ia64w")) {
            cpuArch = 3;
        } else if (osArch.equals("ia64_32") || osArch.equals("ia64n")) {
            cpuArch = 4;
        } else if (osArch.equals("ppc") || osArch.equals("power") || osArch.equals("powerpc") || osArch.equals("power_pc") || osArch.equals("power_rs")) {
            cpuArch = 5;
        } else if (osArch.equals("ppc64") || osArch.equals("power64") || osArch.equals("powerpc64") || osArch.equals("power_pc64") || osArch.equals("power_rs64")) {
            cpuArch = 6;
        } else if (osArch.equals("powerpc64le")) {
            cpuArch = 6;
        } else if (osArch.equals("sparc")) {
            cpuArch = 7;
        } else if (osArch.equals("sparcv9")) {
            cpuArch = 8;
        } else if (osArch.equals("pa-risc") || osArch.equals("pa-risc2.0")) {
            cpuArch = 9;
        } else if (osArch.equals("pa-risc2.0w")) {
            cpuArch = 10;
        } else if (osArch.equals("s390")) {
            cpuArch = 11;
        } else if (osArch.equals("s390x")) {
            cpuArch = 12;
        }
        return cpuArch;
    }

    private boolean isAndroid() throws SerialComUnexpectedException {
        String osVendor = this.mSerialComSystemProperty.getJavaVmVendor();
        if (osVendor == null) {
            throw new SerialComUnexpectedException("The java.vm.vendor java system property is null in the system !");
        }
        return osVendor.contains("android");
    }

    public final int getJAVAABIType() throws SerialComUnexpectedException {
        int abiType = 2;
        String javaHome = this.mSerialComSystemProperty.getJavaHome();
        if (javaHome == null) {
            throw new SerialComUnexpectedException("The java.home java system property is null in the system !");
        }
        try {
            String[] cmdarray = new String[]{"/bin/sh", "-c", "find '" + javaHome + "' -name 'libjvm.so' | head -1 | xargs readelf -A | " + "grep 'Tag_ABI_VFP_args: VFP registers'"};
            int exitValueOfSubProcess = Runtime.getRuntime().exec(cmdarray).waitFor();
            if (exitValueOfSubProcess == 0) {
                abiType = 1;
            }
        }
        catch (IOException e) {
            return 2;
        }
        catch (InterruptedException e) {
            return 2;
        }
        return abiType;
    }
}

