/*
 * Decompiled with CFR 0.152.
 */
package com.embeddedunveiled.serial.internal;

import com.embeddedunveiled.serial.ISerialComUSBHotPlugListener;
import com.embeddedunveiled.serial.SerialComLoadException;
import com.embeddedunveiled.serial.SerialComUnexpectedException;
import com.embeddedunveiled.serial.internal.SerialComLooper;
import com.embeddedunveiled.serial.internal.SerialComSystemProperty;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

public final class SerialComPortJNIBridge {
    private static final Comparator<String> comparator = new Comparator<String>(){

        @Override
        public int compare(String valueA, String valueB) {
            int bl;
            if (valueA.equalsIgnoreCase(valueB)) {
                return valueA.compareTo(valueB);
            }
            int al = valueA.length();
            int minLength = al <= (bl = valueB.length()) ? al : bl;
            int shiftA = 0;
            int shiftB = 0;
            for (int i = 0; i < minLength; ++i) {
                char charB;
                char charA = valueA.charAt(i - shiftA);
                if (charA == (charB = valueB.charAt(i - shiftB))) continue;
                if (Character.isDigit(charA) && Character.isDigit(charB)) {
                    int[] resultsA = new int[]{-1, i - shiftA};
                    String numVal = "";
                    for (int x = i - shiftA; x < al; ++x) {
                        resultsA[1] = x;
                        char c = valueA.charAt(x);
                        if (!Character.isDigit(c)) break;
                        numVal = numVal + c;
                    }
                    try {
                        resultsA[0] = Integer.valueOf(numVal);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    int[] resultsB = new int[]{-1, i - shiftB};
                    numVal = "";
                    for (int x = i - shiftB; x < bl; ++x) {
                        resultsB[1] = x;
                        char c = valueB.charAt(x);
                        if (!Character.isDigit(c)) break;
                        numVal = numVal + c;
                    }
                    try {
                        resultsB[0] = Integer.valueOf(numVal);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    if (resultsA[0] != resultsB[0]) {
                        return resultsA[0] - resultsB[0];
                    }
                    if (al < bl) {
                        i = resultsA[1];
                        shiftB = resultsA[1] - resultsB[1];
                        continue;
                    }
                    i = resultsB[1];
                    shiftA = resultsB[1] - resultsA[1];
                    continue;
                }
                if (Character.toLowerCase(charA) - Character.toLowerCase(charB) == 0) continue;
                return Character.toLowerCase(charA) - Character.toLowerCase(charB);
            }
            return valueA.compareToIgnoreCase(valueB);
        }
    };

    public static boolean loadNativeLibrary(String directoryPath, String loadedLibName, SerialComSystemProperty serialComSystemProperty, int osType, int cpuArch, int javaABIType) throws SerialComUnexpectedException, SerialComLoadException {
        File libFile;
        block62: {
            String javaTmpDir = null;
            String userHomeDir = null;
            String fileSeparator = null;
            File baseDir = null;
            File workingDir = null;
            boolean isTmpDir = false;
            boolean isUserHomeDir = false;
            String libToExtractFromJar = null;
            libFile = null;
            String libExtension = null;
            InputStream input = null;
            FileOutputStream output = null;
            fileSeparator = serialComSystemProperty.getfileSeparator();
            if (fileSeparator == null) {
                throw new SerialComUnexpectedException("The file.separator java system property is null in the system !");
            }
            if (directoryPath == null) {
                javaTmpDir = serialComSystemProperty.getJavaIOTmpDir();
                if (javaTmpDir == null) {
                    throw new SerialComUnexpectedException("The java.io.tmpdir java system property is null in the system !");
                }
                baseDir = new File(javaTmpDir);
                if (baseDir.exists() && baseDir.isDirectory() && baseDir.canWrite()) {
                    isTmpDir = true;
                } else {
                    userHomeDir = serialComSystemProperty.getUserHome();
                    if (userHomeDir == null) {
                        throw new SerialComUnexpectedException("The user.home java system property is null in the system !");
                    }
                    baseDir = new File(userHomeDir);
                    if (!baseDir.exists()) {
                        throw new SerialComLoadException("User home directory does not exist. Also unable to access tmp/temp directory !");
                    }
                    if (!baseDir.isDirectory()) {
                        throw new SerialComLoadException("User home directory is not a directory. Also unable to access tmp/temp directory !");
                    }
                    if (!baseDir.canWrite()) {
                        throw new SerialComLoadException("User home directory is not writeable (permissions ??). Also unable to access tmp/temp directory !");
                    }
                    isUserHomeDir = true;
                }
                workingDir = new File(baseDir.toString() + fileSeparator + "scm_tuartx1");
                if (!workingDir.exists() && !workingDir.mkdir()) {
                    if (isTmpDir) {
                        throw new SerialComLoadException("Can not create scm_tuartx1 unique directory in temp directory !");
                    }
                    if (isUserHomeDir) {
                        throw new SerialComLoadException("Can not create scm_tuartx1 unique directory in user home directory !");
                    }
                }
            } else {
                baseDir = new File(directoryPath);
                if (!baseDir.exists()) {
                    throw new SerialComLoadException("Given " + directoryPath + " directory does not exist !");
                }
                if (!baseDir.isDirectory()) {
                    throw new SerialComLoadException("Given " + directoryPath + " is not a directory !");
                }
                if (!baseDir.canWrite()) {
                    throw new SerialComLoadException("Given " + directoryPath + " directory is not writeable !");
                }
                workingDir = baseDir;
            }
            if (cpuArch == 2) {
                switch (osType) {
                    case 2: {
                        libToExtractFromJar = "windows_1.0.4_x86_64.dll";
                        libExtension = ".dll";
                        break;
                    }
                    case 1: {
                        libToExtractFromJar = "linux_1.0.4_x86_64.so";
                        libExtension = ".so";
                        break;
                    }
                    case 4: {
                        libToExtractFromJar = "mac_1.0.4_x86_64.dylib";
                        libExtension = ".dylib";
                        break;
                    }
                }
            } else if (cpuArch == 1) {
                switch (osType) {
                    case 2: {
                        libToExtractFromJar = "windows_1.0.4_x86.dll";
                        libExtension = ".dll";
                        break;
                    }
                    case 1: {
                        libToExtractFromJar = "linux_1.0.4_x86.so";
                        libExtension = ".so";
                        break;
                    }
                    case 4: {
                        libToExtractFromJar = "mac_1.0.4_x86.dylib";
                        libExtension = ".dylib";
                        break;
                    }
                }
            } else if (cpuArch == 15) {
                if (osType == 1) {
                    libExtension = ".so";
                    if (javaABIType == 1) {
                        libToExtractFromJar = "linux_1.0.4_armv7hf.so";
                    } else if (javaABIType == 2) {
                        libToExtractFromJar = "linux_1.0.4_armv7el.so";
                    }
                }
            } else if (cpuArch == 14) {
                if (osType == 1) {
                    libExtension = ".so";
                    if (javaABIType == 1) {
                        libToExtractFromJar = "linux_1.0.4_armv6hf.so";
                    } else if (javaABIType == 2) {
                        libToExtractFromJar = "linux_1.0.4_armv6el.so";
                    }
                }
            } else {
                throw new SerialComLoadException("This architecture is unknown to this library. Please contact us !");
            }
            try {
                libFile = loadedLibName == null ? new File(workingDir.getAbsolutePath() + fileSeparator + libToExtractFromJar) : new File(workingDir.getAbsolutePath() + fileSeparator + loadedLibName.trim() + libExtension);
                input = SerialComPortJNIBridge.class.getResourceAsStream("/lib-tty/" + libToExtractFromJar);
                output = new FileOutputStream(libFile);
                if (input != null) {
                    int read;
                    byte[] buffer = new byte[4096];
                    while ((read = input.read(buffer)) != -1) {
                        output.write(buffer, 0, read);
                    }
                    output.flush();
                    output.close();
                    output = null;
                    if (libFile != null && libFile.exists() && libFile.isFile()) {
                        break block62;
                    }
                    throw new SerialComLoadException("Can not extract native shared library " + libToExtractFromJar + " from scm-x.x.x.jar file !");
                }
                throw new SerialComLoadException("Can not get shared library " + libToExtractFromJar + " resource as stream from scm-x.x.x.jar file using class loader !");
            }
            catch (Exception e) {
                throw (SerialComLoadException)new SerialComLoadException(libFile.toString()).initCause(e);
            }
            finally {
                try {
                    if (output != null) {
                        output.close();
                    }
                }
                catch (Exception e) {}
                try {
                    if (input != null) {
                        input.close();
                    }
                }
                catch (Exception e) {}
            }
        }
        try {
            System.load(libFile.toString());
        }
        catch (Exception e) {
            throw (UnsatisfiedLinkError)new UnsatisfiedLinkError("Could not load " + libFile.toString() + " native library !").initCause(e);
        }
        return true;
    }

    public native int initNativeLib();

    public native String getNativeLibraryVersion();

    public native String[] listAvailableComPorts();

    public native int setUpDataLooperThread(long var1, SerialComLooper var3);

    public native int setUpEventLooperThread(long var1, SerialComLooper var3);

    public native int destroyDataLooperThread(long var1);

    public native int destroyEventLooperThread(long var1);

    public native int pauseListeningEvents(long var1);

    public native int resumeListeningEvents(long var1);

    public native long openComPort(String var1, boolean var2, boolean var3, boolean var4);

    public native int closeComPort(long var1);

    public native byte[] readBytes(long var1, int var3);

    public native int readBytesP(long var1, byte[] var3, int var4, int var5, long var6);

    public native byte[] readBytesBlocking(long var1, int var3, long var4);

    public native int readBytesDirect(long var1, ByteBuffer var3, int var4, int var5);

    public native int writeBytes(long var1, byte[] var3, int var4);

    public native int writeBytesDirect(long var1, ByteBuffer var3, int var4, int var5);

    public native int writeSingleByte(long var1, byte var3);

    public native long createBlockingIOContext();

    public native int unblockBlockingIOOperation(long var1);

    public native int destroyBlockingIOContext(long var1);

    public native int setRTS(long var1, boolean var3);

    public native int setDTR(long var1, boolean var3);

    public native int[] getLinesStatus(long var1);

    public native int[] getInterruptCount(long var1);

    public native String findDriverServingComPort(String var1);

    public native String findIRQnumberForComPort(long var1);

    public native int sendBreak(long var1, int var3);

    public native int[] getByteCount(long var1);

    public native int clearPortIOBuffers(long var1, boolean var3, boolean var4);

    public native int registerUSBHotPlugEventListener(ISerialComUSBHotPlugListener var1, int var2, int var3, String var4);

    public native int unregisterUSBHotPlugEventListener(int var1);

    public native int configureComPortData(long var1, int var3, int var4, int var5, int var6, int var7);

    public native int configureComPortControl(long var1, int var3, byte var4, byte var5, boolean var6, boolean var7);

    public native int[] getCurrentConfigurationU(long var1);

    public native String[] getCurrentConfigurationW(long var1);

    public native int fineTuneRead(long var1, int var3, int var4, int var5, int var6, int var7);

    public native long ioctlExecuteOperation(long var1, long var3);

    public native long ioctlSetValue(long var1, long var3, long var5);

    public native long ioctlGetValue(long var1, long var3);

    public native long ioctlSetValueIntArray(long var1, long var3, int[] var5);

    public native long ioctlSetValueCharArray(long var1, long var3, byte[] var5);

    public native String[] listUSBdevicesWithInfo(int var1);

    public native int isUSBDevConnected(int var1, int var2, String var3);

    public native String[] getCDCUSBDevPowerInfo(String var1);

    public native int setLatencyTimer(String var1, byte var2);

    public native int getLatencyTimer(String var1);

    public native int rescanUSBDevicesHW();

    public native String[] getFirmwareRevisionNumber(int var1, int var2, String var3);

    public native String[] findComPortFromUSBAttributes(int var1, int var2, String var3);

    public String[] findComPortFromUSBAttribute(int usbVidToMatch, int usbPidToMatch, String serialNumber) {
        String[] ports = this.findComPortFromUSBAttributes(usbVidToMatch, usbPidToMatch, serialNumber);
        if (ports != null) {
            if (ports.length < 2) {
                return ports;
            }
            ArrayList<String> portsFound = new ArrayList<String>();
            for (String portName : ports) {
                portsFound.add(portName);
            }
            Collections.sort(portsFound, comparator);
            return portsFound.toArray(new String[portsFound.size()]);
        }
        return null;
    }

    public native String[] listBTSPPDevNodesWithInfo();
}

