/*
 * Decompiled with CFR 0.152.
 */
package com.embeddedunveiled.serial.internal;

import com.embeddedunveiled.serial.internal.SerialComPortJNIBridge;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.TreeSet;
import java.util.regex.Pattern;

public final class SerialComPortsList {
    private int osType = -1;
    private SerialComPortJNIBridge mComPortJNIBridge = null;
    private static final Pattern Sol_regExpPattern = Pattern.compile("[0-9]*|[a-z]*");
    private static final String Sol_search_path = "/dev/term/";
    private static final Comparator<String> comparator = new Comparator<String>(){

        @Override
        public int compare(String valueA, String valueB) {
            int bl;
            if (valueA.equalsIgnoreCase(valueB)) {
                return valueA.compareTo(valueB);
            }
            int al = valueA.length();
            int minLength = al <= (bl = valueB.length()) ? al : bl;
            int shiftA = 0;
            int shiftB = 0;
            for (int i = 0; i < minLength; ++i) {
                char charB;
                char charA = valueA.charAt(i - shiftA);
                if (charA == (charB = valueB.charAt(i - shiftB))) continue;
                if (Character.isDigit(charA) && Character.isDigit(charB)) {
                    int[] resultsA = new int[]{-1, i - shiftA};
                    String numVal = "";
                    for (int x = i - shiftA; x < al; ++x) {
                        resultsA[1] = x;
                        char c = valueA.charAt(x);
                        if (!Character.isDigit(c)) break;
                        numVal = numVal + c;
                    }
                    try {
                        resultsA[0] = Integer.valueOf(numVal);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    int[] resultsB = new int[]{-1, i - shiftB};
                    numVal = "";
                    for (int x = i - shiftB; x < bl; ++x) {
                        resultsB[1] = x;
                        char c = valueB.charAt(x);
                        if (!Character.isDigit(c)) break;
                        numVal = numVal + c;
                    }
                    try {
                        resultsB[0] = Integer.valueOf(numVal);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    if (resultsA[0] != resultsB[0]) {
                        return resultsA[0] - resultsB[0];
                    }
                    if (al < bl) {
                        i = resultsA[1];
                        shiftB = resultsA[1] - resultsB[1];
                        continue;
                    }
                    i = resultsB[1];
                    shiftA = resultsB[1] - resultsA[1];
                    continue;
                }
                if (Character.toLowerCase(charA) - Character.toLowerCase(charB) == 0) continue;
                return Character.toLowerCase(charA) - Character.toLowerCase(charB);
            }
            return valueA.compareToIgnoreCase(valueB);
        }
    };

    public SerialComPortsList(SerialComPortJNIBridge mComPortJNIBridge, int osType) {
        this.mComPortJNIBridge = mComPortJNIBridge;
        this.osType = osType;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String[] listAvailableComPorts() {
        if (this.osType != 3) {
            ArrayList<String> portsIdentified = new ArrayList<String>();
            String[] ports = this.mComPortJNIBridge.listAvailableComPorts();
            if (ports == null) return null;
            for (String portName : ports) {
                portsIdentified.add(portName);
            }
            Collections.sort(portsIdentified, comparator);
            return portsIdentified.toArray(new String[portsIdentified.size()]);
        }
        String[] portsIdentified = new String[]{};
        File dir = new File(Sol_search_path);
        if (!dir.exists()) return null;
        if (!dir.isDirectory()) return null;
        File[] nodes = dir.listFiles();
        if (nodes.length <= 0) return null;
        TreeSet<String> portsTree = new TreeSet<String>(comparator);
        File[] arr$ = nodes;
        int len$ = arr$.length;
        int i$ = 0;
        while (i$ < len$) {
            File file = arr$[i$];
            String fileName = file.getName();
            if (!file.isDirectory() && !file.isFile() && Sol_regExpPattern.matcher(fileName).find()) {
                portsTree.add(Sol_search_path + fileName);
            }
            ++i$;
        }
        return portsTree.toArray(portsIdentified);
    }
}

