/*
 * Decompiled with CFR 0.152.
 */
package com.embeddedunveiled.serial.internal;

import com.embeddedunveiled.serial.SerialComLoadException;
import com.embeddedunveiled.serial.SerialComUnexpectedException;
import com.embeddedunveiled.serial.internal.SerialComPortJNIBridge;
import com.embeddedunveiled.serial.internal.SerialComSystemProperty;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;

public final class SerialComSLabsUSBXpressJNIBridge {
    public static boolean loadNativeLibrary(File libDirectory, String vlibName, int cpuArch, int osType, SerialComSystemProperty serialComSystemProperty) throws SerialComUnexpectedException, SerialComLoadException {
        String fileSeparator;
        File vlibFile;
        File libFile;
        block36: {
            String libToExtractFromJar = null;
            libFile = null;
            vlibFile = null;
            InputStream input = null;
            FileOutputStream output = null;
            fileSeparator = null;
            fileSeparator = serialComSystemProperty.getfileSeparator();
            if (fileSeparator == null) {
                throw new SerialComUnexpectedException("The file.separator java system property is null in the system !");
            }
            if (cpuArch == 2) {
                switch (osType) {
                    case 2: {
                        libToExtractFromJar = "win_usbxp_1.0.4_x86_64.dll";
                        break;
                    }
                    case 1: {
                        libToExtractFromJar = "linux_usbxp_1.0.4_x86_64.so";
                        break;
                    }
                    case 4: {
                        libToExtractFromJar = "mac_usbxp_1.0.4_x86_64.dylib";
                    }
                }
            } else if (cpuArch == 1) {
                switch (osType) {
                    case 2: {
                        libToExtractFromJar = "win_usbxp_1.0.4_x86.dll";
                        break;
                    }
                    case 1: {
                        libToExtractFromJar = "linux_usbxp_1.0.4_x86.so";
                        break;
                    }
                    case 4: {
                        libToExtractFromJar = "mac_usbxp_1.0.4_x86.dylib";
                    }
                }
            }
            try {
                libFile = new File(libDirectory.getAbsolutePath() + fileSeparator + libToExtractFromJar);
                input = SerialComPortJNIBridge.class.getResourceAsStream("/lib-vendor/" + libToExtractFromJar);
                output = new FileOutputStream(libFile);
                if (input != null) {
                    int read;
                    byte[] buffer = new byte[4096];
                    while ((read = input.read(buffer)) != -1) {
                        output.write(buffer, 0, read);
                    }
                    output.flush();
                    output.close();
                    output = null;
                    if (libFile == null || !libFile.exists() || !libFile.isFile()) {
                        throw new SerialComLoadException("Can not extract native shared library from scm-x.x.x.jar file !");
                    }
                    break block36;
                }
                throw new SerialComLoadException("Can not get shared library resource as stream from scm-x.x.x.jar file using class loader !");
            }
            catch (Exception e) {
                throw (SerialComLoadException)new SerialComLoadException(libFile.toString()).initCause(e);
            }
            finally {
                try {
                    if (output != null) {
                        output.close();
                    }
                }
                catch (Exception e) {}
                try {
                    if (input != null) {
                        input.close();
                    }
                }
                catch (Exception e) {}
            }
        }
        try {
            vlibFile = new File(libDirectory.getAbsolutePath() + fileSeparator + vlibName);
            System.load(vlibFile.toString());
        }
        catch (Exception e) {
            throw (UnsatisfiedLinkError)new UnsatisfiedLinkError("Could not load " + vlibFile.toString() + " native library !").initCause(e);
        }
        try {
            System.load(libFile.toString());
        }
        catch (Exception e) {
            throw (UnsatisfiedLinkError)new UnsatisfiedLinkError("Could not load " + libFile.toString() + " native library !").initCause(e);
        }
        return true;
    }

    public native int getNumDevices();

    public native String getProductString(int var1, int var2);

    public native long open(int var1);

    public native int close(long var1);

    public native int read(long var1, byte[] var3, int var4);

    public native int write(long var1, byte[] var3, int var4);

    public native int cancelIO(long var1);

    public native int flushBuffer(long var1, byte var3, byte var4);

    public native int setTimeouts(long var1, long var3);

    public native long[] getTimeouts();

    public native long[] checkRXQueue(long var1);

    public native int setBaudRate(long var1, int var3);

    public native int setLineControl(long var1, int var3);

    public native int setFlowControl(long var1, int var3, int var4, int var5, int var6, int var7, int var8);

    public native int getModemStatus(long var1);

    public native int setBreak(long var1, int var3);

    public native long readLatch(long var1);

    public native int writeLatch(long var1, long var3, long var5);

    public native String getPartNumber(long var1);

    public native long getDllVersion();

    public native long getDriverVersion();

    public native int deviceIOControl(long var1, int var3, byte[] var4, int var5, byte[] var6, int var7);
}

