/*
 * Decompiled with CFR 0.152.
 */
package com.embeddedunveiled.serial.internal;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Locale;

public final class SerialComSystemProperty {
    SecurityManager securityManager = System.getSecurityManager();

    public String getOSName() throws SecurityException {
        if (this.securityManager == null) {
            return System.getProperty("os.name").toLowerCase(Locale.ENGLISH).trim();
        }
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty("os.name").toLowerCase(Locale.ENGLISH).trim();
            }
        });
    }

    public String getOSArch() throws SecurityException {
        if (this.securityManager == null) {
            return System.getProperty("os.arch").toLowerCase(Locale.ENGLISH).trim();
        }
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty("os.arch").toLowerCase(Locale.ENGLISH).trim();
            }
        });
    }

    public String getJavaVmVendor() throws SecurityException {
        if (this.securityManager == null) {
            return System.getProperty("java.vm.vendor").toLowerCase(Locale.ENGLISH).trim();
        }
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty("java.vm.vendor").toLowerCase(Locale.ENGLISH).trim();
            }
        });
    }

    public String getJavaHome() throws SecurityException {
        if (this.securityManager == null) {
            return System.getProperty("java.home");
        }
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty("java.home");
            }
        });
    }

    public String getJavaIOTmpDir() throws SecurityException {
        if (this.securityManager == null) {
            return System.getProperty("java.io.tmpdir");
        }
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty("java.io.tmpdir");
            }
        });
    }

    public String getUserHome() throws SecurityException {
        if (this.securityManager == null) {
            return System.getProperty("user.home");
        }
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty("user.home");
            }
        });
    }

    public String getfileSeparator() throws SecurityException {
        if (this.securityManager == null) {
            return System.getProperty("file.separator");
        }
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty("file.separator");
            }
        });
    }
}

