/*
 * Decompiled with CFR 0.152.
 */
package com.embeddedunveiled.serial.nullmodem;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Map;
import java.util.TreeMap;

public final class SerialComNullModem {
    public static final int SCM_CON_NONE = 0;
    public static final int SCM_CON_CTS = 1;
    public static final int SCM_CON_DCD = 2;
    public static final int SCM_CON_DSR = 4;
    public static final int SCM_CON_RI = 8;
    public static final int ERR_FRAME = 16;
    public static final int ERR_PARITY = 32;
    public static final int ERR_OVERRUN = 64;
    private final int osType;
    private FileOutputStream linuxVadaptOut;
    private FileInputStream linuxVadaptIn;
    private final Object lock = new Object();
    private final TreeMap<Integer, String> loopBackDevList;
    private final TreeMap<Integer, String> nullModemDevList;

    public SerialComNullModem(int osType) throws IOException {
        this.osType = osType;
        if (osType == 1) {
            this.linuxVadaptOut = new FileOutputStream(new File("/proc/scmtty_vadaptkm"));
            try {
                this.linuxVadaptIn = new FileInputStream(new File("/proc/scmtty_vadaptkm"));
            }
            catch (IOException e) {
                this.linuxVadaptOut.close();
                throw e;
            }
        }
        this.loopBackDevList = new TreeMap();
        this.nullModemDevList = new TreeMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String createStandardLoopBackDevice(int deviceIndex) throws IOException {
        byte[] cmd = null;
        String lbdev = null;
        if (this.osType == 1) {
            if (deviceIndex == -1) {
                cmd = "genlb#xxxxx#xxxxx#7-8,x,x,x#4-1,6,x,x#x-x,x,x,x#x-x,x,x,x#y#y".getBytes();
            } else {
                if (deviceIndex < 0 || deviceIndex > 65535) {
                    throw new IllegalArgumentException("deviceIndex should be -1 <= deviceIndex =< 65535 !");
                }
                String cmdd = "genlb#".concat(String.format("%05d", deviceIndex));
                cmdd = cmdd.concat("#xxxxx#7-8,x,x,x#4-1,6,x,x#x-x,x,x,x#x-x,x,x,x#y#y");
                cmd = cmdd.getBytes();
            }
            Object object = this.lock;
            synchronized (object) {
                this.linuxVadaptOut.write(cmd);
                lbdev = this.getLastLoopBackDeviceNode();
                if (deviceIndex == -1) {
                    int idx = Integer.parseInt(lbdev.substring(12), 10);
                    this.loopBackDevList.put(idx, lbdev);
                } else {
                    this.loopBackDevList.put(deviceIndex, lbdev);
                }
            }
        }
        return lbdev;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] createStandardNullModemPair(int deviceIndex1, int deviceIndex2) throws IOException {
        byte[] cmd = null;
        String[] nmdevs = null;
        if (this.osType == 1) {
            String cmdd;
            if (deviceIndex1 == -1) {
                if (deviceIndex2 == -1) {
                    cmd = "gennm#xxxxx#xxxxx#7-8,x,x,x#4-1,6,x,x#7-8,x,x,x#4-1,6,x,x#y#y".getBytes();
                } else {
                    if (deviceIndex2 < 0 || deviceIndex2 > 65535) {
                        throw new IllegalArgumentException("deviceIndex2 should be -1 <= deviceIndex2 =< 65535 !");
                    }
                    cmdd = "gennm#xxxxx#".concat(String.format("%05d", deviceIndex2));
                    cmdd = cmdd.concat("#7-8,x,x,x#4-1,6,x,x#7-8,x,x,x#4-1,6,x,x#y#y");
                }
            } else if (deviceIndex2 == -1) {
                cmdd = "gennm#".concat(String.format("%05d", deviceIndex1));
                cmdd = cmdd.concat("#xxxxx#7-8,x,x,x#4-1,6,x,x#7-8,x,x,x#4-1,6,x,x#y#y");
                cmd = cmdd.getBytes();
            } else {
                if (deviceIndex1 < 0 || deviceIndex1 > 65535) {
                    throw new IllegalArgumentException("deviceIndex1 should be -1 <= deviceIndex1 =< 65535 !");
                }
                cmdd = "gennm#".concat(String.format("%05d", deviceIndex1));
                cmdd = cmdd.concat("#");
                cmdd = cmdd.concat(String.format("%05d", deviceIndex2));
                cmdd = cmdd.concat("#7-8,x,x,x#4-1,6,x,x#7-8,x,x,x#4-1,6,x,x#y#y");
                cmd = cmdd.getBytes();
            }
            Object object = this.lock;
            synchronized (object) {
                this.linuxVadaptOut.write(cmd);
                nmdevs = this.getLastNullModemDevicePairNodes();
                int idx = Integer.parseInt(nmdevs[0].substring(12), 10);
                StringBuilder sb = new StringBuilder();
                sb.append(nmdevs[0]);
                sb.append(" <=> ");
                sb.append(nmdevs[1]);
                this.nullModemDevList.put(idx, sb.toString());
            }
        }
        return nmdevs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String createCustomLoopBackDevice(int deviceIndex, int rtsMap, int dtrMap) throws IOException {
        String lbdev = null;
        StringBuilder sb = new StringBuilder();
        if (this.osType == 1) {
            sb.append("genlb#");
            if (deviceIndex < 0) {
                if (deviceIndex != -1) {
                    throw new IllegalArgumentException("Argument deviceIndex should be -1 <= deviceIndex =< 65535 !");
                }
                sb.append("xxxxx#xxxxx#7-");
            } else {
                if (deviceIndex > 65535) {
                    throw new IllegalArgumentException("Argument deviceIndex should be -1 <= deviceIndex =< 65535 !");
                }
                sb.append(String.format("%05d", deviceIndex));
                sb.append("#xxxxx#7-");
            }
            if (rtsMap == 0) {
                sb.append("x,x,x,x#4-");
            } else {
                if ((rtsMap & 1) == 1) {
                    sb.append(8);
                } else {
                    sb.append("x");
                }
                sb.append(",");
                if ((rtsMap & 2) == 2) {
                    sb.append(1);
                } else {
                    sb.append("x");
                }
                sb.append(",");
                if ((rtsMap & 4) == 4) {
                    sb.append(6);
                } else {
                    sb.append("x");
                }
                sb.append(",");
                if ((rtsMap & 8) == 8) {
                    sb.append(9);
                } else {
                    sb.append("x");
                }
                sb.append("#4-");
            }
            if (dtrMap == 0) {
                sb.append("x,x,x,x");
            } else {
                if ((dtrMap & 1) == 1) {
                    sb.append(8);
                } else {
                    sb.append("x");
                }
                sb.append(",");
                if ((dtrMap & 2) == 2) {
                    sb.append(1);
                } else {
                    sb.append("x");
                }
                sb.append(",");
                if ((dtrMap & 4) == 4) {
                    sb.append(6);
                } else {
                    sb.append("x");
                }
                sb.append(",");
                if ((dtrMap & 8) == 8) {
                    sb.append(9);
                } else {
                    sb.append("x");
                }
            }
            sb.append("#x-x,x,x,x#x-x,x,x,x#y#y");
            Object object = this.lock;
            synchronized (object) {
                this.linuxVadaptOut.write(sb.toString().getBytes());
                lbdev = this.getLastLoopBackDeviceNode();
                if (deviceIndex == -1) {
                    int idx = Integer.parseInt(lbdev.substring(12), 10);
                    this.loopBackDevList.put(idx, lbdev);
                } else {
                    this.loopBackDevList.put(deviceIndex, lbdev);
                }
            }
        }
        return lbdev;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] createCustomNullModemPair(int idx1, int rtsMap1, int dtrMap1, int idx2, int rtsMap2, int dtrMap2) throws IOException {
        String[] nmdevs = null;
        StringBuilder sb = new StringBuilder();
        if (this.osType == 1) {
            sb.append("gennm#");
            if (idx1 < 0) {
                if (idx1 != -1) {
                    throw new IllegalArgumentException("Argument idx1 should be -1 <= idx1 =< 65535 !");
                }
                sb.append("xxxxx");
            } else {
                if (idx1 > 65535) {
                    throw new IllegalArgumentException("Argument idx1 should be -1 <= idx1 =< 65535 !");
                }
                sb.append(String.format("%05d", idx1));
            }
            sb.append("#");
            if (idx2 < 0) {
                if (idx2 != -1) {
                    throw new IllegalArgumentException("Argument idx2 should be -1 <= idx2 =< 65535 !");
                }
                sb.append("xxxxx");
            } else {
                if (idx2 > 65535) {
                    throw new IllegalArgumentException("Argument idx2 should be -1 <= idx2 =< 65535 !");
                }
                sb.append(String.format("%05d", idx2));
            }
            sb.append("#7-");
            if (rtsMap1 == 0) {
                sb.append("x,x,x,x#4-");
            } else {
                if ((rtsMap1 & 1) == 1) {
                    sb.append(8);
                } else {
                    sb.append("x");
                }
                sb.append(",");
                if ((rtsMap1 & 2) == 2) {
                    sb.append(1);
                } else {
                    sb.append("x");
                }
                sb.append(",");
                if ((rtsMap1 & 4) == 4) {
                    sb.append(6);
                } else {
                    sb.append("x");
                }
                sb.append(",");
                if ((rtsMap1 & 8) == 8) {
                    sb.append(9);
                } else {
                    sb.append("x");
                }
                sb.append("#4-");
            }
            if (dtrMap1 == 0) {
                sb.append("x,x,x,x#7-");
            } else {
                if ((dtrMap1 & 1) == 1) {
                    sb.append(8);
                } else {
                    sb.append("x");
                }
                sb.append(",");
                if ((dtrMap1 & 2) == 2) {
                    sb.append(1);
                } else {
                    sb.append("x");
                }
                sb.append(",");
                if ((dtrMap1 & 4) == 4) {
                    sb.append(6);
                } else {
                    sb.append("x");
                }
                sb.append(",");
                if ((dtrMap1 & 8) == 8) {
                    sb.append(9);
                } else {
                    sb.append("x");
                }
                sb.append("#7-");
            }
            if (rtsMap2 == 0) {
                sb.append("x,x,x,x#4-");
            } else {
                if ((rtsMap2 & 1) == 1) {
                    sb.append(8);
                } else {
                    sb.append("x");
                }
                sb.append(",");
                if ((rtsMap2 & 2) == 2) {
                    sb.append(1);
                } else {
                    sb.append("x");
                }
                sb.append(",");
                if ((rtsMap2 & 4) == 4) {
                    sb.append(6);
                } else {
                    sb.append("x");
                }
                sb.append(",");
                if ((rtsMap2 & 8) == 8) {
                    sb.append(9);
                } else {
                    sb.append("x");
                }
                sb.append("#4-");
            }
            if (dtrMap2 == 0) {
                sb.append("x,x,x,x#y#y");
            } else {
                if ((dtrMap2 & 1) == 1) {
                    sb.append(8);
                } else {
                    sb.append("x");
                }
                sb.append(",");
                if ((dtrMap2 & 2) == 2) {
                    sb.append(1);
                } else {
                    sb.append("x");
                }
                sb.append(",");
                if ((dtrMap2 & 4) == 4) {
                    sb.append(6);
                } else {
                    sb.append("x");
                }
                sb.append(",");
                if ((dtrMap2 & 8) == 8) {
                    sb.append(9);
                } else {
                    sb.append("x");
                }
                sb.append("#y#y");
            }
            Object object = this.lock;
            synchronized (object) {
                this.linuxVadaptOut.write(sb.toString().getBytes());
                nmdevs = this.getLastNullModemDevicePairNodes();
                int idx = Integer.parseInt(nmdevs[0].substring(12), 10);
                StringBuilder sb1 = new StringBuilder();
                sb1.append(nmdevs[0]);
                sb1.append(" <=> ");
                sb1.append(nmdevs[1]);
                this.nullModemDevList.put(idx, sb1.toString());
            }
        }
        return nmdevs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean destroyAllVirtualDevices() throws IOException {
        if (this.osType == 1) {
            Object object = this.lock;
            synchronized (object) {
                this.linuxVadaptOut.write("del#xxxxx#xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx".getBytes());
                this.loopBackDevList.clear();
                this.nullModemDevList.clear();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean destroyVirtualLoopBackDevice(String deviceNode) throws IOException {
        if (deviceNode == null || deviceNode.length() == 0) {
            throw new IllegalArgumentException("The deviceNode can not be null or 0 length !");
        }
        if (this.osType == 1) {
            int nodeNum = Integer.parseInt(deviceNode.substring(12), 10);
            Object object = this.lock;
            synchronized (object) {
                if (this.loopBackDevList.containsKey(nodeNum)) {
                    String cmd = "del#".concat(String.format("%05d", nodeNum));
                    cmd = cmd.concat("#xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx");
                    this.linuxVadaptOut.write(cmd.getBytes());
                    this.loopBackDevList.remove(nodeNum);
                    return true;
                }
            }
            throw new IllegalArgumentException("Given device node is not found in our records !");
        }
        return false;
    }

    public boolean destroyVirtualNullModemPair(String devNode1, String devNode2) throws IOException {
        if (devNode1 == null || devNode1.length() == 0 || devNode2 == null || devNode2.length() == 0) {
            throw new IllegalArgumentException("The devNode1/2 can not be null or 0 length string !");
        }
        if (devNode1.equals(devNode2)) {
            throw new IllegalArgumentException("The devNode1 can not be equal to devNode2 !");
        }
        if (this.osType == 1) {
            int idx = Integer.parseInt(devNode1.substring(12), 10);
            String pair = this.nullModemDevList.get(idx);
            if (pair == null) {
                throw new IllegalArgumentException("Given device nodes are not found in our records !");
            }
            if (pair.contains(devNode2)) {
                String cmd = "del#".concat(String.format("%05d", idx));
                cmd = cmd.concat("#xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx");
                this.linuxVadaptOut.write(cmd.getBytes());
                this.nullModemDevList.remove(idx);
                return true;
            }
            throw new IllegalArgumentException("Given devNode1 and devNode2 seems not to be a null modem pair !");
        }
        return false;
    }

    public String getLastLoopBackDeviceNode() throws IOException {
        byte[] data = new byte[64];
        byte[] tmp = new byte[5];
        if (this.osType == 1) {
            this.linuxVadaptIn.read(data);
            for (int q = 0; q < 5; ++q) {
                tmp[q] = data[q];
            }
            int nodeNum = Integer.parseInt(new String(tmp), 10);
            StringBuilder sb = new StringBuilder();
            sb.append("/dev/tty2com");
            sb.append(nodeNum);
            return sb.toString();
        }
        return null;
    }

    public String[] getLastNullModemDevicePairNodes() throws IOException {
        byte[] data = new byte[64];
        byte[] tmp1 = new byte[5];
        byte[] tmp2 = new byte[5];
        if (this.osType == 1) {
            int q;
            this.linuxVadaptIn.read(data);
            for (q = 0; q < 5; ++q) {
                tmp1[q] = data[q + 6];
            }
            for (q = 0; q < 5; ++q) {
                tmp2[q] = data[q + 12];
            }
            int nodeNum1 = Integer.parseInt(new String(tmp1), 10);
            int nodeNum2 = Integer.parseInt(new String(tmp2), 10);
            StringBuilder sb = new StringBuilder();
            sb.append("/dev/tty2com");
            sb.append(nodeNum1);
            String[] nodes = new String[2];
            nodes[0] = sb.toString();
            sb.delete(0, sb.length());
            sb.append("/dev/tty2com");
            sb.append(nodeNum2);
            nodes[1] = sb.toString();
            return nodes;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] listLoopBackDevices() {
        int x = 0;
        String[] list = null;
        Object object = this.lock;
        synchronized (object) {
            int msize = this.loopBackDevList.size();
            if (msize == 0) {
                return null;
            }
            list = new String[msize];
            for (Map.Entry<Integer, String> entry : this.loopBackDevList.entrySet()) {
                list[x] = entry.getValue();
                ++x;
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] listNullModemDevicePairs() {
        int x = 0;
        String[] list = null;
        Object object = this.lock;
        synchronized (object) {
            int msize = this.nullModemDevList.size();
            if (msize == 0) {
                return null;
            }
            list = new String[msize];
            for (Map.Entry<Integer, String> entry : this.nullModemDevList.entrySet()) {
                list[x] = entry.getValue();
                ++x;
            }
        }
        return list;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean emulateLineError(String devNode, int error) throws IOException {
        if (devNode == null) throw new IllegalArgumentException("The devNode can not be null or 0 length !");
        if (devNode.length() == 0) {
            throw new IllegalArgumentException("The devNode can not be null or 0 length !");
        }
        if (this.osType != 1) return true;
        StringBuilder sb = new StringBuilder();
        sb.append("/sys/devices/virtual/tty/");
        sb.append(devNode.substring(12));
        sb.append("/scmvtty_errevt/evt");
        try (FileOutputStream fout = new FileOutputStream(sb.toString());){
            if ((error & 0x10) == 16) {
                fout.write("1".getBytes());
                return true;
            }
            if ((error & 0x20) == 32) {
                fout.write("2".getBytes());
                return true;
            }
            if ((error & 0x40) == 64) {
                fout.write("3".getBytes());
                return true;
            }
            boolean bl = false;
            return bl;
        }
    }

    public boolean emulateLineRingingEvent(String devNode, boolean state) throws IOException {
        if (devNode == null || devNode.length() == 0) {
            throw new IllegalArgumentException("The devNode can not be null or 0 length !");
        }
        if (this.osType == 1) {
            StringBuilder sb = new StringBuilder();
            sb.append("/sys/devices/virtual/tty/");
            sb.append(devNode.substring(12));
            sb.append("/scmvtty_errevt/evt");
            try (FileOutputStream fout = new FileOutputStream(sb.toString());){
                if (state) {
                    fout.write("4".getBytes());
                } else {
                    fout.write("5".getBytes());
                }
            }
        }
        return true;
    }

    public boolean releaseResources() throws IOException {
        if (this.osType == 1) {
            try {
                this.linuxVadaptOut.close();
            }
            catch (IOException e) {
                this.linuxVadaptIn.close();
                throw e;
            }
            this.linuxVadaptIn.close();
        }
        return true;
    }
}

