/*
 * Decompiled with CFR 0.152.
 */
package com.embeddedunveiled.serial.usb;

import com.embeddedunveiled.serial.SerialComException;
import com.embeddedunveiled.serial.internal.SerialComPortJNIBridge;
import com.embeddedunveiled.serial.usb.SerialComUSBPowerInfo;

public final class SerialComUSB {
    public static final int V_ALL = 0;
    public static final int V_FTDI = 1027;
    public static final int V_SLABS = 4292;
    public static final int V_MCHIP = 1240;
    public static final int V_PL = 1659;
    public static final int V_EXAR = 1250;
    public static final int V_ATML = 1003;
    public static final int V_MOSCHP = 38672;
    public static final int V_CYPRS = 1204;
    public static final int V_TI = 1105;
    public static final int V_WCH = 17224;
    public static final int V_QHE = 6790;
    public static final int V_NXP = 8137;
    public static final int V_RNSAS = 1033;
    public static final int DEV_ANY = 0;
    public static final int DEV_ADDED = 1;
    public static final int DEV_REMOVED = 2;
    SerialComPortJNIBridge mComPortJNIBridge;

    public SerialComUSB(SerialComPortJNIBridge mComPortJNIBridge) {
        this.mComPortJNIBridge = mComPortJNIBridge;
    }

    public String[] getFirmwareRevisionNumber(int usbvid, int usbpid, String serialNumber) throws SerialComException {
        String[] bcdCodedRevNumber;
        if (usbvid < 0 || usbvid > 65535) {
            throw new IllegalArgumentException("Argument usbvid can not be negative or greater than 0xFFFF !");
        }
        if (usbpid < 0 || usbpid > 65535) {
            throw new IllegalArgumentException("Argument usbpid can not be negative or greater than 0xFFFF !");
        }
        String serial = null;
        if (serialNumber != null) {
            serial = serialNumber.trim().toLowerCase();
        }
        if ((bcdCodedRevNumber = this.mComPortJNIBridge.getFirmwareRevisionNumber(usbvid, usbpid, serial)) == null) {
            throw new SerialComException("Could not get the bcdDevice field of USB device descriptor. Please retry !");
        }
        String[] fwver = new String[bcdCodedRevNumber.length];
        for (int x = 0; x < bcdCodedRevNumber.length; ++x) {
            int firmwareRevisionNum = Integer.parseInt(bcdCodedRevNumber[x]);
            fwver[x] = String.format("%x.%02x", (firmwareRevisionNum & 0xFF00) >> 8, firmwareRevisionNum & 0xFF);
        }
        return fwver;
    }

    public SerialComUSBPowerInfo getCDCUSBDevPowerInfo(String comPort) throws SerialComException {
        if (comPort == null) {
            throw new IllegalArgumentException("Argument comPort can not be null !");
        }
        String portNameVal = comPort.trim();
        if (portNameVal.length() == 0) {
            throw new IllegalArgumentException("Argument comPort can not be empty string !");
        }
        String[] usbPowerInfo = this.mComPortJNIBridge.getCDCUSBDevPowerInfo(portNameVal);
        if (usbPowerInfo != null) {
            if (usbPowerInfo.length > 2) {
                return new SerialComUSBPowerInfo(usbPowerInfo[0], usbPowerInfo[1], usbPowerInfo[2], usbPowerInfo[3], usbPowerInfo[4], usbPowerInfo[5]);
            }
        } else {
            throw new SerialComException("Could not find USB devices. Please retry !");
        }
        return null;
    }

    public boolean rescanUSBDevicesHW() throws SerialComException {
        int ret = this.mComPortJNIBridge.rescanUSBDevicesHW();
        if (ret < 0) {
            throw new SerialComException("Could not cause re-scanning for hardware change. Please retry !");
        }
        return true;
    }

    public boolean setLatencyTimer(String comPort, byte timerValue) throws SerialComException {
        int ret = this.mComPortJNIBridge.setLatencyTimer(comPort, timerValue);
        if (ret < 0) {
            throw new SerialComException("Could not set the latency timer value. Please retry !");
        }
        return true;
    }

    public int getLatencyTimer(String comPort) throws SerialComException {
        int value = this.mComPortJNIBridge.getLatencyTimer(comPort);
        if (value < 0) {
            throw new SerialComException("Could not get the latency timer value. Please retry !");
        }
        return value;
    }
}

