/*
 * Decompiled with CFR 0.152.
 */
package com.embeddedunveiled.serial.usb;

import com.embeddedunveiled.serial.SerialComException;
import com.embeddedunveiled.serial.hid.SerialComHIDTransport;
import com.embeddedunveiled.serial.hid.SerialComHIDdevice;
import com.embeddedunveiled.serial.internal.SerialComHIDJNIBridge;

public final class SerialComUSBHID
extends SerialComHIDTransport {
    public SerialComUSBHID(SerialComHIDJNIBridge mHIDJNIBridge, int osType) {
        super(mHIDJNIBridge, osType);
    }

    public SerialComHIDdevice[] listUSBHIDdevicesWithInfo(int vendorFilter) throws SerialComException {
        int i = 0;
        int numOfDevices = 0;
        SerialComHIDdevice[] usbHidDevicesFound = null;
        if (vendorFilter < 0 || vendorFilter > 65535) {
            throw new IllegalArgumentException("Argument vendorFilter can not be negative or greater than 0xFFFF !");
        }
        String[] usbhidDevicesInfo = this.mHIDJNIBridge.listUSBHIDdevicesWithInfo(vendorFilter);
        if (usbhidDevicesInfo != null) {
            if (usbhidDevicesInfo.length <= 3) {
                return new SerialComHIDdevice[0];
            }
            numOfDevices = usbhidDevicesInfo.length / 8;
            usbHidDevicesFound = new SerialComHIDdevice[numOfDevices];
            for (int x = 0; x < numOfDevices; ++x) {
                usbHidDevicesFound[x] = new SerialComHIDdevice(usbhidDevicesInfo[i], usbhidDevicesInfo[i + 1], usbhidDevicesInfo[i + 2], usbhidDevicesInfo[i + 3], usbhidDevicesInfo[i + 4], usbhidDevicesInfo[i + 5], usbhidDevicesInfo[i + 6], usbhidDevicesInfo[i + 7]);
                i += 8;
            }
            return usbHidDevicesFound;
        }
        throw new SerialComException("Could not find USB HID devices. Please retry !");
    }

    public long openHidDeviceByUSBAttributes(int usbVidToMatch, int usbPidToMatch, String serialNumber, int locationID, int usbBusNumber, int usbDevNumber) throws SerialComException {
        long handle;
        if (usbVidToMatch < 0 || usbVidToMatch > 65535) {
            throw new IllegalArgumentException("Argument usbVidToMatch can not be negative or greater than 0xFFFF !");
        }
        if (usbPidToMatch < 0 || usbPidToMatch > 65535) {
            throw new IllegalArgumentException("Argument usbPidToMatch can not be negative or greater than 0xFFFF !");
        }
        String serialNum = null;
        if (serialNumber != null) {
            serialNum = serialNumber.toLowerCase();
        }
        if ((handle = this.mHIDJNIBridge.openHidDeviceByUSBAttributes(usbVidToMatch, usbPidToMatch, serialNum, locationID, usbBusNumber, usbDevNumber)) < 0L) {
            throw new SerialComException("Could not open the HID device by USB attributes. Please retry !");
        }
        return handle;
    }
}

