/*
 * Decompiled with CFR 0.152.
 */
package com.embeddedunveiled.serial.usb;

import com.embeddedunveiled.serial.util.SerialComUtil;

public final class SerialComUSBdevice {
    private final String idVendor;
    private final String idProduct;
    private final String serial;
    private final String product;
    private final String manufacturer;
    private final String location;

    public SerialComUSBdevice(String idVendor, String idProduct, String serial, String product, String manufacturer, String location) {
        this.idVendor = idVendor;
        this.idProduct = idProduct;
        this.serial = serial;
        this.product = product;
        this.manufacturer = manufacturer;
        this.location = location;
    }

    public int getVendorID() {
        if ("---".equals(this.idVendor)) {
            return 0;
        }
        return (int)SerialComUtil.hexStrToLongNumber(this.idVendor);
    }

    public int getProductID() {
        if ("---".equals(this.idProduct)) {
            return 0;
        }
        return (int)SerialComUtil.hexStrToLongNumber(this.idProduct);
    }

    public String getSerialNumber() {
        return this.serial;
    }

    public String getProductString() {
        return this.product;
    }

    public String getManufacturerString() {
        return this.manufacturer;
    }

    public String getLocation() {
        return this.location;
    }

    public void dumpDeviceInfo() {
        System.out.println("\nVendor id : 0x" + this.idVendor + "\nProduct id : 0x" + this.idProduct + "\nSerial number : " + this.serial + "\nProduct : " + this.product + "\nManufacturer : " + this.manufacturer + "\nLocation : " + this.location);
    }
}

