/*
 * Decompiled with CFR 0.152.
 */
package com.embeddedunveiled.serial.util;

import java.util.AbstractList;
import java.util.Collection;
import java.util.NoSuchElementException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public final class RingArrayBlockingQueue<E>
extends AbstractList<E>
implements BlockingQueue<E> {
    private final int DEFAULT_CAPACITY = 1024;
    private final int DEFAULT_EXPANSION_BY = 1024;
    private final int DEFAULT_MAX_CAPACITY = 4096;
    private final Lock enqueueLock = new ReentrantLock();
    private final Lock dequeueLock = new ReentrantLock();
    private final AtomicInteger totalElementsInQueue = new AtomicInteger(0);
    private final int capacity;
    private final int maxCapacity;
    private final int expandBy;
    private E[] buffer;
    private int tail = 0;
    private int head = 0;
    private int headUpdateStatus = 0;
    private int tailUpdateStatus = 0;
    private final Condition waitForElementToBeAvailableCond;

    public RingArrayBlockingQueue() {
        this.capacity = 1024;
        this.maxCapacity = 4096;
        this.expandBy = 1024;
        this.buffer = new Object[this.capacity];
        this.waitForElementToBeAvailableCond = this.dequeueLock.newCondition();
    }

    public RingArrayBlockingQueue(int maxCapacity) {
        if (maxCapacity <= 0) {
            throw new IllegalArgumentException("Argument maxCapacity can not be negative or zero !");
        }
        this.capacity = 1024;
        this.maxCapacity = maxCapacity;
        this.expandBy = 1024;
        this.buffer = new Object[this.capacity];
        this.waitForElementToBeAvailableCond = this.dequeueLock.newCondition();
    }

    public RingArrayBlockingQueue(int capacity, int expandBy, int maxCapacity) {
        if (capacity <= 0) {
            throw new IllegalArgumentException("capacity can not be negative or zero !");
        }
        if (maxCapacity <= 0) {
            throw new IllegalArgumentException("Argument maxCapacity can not be negative or zero !");
        }
        if (expandBy <= 0) {
            throw new IllegalArgumentException("Argument expandBy can not be negative or zero !");
        }
        this.capacity = capacity;
        this.maxCapacity = maxCapacity;
        this.expandBy = expandBy;
        this.buffer = new Object[capacity];
        this.waitForElementToBeAvailableCond = this.dequeueLock.newCondition();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean expandQueue() {
        int x = 0;
        int y = 0;
        int z = 0;
        if (this.buffer.length == this.maxCapacity) {
            return false;
        }
        this.enqueueLock.lock();
        this.dequeueLock.lock();
        int newLength = this.buffer.length + this.expandBy;
        if (newLength >= this.maxCapacity) {
            newLength = this.maxCapacity;
        }
        try {
            Object[] tmp = new Object[newLength];
            if (this.tail > this.head) {
                for (x = 0; x < this.buffer.length; ++x) {
                    tmp[x] = this.buffer[x];
                }
            } else {
                y = this.head;
                for (x = 0; x < this.buffer.length - this.head; ++x) {
                    tmp[x] = this.buffer[y];
                    ++y;
                }
                for (z = 0; z <= this.tail; ++z) {
                    tmp[x] = this.buffer[z];
                    ++x;
                }
            }
            this.buffer = tmp;
        }
        finally {
            this.dequeueLock.unlock();
            this.enqueueLock.unlock();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean insert(E e, long timeout, TimeUnit unit) throws InterruptedException {
        block62: {
            boolean elementAdded = false;
            int totalElementBeforeInsertion = 0;
            if (e == null) {
                throw new NullPointerException("Null elements may not be inserted in this queue !");
            }
            this.enqueueLock.lock();
            try {
                block61: {
                    totalElementBeforeInsertion = this.totalElementsInQueue.get();
                    if (this.buffer.length >= this.maxCapacity) {
                        if (totalElementBeforeInsertion >= this.maxCapacity) {
                            if (timeout == -1L) {
                                boolean bl = false;
                                return bl;
                            }
                            if (timeout == -2L) {
                                while (this.totalElementsInQueue.get() >= this.buffer.length) {
                                    Thread.sleep(200L);
                                }
                                if (this.tailUpdateStatus == -1) {
                                    this.tail = 0;
                                    this.tailUpdateStatus = 0;
                                } else if (this.tailUpdateStatus == -2) {
                                    ++this.tail;
                                    this.tailUpdateStatus = 0;
                                }
                                this.buffer[this.tail] = e;
                                this.totalElementsInQueue.incrementAndGet();
                                elementAdded = true;
                                if (totalElementBeforeInsertion + 1 >= this.buffer.length) {
                                    this.tailUpdateStatus = this.tail == this.buffer.length - 1 ? -1 : -2;
                                } else if (this.tail == this.buffer.length - 1) {
                                    this.tail = 0;
                                    this.tailUpdateStatus = 0;
                                } else {
                                    ++this.tail;
                                    this.tailUpdateStatus = 0;
                                }
                            } else {
                                block60: {
                                    Thread.sleep(unit.toMillis(timeout));
                                    if (this.totalElementsInQueue.get() < this.buffer.length) break block60;
                                    boolean ie = false;
                                    return ie;
                                }
                                if (this.tailUpdateStatus == -1) {
                                    this.tail = 0;
                                    this.tailUpdateStatus = 0;
                                } else if (this.tailUpdateStatus == -2) {
                                    ++this.tail;
                                    this.tailUpdateStatus = 0;
                                }
                                this.buffer[this.tail] = e;
                                this.totalElementsInQueue.incrementAndGet();
                                elementAdded = true;
                                if (totalElementBeforeInsertion + 1 >= this.buffer.length) {
                                    if (this.tail == this.buffer.length - 1) {
                                        this.tailUpdateStatus = -1;
                                    }
                                    this.tailUpdateStatus = -2;
                                }
                                if (this.tail == this.buffer.length - 1) {
                                    this.tail = 0;
                                    this.tailUpdateStatus = 0;
                                }
                                ++this.tail;
                                this.tailUpdateStatus = 0;
                            }
                        } else {
                            if (this.tailUpdateStatus == -1) {
                                this.tail = 0;
                                this.tailUpdateStatus = 0;
                            } else if (this.tailUpdateStatus == -2) {
                                ++this.tail;
                                this.tailUpdateStatus = 0;
                            }
                            this.buffer[this.tail] = e;
                            this.totalElementsInQueue.incrementAndGet();
                            elementAdded = true;
                            if (totalElementBeforeInsertion + 1 >= this.buffer.length) {
                                this.tailUpdateStatus = this.tail == this.buffer.length - 1 ? -1 : -2;
                            } else if (this.tail == this.buffer.length - 1) {
                                this.tail = 0;
                                this.tailUpdateStatus = 0;
                            } else {
                                ++this.tail;
                                this.tailUpdateStatus = 0;
                            }
                        }
                    } else {
                        if (totalElementBeforeInsertion >= this.buffer.length) {
                            int tmp = this.buffer.length;
                            this.dequeueLock.lock();
                            try {
                                if (this.expandQueue()) {
                                    this.buffer[tmp] = e;
                                    this.tail = tmp;
                                    this.totalElementsInQueue.incrementAndGet();
                                    elementAdded = true;
                                    if (totalElementBeforeInsertion + 1 >= this.buffer.length) {
                                        if (this.tail == this.buffer.length - 1) {
                                            this.tailUpdateStatus = -1;
                                        }
                                    } else if (this.tail == this.buffer.length - 1) {
                                        this.tail = 0;
                                        this.tailUpdateStatus = 0;
                                    } else {
                                        ++this.tail;
                                        this.tailUpdateStatus = 0;
                                    }
                                    break block61;
                                }
                                boolean bl = false;
                                return bl;
                            }
                            finally {
                                this.dequeueLock.unlock();
                            }
                        }
                        if (this.tailUpdateStatus == -1) {
                            this.tail = 0;
                            this.tailUpdateStatus = 0;
                        } else if (this.tailUpdateStatus == -2) {
                            ++this.tail;
                            this.tailUpdateStatus = 0;
                        }
                        this.buffer[this.tail] = e;
                        this.totalElementsInQueue.incrementAndGet();
                        elementAdded = true;
                        if (totalElementBeforeInsertion + 1 >= this.buffer.length) {
                            this.tailUpdateStatus = this.tail == this.buffer.length - 1 ? -1 : -2;
                        } else if (this.tail == this.buffer.length - 1) {
                            this.tail = 0;
                            this.tailUpdateStatus = 0;
                        } else {
                            ++this.tail;
                            this.tailUpdateStatus = 0;
                        }
                    }
                }
                if (!elementAdded) break block62;
                this.dequeueLock.lock();
                try {
                    this.waitForElementToBeAvailableCond.signalAll();
                }
                finally {
                    this.dequeueLock.unlock();
                }
            }
            finally {
                this.enqueueLock.unlock();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private E removeElement(long timeout, TimeUnit unit) throws InterruptedException {
        E element = null;
        int totalElementBeforeRemoval = 0;
        this.dequeueLock.lockInterruptibly();
        try {
            totalElementBeforeRemoval = this.totalElementsInQueue.get();
            if (totalElementBeforeRemoval == 0) {
                if (timeout == -1L) {
                    E e = null;
                    return e;
                }
                if (timeout == -2L) {
                    while (this.totalElementsInQueue.get() == 0) {
                        try {
                            this.waitForElementToBeAvailableCond.await();
                        }
                        catch (InterruptedException ie) {
                            this.waitForElementToBeAvailableCond.signal();
                            throw ie;
                        }
                    }
                } else {
                    long nanosTimeout = unit.toNanos(timeout);
                    while (this.totalElementsInQueue.get() == 0) {
                        if (nanosTimeout <= 0L) {
                            E e = null;
                            return e;
                        }
                        try {
                            if (nanosTimeout <= 0L) continue;
                            nanosTimeout = this.waitForElementToBeAvailableCond.awaitNanos(nanosTimeout);
                        }
                        catch (InterruptedException ie) {
                            this.waitForElementToBeAvailableCond.signal();
                            throw ie;
                        }
                    }
                }
            }
            if (this.headUpdateStatus == -1) {
                this.head = 0;
                this.headUpdateStatus = 0;
            } else if (this.headUpdateStatus == -2) {
                ++this.head;
                this.headUpdateStatus = 0;
            }
            element = this.buffer[this.head];
            this.buffer[this.head] = null;
            this.totalElementsInQueue.decrementAndGet();
            if (totalElementBeforeRemoval - 1 <= 0) {
                this.headUpdateStatus = this.head == this.buffer.length - 1 ? -1 : -2;
            } else if (this.head == this.buffer.length - 1) {
                this.head = 0;
                this.headUpdateStatus = 0;
            } else {
                ++this.head;
                this.headUpdateStatus = 0;
            }
            if (totalElementBeforeRemoval - 1 > 0) {
                this.waitForElementToBeAvailableCond.signalAll();
            }
        }
        finally {
            this.dequeueLock.unlock();
        }
        return element;
    }

    @Override
    public E poll() {
        E element = null;
        try {
            element = this.removeElement(-1L, null);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return element;
    }

    @Override
    public E poll(long timeout, TimeUnit unit) throws InterruptedException {
        return this.removeElement(timeout, unit);
    }

    @Override
    public E take() throws InterruptedException {
        return this.removeElement(-2L, null);
    }

    @Override
    public E remove() {
        E element = null;
        try {
            element = this.removeElement(-1L, null);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (element == null) {
            throw new NoSuchElementException();
        }
        return element;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E peek() {
        E element = null;
        this.dequeueLock.lock();
        try {
            if (this.totalElementsInQueue.get() > 0) {
                element = this.buffer[this.head];
            }
        }
        finally {
            this.dequeueLock.unlock();
        }
        return element;
    }

    @Override
    public E element() {
        E element = this.peek();
        if (element == null) {
            throw new NoSuchElementException();
        }
        return element;
    }

    @Override
    public E get(int index) {
        throw new UnsupportedOperationException("Use take() or poll() to get an element !");
    }

    @Override
    public boolean offer(E e) {
        boolean result = false;
        try {
            result = this.insert(e, -1L, null);
        }
        catch (Exception exp) {
            if (exp instanceof InterruptedException) {
                return false;
            }
            if (exp instanceof NullPointerException) {
                throw new NullPointerException();
            }
            if (exp instanceof ClassCastException) {
                throw (ClassCastException)exp;
            }
            if (exp instanceof IllegalArgumentException) {
                throw (IllegalArgumentException)exp;
            }
            return false;
        }
        return result;
    }

    @Override
    public boolean offer(E e, long timeout, TimeUnit unit) throws InterruptedException {
        return this.insert(e, timeout, unit);
    }

    @Override
    public boolean add(E e) {
        boolean result = false;
        try {
            result = this.insert(e, -1L, null);
        }
        catch (Exception exp) {
            exp.printStackTrace();
            if (exp instanceof InterruptedException) {
                throw new IllegalStateException();
            }
            if (exp instanceof NullPointerException) {
                throw new NullPointerException();
            }
            if (exp instanceof ClassCastException) {
                throw (ClassCastException)exp;
            }
            if (exp instanceof IllegalArgumentException) {
                throw (IllegalArgumentException)exp;
            }
            throw new IllegalStateException();
        }
        return result;
    }

    @Override
    public void put(E e) throws InterruptedException {
        try {
            this.insert(e, -2L, null);
        }
        catch (Exception exp) {
            if (exp instanceof InterruptedException) {
                throw new IllegalStateException();
            }
            if (exp instanceof NullPointerException) {
                throw new NullPointerException();
            }
            if (exp instanceof ClassCastException) {
                throw (ClassCastException)exp;
            }
            if (exp instanceof IllegalArgumentException) {
                throw (IllegalArgumentException)exp;
            }
            throw new IllegalStateException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int remainingCapacity() {
        int remainingSize = 0;
        this.enqueueLock.lock();
        this.dequeueLock.lock();
        try {
            remainingSize = this.buffer.length - this.totalElementsInQueue.get();
        }
        finally {
            this.dequeueLock.unlock();
            this.enqueueLock.unlock();
        }
        return remainingSize;
    }

    @Override
    public int size() {
        return this.totalElementsInQueue.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int drainTo(Collection<? super E> c) {
        int x = 0;
        int numElementsInQueueRightNow = 0;
        if (c == null) {
            throw new NullPointerException();
        }
        if (c == this) {
            throw new IllegalArgumentException();
        }
        this.dequeueLock.lock();
        this.enqueueLock.lock();
        try {
            numElementsInQueueRightNow = this.totalElementsInQueue.get();
            if (numElementsInQueueRightNow != 0) {
                x = this.headUpdateStatus == -1 ? 0 : (this.headUpdateStatus == -2 ? ++this.head : this.head);
                for (int y = 0; y < numElementsInQueueRightNow; ++y) {
                    c.add(this.buffer[x]);
                    this.buffer[x] = null;
                    if (++x != this.buffer.length) continue;
                    x = 0;
                }
            }
            this.totalElementsInQueue.set(0);
            this.head = 0;
            this.tail = 0;
            this.headUpdateStatus = 0;
            this.tailUpdateStatus = 0;
        }
        finally {
            this.enqueueLock.unlock();
            this.dequeueLock.unlock();
        }
        return numElementsInQueueRightNow;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int drainTo(Collection<? super E> c, int maxElements) {
        int x = 0;
        int numOfElementsToDrain = 0;
        int numElementsInQueueRightNow = 0;
        if (c == null) {
            throw new NullPointerException();
        }
        if (c == this) {
            throw new IllegalArgumentException();
        }
        this.dequeueLock.lock();
        this.enqueueLock.lock();
        try {
            numElementsInQueueRightNow = this.totalElementsInQueue.get();
            numOfElementsToDrain = numElementsInQueueRightNow > maxElements ? maxElements : numElementsInQueueRightNow;
            if (numElementsInQueueRightNow > 0) {
                x = this.headUpdateStatus == -1 ? 0 : (this.headUpdateStatus == -2 ? ++this.head : this.head);
                for (int y = 0; y < numOfElementsToDrain; ++y) {
                    c.add(this.buffer[x]);
                    this.buffer[x] = null;
                    if (++x != this.buffer.length) continue;
                    x = 0;
                }
            }
            this.totalElementsInQueue.set(0);
            this.head = 0;
            this.tail = 0;
            this.headUpdateStatus = 0;
            this.tailUpdateStatus = 0;
        }
        finally {
            this.enqueueLock.unlock();
            this.dequeueLock.unlock();
        }
        return numOfElementsToDrain;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        int x = 0;
        int numElementsInQueueRightNow = 0;
        this.dequeueLock.lock();
        this.enqueueLock.lock();
        try {
            numElementsInQueueRightNow = this.totalElementsInQueue.get();
            if (numElementsInQueueRightNow > 0) {
                x = this.headUpdateStatus == -1 ? 0 : (this.headUpdateStatus == -2 ? ++this.head : this.head);
                for (int y = 0; y < numElementsInQueueRightNow; ++y) {
                    this.buffer[x] = null;
                    if (++x != this.buffer.length) continue;
                    x = 0;
                }
            }
            this.totalElementsInQueue.set(0);
            this.head = 0;
            this.tail = 0;
            this.headUpdateStatus = 0;
            this.tailUpdateStatus = 0;
        }
        finally {
            this.enqueueLock.unlock();
            this.dequeueLock.unlock();
        }
    }

    @Override
    public boolean isEmpty() {
        return this.totalElementsInQueue.get() <= 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] toArray() {
        Object[] r;
        block6: {
            int x = 0;
            int z = 0;
            int numElementsInQueueRightNow = 0;
            r = null;
            this.dequeueLock.lock();
            this.enqueueLock.lock();
            try {
                numElementsInQueueRightNow = this.totalElementsInQueue.get();
                if (numElementsInQueueRightNow > 0) {
                    r = new Object[numElementsInQueueRightNow];
                    x = this.headUpdateStatus == -1 ? 0 : (this.headUpdateStatus == -2 ? ++this.head : this.head);
                    for (int y = 0; y < numElementsInQueueRightNow; ++y) {
                        r[z] = this.buffer[x];
                        if (++x == this.buffer.length) {
                            x = 0;
                        }
                        ++z;
                    }
                    break block6;
                }
                Object[] objectArray = new Object[]{};
                return objectArray;
            }
            finally {
                this.enqueueLock.unlock();
                this.dequeueLock.unlock();
            }
        }
        return r;
    }
}

