/*
 * Decompiled with CFR 0.152.
 */
package com.embeddedunveiled.serial.util;

public final class SerialComCRCUtil {
    private int[] crc8wire1Table = new int[]{0, 94, 188, 226, 97, 63, 221, 131, 194, 156, 126, 32, 163, 253, 31, 65, 157, 195, 33, 127, 252, 162, 64, 30, 95, 1, 227, 189, 62, 96, 130, 220, 35, 125, 159, 193, 66, 28, 254, 160, 225, 191, 93, 3, 128, 222, 60, 98, 190, 224, 2, 92, 223, 129, 99, 61, 124, 34, 192, 158, 29, 67, 161, 255, 70, 24, 250, 164, 39, 121, 155, 197, 132, 218, 56, 102, 229, 187, 89, 7, 219, 133, 103, 57, 186, 228, 6, 88, 25, 71, 165, 251, 120, 38, 196, 154, 101, 59, 217, 135, 4, 90, 184, 230, 167, 249, 27, 69, 198, 152, 122, 36, 248, 166, 68, 26, 153, 199, 37, 123, 58, 100, 134, 216, 91, 5, 231, 185, 140, 210, 48, 110, 237, 179, 81, 15, 78, 16, 242, 172, 47, 113, 147, 205, 17, 79, 173, 243, 112, 46, 204, 146, 211, 141, 111, 49, 178, 236, 14, 80, 175, 241, 19, 77, 206, 144, 114, 44, 109, 51, 209, 143, 12, 82, 176, 238, 50, 108, 142, 208, 83, 13, 239, 177, 240, 174, 76, 18, 145, 207, 45, 115, 202, 148, 118, 40, 171, 245, 23, 73, 8, 86, 180, 234, 105, 55, 213, 139, 87, 9, 235, 181, 54, 104, 138, 212, 149, 203, 41, 119, 244, 170, 72, 22, 233, 183, 85, 11, 136, 214, 52, 106, 43, 117, 151, 201, 74, 20, 246, 168, 116, 42, 200, 150, 21, 75, 169, 247, 182, 232, 10, 84, 215, 137, 107, 53};
    private int[] crc16Table = new int[]{0, 49345, 49537, 320, 49921, 960, 640, 49729, 50689, 1728, 1920, 51009, 1280, 50625, 50305, 1088, 52225, 3264, 3456, 52545, 3840, 53185, 52865, 3648, 2560, 51905, 52097, 2880, 51457, 2496, 2176, 51265, 55297, 6336, 6528, 55617, 6912, 56257, 55937, 6720, 7680, 57025, 57217, 8000, 56577, 7616, 7296, 56385, 5120, 54465, 54657, 5440, 55041, 6080, 5760, 54849, 53761, 4800, 4992, 54081, 4352, 53697, 53377, 4160, 61441, 12480, 12672, 61761, 13056, 62401, 62081, 12864, 13824, 63169, 63361, 14144, 62721, 13760, 13440, 62529, 15360, 64705, 64897, 15680, 65281, 16320, 16000, 65089, 64001, 15040, 15232, 64321, 14592, 63937, 63617, 14400, 10240, 59585, 59777, 10560, 60161, 11200, 10880, 59969, 60929, 11968, 12160, 61249, 11520, 60865, 60545, 11328, 58369, 9408, 9600, 58689, 9984, 59329, 59009, 9792, 8704, 58049, 58241, 9024, 57601, 8640, 8320, 57409, 40961, 24768, 24960, 41281, 25344, 41921, 41601, 25152, 26112, 42689, 42881, 26432, 42241, 26048, 25728, 42049, 27648, 44225, 44417, 27968, 44801, 28608, 28288, 44609, 43521, 27328, 27520, 43841, 26880, 43457, 43137, 26688, 30720, 47297, 47489, 31040, 47873, 31680, 31360, 47681, 48641, 32448, 32640, 48961, 32000, 48577, 48257, 31808, 46081, 29888, 30080, 46401, 30464, 47041, 46721, 30272, 29184, 45761, 45953, 29504, 45313, 29120, 28800, 45121, 20480, 37057, 37249, 20800, 37633, 21440, 21120, 37441, 38401, 22208, 22400, 38721, 21760, 38337, 38017, 21568, 39937, 23744, 23936, 40257, 24320, 40897, 40577, 24128, 23040, 39617, 39809, 23360, 39169, 22976, 22656, 38977, 34817, 18624, 18816, 35137, 19200, 35777, 35457, 19008, 19968, 36545, 36737, 20288, 36097, 19904, 19584, 35905, 17408, 33985, 34177, 17728, 34561, 18368, 18048, 34369, 33281, 17088, 17280, 33601, 16640, 33217, 32897, 16448};
    private int[] crc16ccittTable = new int[]{0, 4129, 8258, 12387, 16516, 20645, 24774, 28903, 33032, 37161, 41290, 45419, 49548, 53677, 57806, 61935, 4657, 528, 12915, 8786, 21173, 17044, 29431, 25302, 37689, 33560, 45947, 41818, 54205, 50076, 62463, 58334, 9314, 13379, 1056, 5121, 25830, 29895, 17572, 21637, 42346, 46411, 34088, 38153, 58862, 62927, 50604, 54669, 13907, 9842, 5649, 1584, 30423, 26358, 22165, 18100, 46939, 42874, 38681, 34616, 63455, 59390, 55197, 51132, 18628, 22757, 26758, 30887, 2112, 6241, 10242, 14371, 51660, 55789, 59790, 63919, 35144, 39273, 43274, 47403, 23285, 19156, 31415, 27286, 6769, 2640, 14899, 10770, 56317, 52188, 64447, 60318, 39801, 35672, 47931, 43802, 27814, 31879, 19684, 23749, 11298, 15363, 3168, 7233, 60846, 64911, 52716, 56781, 44330, 48395, 36200, 40265, 32407, 28342, 24277, 20212, 15891, 11826, 7761, 3696, 65439, 61374, 57309, 53244, 48923, 44858, 40793, 36728, 37256, 33193, 45514, 41451, 53516, 49453, 61774, 57711, 4224, 161, 12482, 8419, 20484, 16421, 28742, 24679, 33721, 37784, 41979, 46042, 49981, 54044, 58239, 62302, 689, 4752, 8947, 13010, 16949, 21012, 25207, 29270, 46570, 42443, 38312, 34185, 62830, 58703, 54572, 50445, 13538, 9411, 5280, 1153, 29798, 25671, 21540, 17413, 42971, 47098, 34713, 38840, 59231, 63358, 50973, 55100, 9939, 14066, 1681, 5808, 26199, 30326, 17941, 22068, 55628, 51565, 63758, 59695, 39368, 35305, 47498, 43435, 22596, 18533, 30726, 26663, 6336, 2273, 14466, 10403, 52093, 56156, 60223, 64286, 35833, 39896, 43963, 48026, 19061, 23124, 27191, 31254, 2801, 6864, 10931, 14994, 64814, 60687, 56684, 52557, 48554, 44427, 40424, 36297, 31782, 27655, 23652, 19525, 15522, 11395, 7392, 3265, 61215, 65342, 53085, 57212, 44955, 49082, 36825, 40952, 28183, 32310, 20053, 24180, 11923, 16050, 3793, 7920};
    private int[] crc16dnpTable = new int[]{0, 13918, 27836, 23266, 55672, 61222, 46532, 33690, 65417, 51671, 37685, 42347, 9969, 4271, 19021, 31763, 45675, 33845, 57047, 59529, 27411, 23885, 1967, 12785, 19938, 31676, 8542, 5888, 38042, 41668, 63526, 52856, 10671, 8177, 17683, 29517, 61655, 50825, 40043, 43573, 54822, 57464, 47770, 36036, 3934, 14592, 25570, 21948, 39876, 44442, 63352, 49446, 17084, 29922, 11776, 6238, 25677, 21011, 2289, 16047, 48437, 35691, 53641, 59351, 21342, 25856, 16354, 2492, 35366, 48248, 59034, 53444, 44247, 39561, 49259, 63029, 30127, 17393, 6419, 12109, 57653, 55147, 36233, 48087, 14413, 3603, 21745, 25263, 7868, 10466, 29184, 17502, 51140, 61850, 43896, 40230, 31473, 19631, 5709, 8211, 41865, 38359, 53045, 63851, 34168, 45862, 59844, 57242, 23552, 27230, 12476, 1762, 51354, 65220, 42022, 37496, 4578, 10172, 32094, 19200, 14099, 333, 23471, 28145, 61035, 55349, 33495, 46217, 42684, 37090, 51712, 64606, 32708, 18842, 4984, 9510, 22837, 28523, 13705, 983, 32845, 46611, 60657, 55983, 5335, 8841, 30827, 20021, 52655, 64497, 41235, 38733, 60254, 56576, 34786, 45500, 12838, 1144, 24218, 26820, 36627, 47437, 58287, 54769, 22123, 24629, 15063, 3209, 28826, 18116, 7206, 10872, 43490, 40892, 50526, 62208, 15736, 2854, 20932, 26522, 58368, 53854, 35004, 48866, 49905, 62639, 44621, 38931, 7049, 11735, 30517, 16747, 62946, 50108, 39262, 44800, 11418, 6852, 16422, 30328, 2667, 15413, 26327, 20617, 54035, 58701, 49071, 35313, 18313, 29143, 11061, 7531, 40689, 43183, 62029, 50195, 47104, 36446, 54460, 58082, 24952, 22310, 3524, 15258, 56397, 59923, 45297, 34479, 1333, 13163, 27017, 24535, 9156, 5530, 20344, 31014, 64188, 52450, 38400, 41054, 28198, 22648, 666, 13508, 46942, 33024, 56290, 60860, 37295, 42993, 64787, 52045, 18647, 32393, 9323, 4661};
    private int[] crc16ibmTable = new int[]{0, 49345, 49537, 320, 49921, 960, 640, 49729, 50689, 1728, 1920, 51009, 1280, 50625, 50305, 1088, 52225, 3264, 3456, 52545, 3840, 53185, 52865, 3648, 2560, 51905, 52097, 2880, 51457, 2496, 2176, 51265, 55297, 6336, 6528, 55617, 6912, 56257, 55937, 6720, 7680, 57025, 57217, 8000, 56577, 7616, 7296, 56385, 5120, 54465, 54657, 5440, 55041, 6080, 5760, 54849, 53761, 4800, 4992, 54081, 4352, 53697, 53377, 4160, 61441, 12480, 12672, 61761, 13056, 62401, 62081, 12864, 13824, 63169, 63361, 14144, 62721, 13760, 13440, 62529, 15360, 64705, 64897, 15680, 65281, 16320, 16000, 65089, 64001, 15040, 15232, 64321, 14592, 63937, 63617, 14400, 10240, 59585, 59777, 10560, 60161, 11200, 10880, 59969, 60929, 11968, 12160, 61249, 11520, 60865, 60545, 11328, 58369, 9408, 9600, 58689, 9984, 59329, 59009, 9792, 8704, 58049, 58241, 9024, 57601, 8640, 8320, 57409, 40961, 24768, 24960, 41281, 25344, 41921, 41601, 25152, 26112, 42689, 42881, 26432, 42241, 26048, 25728, 42049, 27648, 44225, 44417, 27968, 44801, 28608, 28288, 44609, 43521, 27328, 27520, 43841, 26880, 43457, 43137, 26688, 30720, 47297, 47489, 31040, 47873, 31680, 31360, 47681, 48641, 32448, 32640, 48961, 32000, 48577, 48257, 31808, 46081, 29888, 30080, 46401, 30464, 47041, 46721, 30272, 29184, 45761, 45953, 29504, 45313, 29120, 28800, 45121, 20480, 37057, 37249, 20800, 37633, 21440, 21120, 37441, 38401, 22208, 22400, 38721, 21760, 38337, 38017, 21568, 39937, 23744, 23936, 40257, 24320, 40897, 40577, 24128, 23040, 39617, 39809, 23360, 39169, 22976, 22656, 38977, 34817, 18624, 18816, 35137, 19200, 35777, 35457, 19008, 19968, 36545, 36737, 20288, 36097, 19904, 19584, 35905, 17408, 33985, 34177, 17728, 34561, 18368, 18048, 34369, 33281, 17088, 17280, 33601, 16640, 33217, 32897, 16448};

    public byte getChecksumValue(byte[] data, int start, int end) {
        int checksum = 0;
        for (int x = start; x <= end; ++x) {
            checksum += data[x];
        }
        return (byte)(checksum % 256);
    }

    public byte getLRCCheckSum(byte[] data, int offset, int length) {
        byte checkSum = 0;
        if (data == null) {
            throw new NullPointerException("Argument data can not be null !");
        }
        if (offset < 0 || length < 0 || length > data.length - offset) {
            throw new IndexOutOfBoundsException("Index violation detected !");
        }
        if (!(data instanceof byte[])) {
            throw new IllegalArgumentException("Argument data is not byte type array !");
        }
        for (int i = offset; i < offset + length; ++i) {
            checkSum = (byte)(checkSum ^ data[i]);
        }
        return checkSum;
    }

    public int getCRC8Dallas1WireValue(byte[] data, int start, int end) {
        int crcVal = 0;
        for (int x = start; x <= end; ++x) {
            crcVal = this.crc8wire1Table[crcVal ^ data[x]] & 0xFF;
        }
        return crcVal;
    }

    public int getCRC16Value(byte[] data, int start, int end) {
        int crcVal = 0;
        for (int x = start; x <= end; ++x) {
            crcVal = (this.crc16Table[(crcVal ^ data[x]) & 0xFF] ^ crcVal >> 8) & 0xFFFF;
        }
        return crcVal;
    }

    public int getCRC16CCITTValue(byte[] data, int start, int end) {
        int crcVal = 0;
        for (int x = start; x <= end; ++x) {
            crcVal = (this.crc16ccittTable[(crcVal >> 8 ^ data[x]) & 0xFF] ^ crcVal << 8) & 0xFFFF;
        }
        return crcVal;
    }

    public int getCRC16DNPValue(byte[] data, int start, int end) {
        int crcVal = 0;
        for (int x = start; x <= end; ++x) {
            crcVal = crcVal >> 8 ^ this.crc16dnpTable[(crcVal ^ data[x]) & 0xFF];
        }
        crcVal = ~crcVal & 0xFFFF;
        int b1 = crcVal & 0xFF;
        int b2 = crcVal >>> 8 & 0xFF;
        return (b1 << 8 | b2 << 0) & 0xFFFF;
    }

    public int getCRC16IBMValue(byte[] data, int start, int end) {
        int crcVal = 65535;
        for (int x = start; x <= end; ++x) {
            crcVal = (crcVal >> 8 ^ this.crc16ibmTable[(crcVal ^ data[x]) & 0xFF]) & 0xFFFF;
        }
        return crcVal;
    }
}

