/*
 * Decompiled with CFR 0.152.
 */
package com.embeddedunveiled.serial.util;

public final class SerialComUtil {
    private static final String HEXNUM = "0123456789ABCDEF";

    private static String toHexString(long num, char paddingChar, int min, int max) {
        StringBuffer sb = new StringBuffer(Long.toHexString(num));
        if (max < min) {
            return sb.toString();
        }
        while (sb.length() < max) {
            sb.insert(0, paddingChar);
        }
        return sb.substring(0, min);
    }

    public static String byteArrayToHexString(byte[] data, String separator) {
        if (data == null) {
            throw new IllegalArgumentException("Argument data can not be null !");
        }
        if (data.length > 0) {
            StringBuilder sBuilder = new StringBuilder(2 * data.length);
            if (separator != null) {
                for (byte b : data) {
                    sBuilder.append(HEXNUM.charAt((b & 0xF0) >> 4)).append(HEXNUM.charAt(b & 0xF));
                    sBuilder.append(separator);
                }
                sBuilder.deleteCharAt(sBuilder.length() - 1);
            } else {
                for (byte b : data) {
                    sBuilder.append(HEXNUM.charAt((b & 0xF0) >> 4)).append(HEXNUM.charAt(b & 0xF));
                }
            }
            return sBuilder.toString();
        }
        return new String();
    }

    public static byte[] hexStringToByteArray(String hexStringData) {
        int j = 0;
        if (hexStringData == null) {
            throw new IllegalArgumentException("Argument hexStringData can not be null !");
        }
        String hexStr = hexStringData.trim().replaceAll("0x", "");
        hexStr = hexStr.replaceAll("\\s+", "");
        byte[] data = new byte[hexStr.length() / 2];
        for (int i = 0; i <= hexStr.length() - 1; i += 2) {
            byte character;
            data[j] = character = (byte)Integer.parseInt(hexStr.substring(i, i + 2), 16);
            ++j;
        }
        return data;
    }

    public static String decodeBCD(short bcd) {
        return String.format("%x.%02x", (bcd & 0xFF00) >> 8, bcd & 0xFF);
    }

    public static int byteToUnsignedInt(byte data) {
        return 0xFF & data;
    }

    public static long byteToUnsignedLong(byte data) {
        return 0xFFL & (long)data;
    }

    public static byte lowByteFromShort(short data) {
        return (byte)data;
    }

    public static byte highBytefromShort(short data) {
        return (byte)(data >> 8);
    }

    public static int shortToUnsignedInt(short data) {
        return 0xFFFF & data;
    }

    public static long shortToUnsignedLong(short data) {
        return 0xFFFFL & (long)data;
    }

    public static byte[] shortToByteArray(short data) {
        byte[] result = new byte[]{(byte)(data & 0xFF), (byte)(data >>> 8 & 0xFF)};
        return result;
    }

    public static long intToUnsignedLong(int data) {
        return 0xFFFFFFFFFFFFFFFFL & (long)data;
    }

    public static byte[] intToByteArray(int data) {
        byte[] result = new byte[4];
        result[0] = (byte)(data & 0xFF);
        result[1] = (byte)(data >>> 8 & 0xFF);
        result[1] = (byte)(data >>> 16 & 0xFF);
        result[1] = (byte)(data >>> 24 & 0xFF);
        return result;
    }

    public static long hexStrToLongNumber(String hexNumStr) {
        return Long.parseLong(hexNumStr, 16);
    }

    public static String longToHexString(long num) {
        return SerialComUtil.toHexString(num, '0', 16, 16);
    }

    public static String intToHexString(int num) {
        return SerialComUtil.toHexString(SerialComUtil.intToUnsignedLong(num), '0', 8, 8);
    }

    public static String shortToHexString(short num) {
        return SerialComUtil.toHexString(SerialComUtil.shortToUnsignedLong(num), '0', 4, 4);
    }

    public static String byteToHexString(byte num) {
        return SerialComUtil.toHexString(SerialComUtil.byteToUnsignedLong(num), '0', 2, 2);
    }

    public static byte[] concat(byte[] dataA, byte[] dataB) {
        byte[] result = new byte[dataA.length + dataB.length];
        System.arraycopy(dataA, 0, result, 0, dataA.length);
        System.arraycopy(dataB, 0, result, dataA.length, dataB.length);
        return result;
    }
}

