/*
 * Decompiled with CFR 0.152.
 */
package com.embeddedunveiled.serial.vendor;

import com.embeddedunveiled.serial.SerialComException;
import com.embeddedunveiled.serial.SerialComLoadException;
import com.embeddedunveiled.serial.SerialComUnexpectedException;
import com.embeddedunveiled.serial.internal.SerialComFTDID2XXJNIBridge;
import com.embeddedunveiled.serial.internal.SerialComSystemProperty;
import com.embeddedunveiled.serial.vendor.FTOpenedDeviceInfo;
import com.embeddedunveiled.serial.vendor.FTdeviceInfo;
import com.embeddedunveiled.serial.vendor.FTdevicelistInfoNode;
import com.embeddedunveiled.serial.vendor.FTeeprom2232;
import com.embeddedunveiled.serial.vendor.FTeeprom2232H;
import com.embeddedunveiled.serial.vendor.FTeeprom232H;
import com.embeddedunveiled.serial.vendor.FTeeprom232R;
import com.embeddedunveiled.serial.vendor.FTeeprom4232H;
import com.embeddedunveiled.serial.vendor.FTeepromData;
import com.embeddedunveiled.serial.vendor.FTeepromHeader;
import com.embeddedunveiled.serial.vendor.FTeepromXseries;
import com.embeddedunveiled.serial.vendor.FTprogramData;
import com.embeddedunveiled.serial.vendor.SerialComVendorLib;
import java.io.File;
import java.io.FileNotFoundException;

public final class SerialComFTDID2XX
extends SerialComVendorLib {
    public static final int FT_DEVICE_UNKNOWN = 1;
    public static final int FT_DEVICE_AM = 2;
    public static final int FT_DEVICE_BM = 3;
    public static final int FT_DEVICE_100AX = 4;
    public static final int FT_DEVICE_232B = 5;
    public static final int FT_DEVICE_232R = 6;
    public static final int FT_DEVICE_232H = 7;
    public static final int FT_DEVICE_2232C = 8;
    public static final int FT_DEVICE_2232H = 9;
    public static final int FT_DEVICE_4232H = 16;
    public static final int FT_DEVICE_X_SERIES = 17;
    public static final int GENERIC_READ = 1;
    public static final int GENERIC_WRITE = 2;
    public static final int FT_LIST_NUMBER_ONLY = 1;
    public static final int FT_LIST_BY_INDEX = 2;
    public static final int FT_LIST_ALL = 4;
    public static final int FT_OPEN_BY_SERIAL_NUMBER = 8;
    public static final int FT_OPEN_BY_DESCRIPTION = 16;
    public static final int FT_OPEN_BY_LOCATION = 32;
    public static final int SETRTS = 1;
    public static final int CLRRTS = 2;
    public static final int SETDTR = 3;
    public static final int CLRDTR = 4;
    public static final int SETBREAK = 5;
    public static final int CLRBREAK = 6;
    public static final int MS_CTS_ON = 1;
    public static final int MS_DSR_ON = 2;
    public static final int MS_RING_ON = 4;
    public static final int MS_RLSD_ON = 8;
    public static final int EV_RXCHAR = 1;
    public static final int EV_RXFLAG = 2;
    public static final int EV_TXEMPTY = 4;
    public static final int EV_CTS = 8;
    public static final int EV_DSR = 16;
    public static final int EV_RLSD = 32;
    public static final int EV_BREAK = 64;
    public static final int EV_ERR = 128;
    public static final int EV_RING = 256;
    public static final int EV_PERR = 512;
    public static final int EV_RX80FULL = 1024;
    public static final int EV_EVENT1 = 2048;
    public static final int EV_EVENT2 = 4096;
    public static final int PURGE_TXABORT = 1;
    public static final int PURGE_RXABORT = 2;
    public static final int PURGE_TXCLEAR = 4;
    public static final int PURGE_RXCLEAR = 8;
    public static final int CE_RXOVER = 1;
    public static final int CE_OVERRUN = 2;
    public static final int CE_RXPARITY = 4;
    public static final int CE_FRAME = 8;
    public static final int CE_BREAK = 16;
    public static final int CE_TXFULL = 256;
    public static final int CE_PTO = 512;
    public static final int CE_IOE = 1024;
    public static final int CE_DNS = 2048;
    public static final int CE_OOP = 4096;
    public static final int CE_MODE = 32768;
    private final SerialComFTDID2XXJNIBridge mFTDID2XXJNIBridge = new SerialComFTDID2XXJNIBridge();

    public SerialComFTDID2XX(File libDirectory, String vlibName, int cpuArch, int osType, SerialComSystemProperty serialComSystemProperty) throws UnsatisfiedLinkError, SerialComLoadException, SerialComUnexpectedException, SecurityException, FileNotFoundException {
        SerialComFTDID2XXJNIBridge.loadNativeLibrary(libDirectory, vlibName, cpuArch, osType, serialComSystemProperty);
    }

    public boolean setVidPid(int vid, int pid) throws SerialComException {
        if (vid < 0 || vid > 65535) {
            throw new IllegalArgumentException("Argument vid can not be negative or greater tha 0xFFFF !");
        }
        if (pid < 0 || pid > 65535) {
            throw new IllegalArgumentException("Argument pid can not be negative or greater tha 0xFFFF !");
        }
        int ret = this.mFTDID2XXJNIBridge.setVidPid(vid, pid);
        if (ret < 0) {
            throw new SerialComException("Could not set the VID and PID combination. Please retry !");
        }
        return true;
    }

    public int[] getVidPid() throws SerialComException {
        int[] combination = null;
        combination = this.mFTDID2XXJNIBridge.getVidPid();
        if (combination == null) {
            throw new SerialComException("Could not get the VID and PID values. Please retry !");
        }
        return combination;
    }

    public int createDeviceInfoList() throws SerialComException {
        int ret = this.mFTDID2XXJNIBridge.createDeviceInfoList();
        if (ret < 0) {
            throw new SerialComException("Could not create device info list. Please retry !");
        }
        return ret;
    }

    public FTdevicelistInfoNode[] getDeviceInfoList(int numOfDevices) throws SerialComException {
        int i = 0;
        int numOfDev = 0;
        FTdevicelistInfoNode[] infoList = null;
        String[] rawDataList = null;
        if (numOfDevices <= 0) {
            throw new IllegalArgumentException("getDeviceInfoList(), Argument numOfDevices can not be negative or zero !");
        }
        rawDataList = this.mFTDID2XXJNIBridge.getDeviceInfoList(numOfDevices);
        if (rawDataList != null) {
            numOfDev = rawDataList.length / 7;
            infoList = new FTdevicelistInfoNode[numOfDev];
            for (int x = 0; x < numOfDev; ++x) {
                infoList[x] = new FTdevicelistInfoNode(rawDataList[i], rawDataList[i + 1], rawDataList[i + 2], rawDataList[i + 3], rawDataList[i + 4], rawDataList[i + 5], rawDataList[i + 6]);
                i += 7;
            }
            return infoList;
        }
        return new FTdevicelistInfoNode[0];
    }

    public FTdevicelistInfoNode getDeviceInfoDetail(int index) throws SerialComException {
        if (index < 0) {
            throw new IllegalArgumentException("getDeviceInfoDetail(), Argument index can not be zero !");
        }
        String[] rawData = this.mFTDID2XXJNIBridge.getDeviceInfoDetail(index);
        if (rawData != null) {
            return new FTdevicelistInfoNode(rawData[0], rawData[1], rawData[2], rawData[3], rawData[4], rawData[5], rawData[6]);
        }
        return null;
    }

    public FTdeviceInfo[] listDevices(int pvArg1, int dwFlags) throws SerialComException {
        int i = 0;
        int numOfDev = 0;
        FTdeviceInfo[] infoList = null;
        if (pvArg1 < 0 || dwFlags <= 0) {
            throw new IllegalArgumentException("listDevices(), Argument(s) are not as per specification !");
        }
        String[] rawDataList = this.mFTDID2XXJNIBridge.listDevices(pvArg1, dwFlags);
        if (rawDataList != null) {
            numOfDev = rawDataList.length / 3;
            infoList = new FTdeviceInfo[numOfDev];
            for (int x = 0; x < numOfDev; ++x) {
                infoList[x] = new FTdeviceInfo(rawDataList[i], rawDataList[i + 1], rawDataList[i + 2]);
                i += 3;
            }
            return infoList;
        }
        return new FTdeviceInfo[0];
    }

    public long open(int index) throws SerialComException {
        if (index < 0) {
            throw new IllegalArgumentException("Argument index can not be negative !");
        }
        long handle = this.mFTDID2XXJNIBridge.open(index);
        if (handle < 0L) {
            throw new SerialComException("Could not open the requested device at given index. Please retry !");
        }
        return handle;
    }

    public long openEx(String serialOrDescription, long locationId, int dwFlags) throws SerialComException {
        long ret = this.mFTDID2XXJNIBridge.openEx(serialOrDescription, locationId, dwFlags);
        if (ret < 0L) {
            throw new SerialComException("Could not open the requested device using given " + serialOrDescription + ". Please retry !");
        }
        return ret;
    }

    public boolean close(long handle) throws SerialComException {
        int ret = this.mFTDID2XXJNIBridge.close(handle);
        if (ret < 0) {
            throw new SerialComException("Could not close the requested device. Please retry !");
        }
        return true;
    }

    public int read(long handle, byte[] buffer, int numOfBytesToRead) throws SerialComException {
        if (buffer == null) {
            throw new IllegalArgumentException("Argument buffer can not be null !");
        }
        if (numOfBytesToRead <= 0) {
            throw new IllegalArgumentException("Argument numOfBytesToRead can not be negative or zero !");
        }
        int ret = this.mFTDID2XXJNIBridge.read(handle, buffer, numOfBytesToRead);
        if (ret < 0) {
            throw new SerialComException("Could not read the data from the requested device. Please retry !");
        }
        return ret;
    }

    public int write(long handle, byte[] buffer, int numOfBytesToWrite) throws SerialComException {
        if (buffer == null) {
            throw new IllegalArgumentException("Argument buffer can not be null !");
        }
        if (numOfBytesToWrite <= 0) {
            throw new IllegalArgumentException("Argument numOfBytesToWrite can not be negative or zero !");
        }
        int ret = this.mFTDID2XXJNIBridge.write(handle, buffer, numOfBytesToWrite);
        if (ret < 0) {
            throw new SerialComException("Could not send data to the requested device. Please retry !");
        }
        return ret;
    }

    public boolean setBaudRate(long handle, int baudRate) throws SerialComException {
        if (baudRate < 0) {
            throw new IllegalArgumentException("Argument baudRate can not be negative !");
        }
        int ret = this.mFTDID2XXJNIBridge.setBaudRate(handle, baudRate);
        if (ret < 0) {
            throw new SerialComException("Could not set the desired baud rate value for the requested device. Please retry !");
        }
        return true;
    }

    public boolean setDivisor(long handle, int divisor) throws SerialComException {
        if (divisor < 0) {
            throw new IllegalArgumentException("Argument divisor can not be negative !");
        }
        int ret = this.mFTDID2XXJNIBridge.setDivisor(handle, divisor);
        if (ret < 0) {
            throw new SerialComException("Could not set the desired divisor value for the requested device. Please retry !");
        }
        return true;
    }

    public boolean setDataCharacteristics(long handle, DATABITS dataBits, STOPBITS stopBits, PARITY parity) throws SerialComException {
        if (dataBits == null) {
            throw new IllegalArgumentException("Argument dataBits can not be null !");
        }
        if (stopBits == null) {
            throw new IllegalArgumentException("Argument stopBits can not be null !");
        }
        if (parity == null) {
            throw new IllegalArgumentException("Argument parity can not be null !");
        }
        int ret = this.mFTDID2XXJNIBridge.setDataCharacteristics(handle, dataBits.getValue(), stopBits.getValue(), parity.getValue());
        if (ret < 0) {
            throw new SerialComException("Could not set the desired data characteristics for the requested device. Please retry !");
        }
        return true;
    }

    public boolean setTimeouts(long handle, long readTimeOut, long writeTimeOut) throws SerialComException {
        if (readTimeOut < 0L) {
            throw new IllegalArgumentException("Argument readTimeOut can not be negative !");
        }
        if (writeTimeOut < 0L) {
            throw new IllegalArgumentException("Argument writeTimeOut can not be negative !");
        }
        int ret = this.mFTDID2XXJNIBridge.setTimeouts(handle, readTimeOut, writeTimeOut);
        if (ret < 0) {
            throw new SerialComException("Could not set the desired timeout values for the requested device. Please retry !");
        }
        return true;
    }

    public boolean setFlowControl(long handle, FLOWCTRL flctrl, char xon, char xoff) throws SerialComException {
        if (flctrl == null) {
            throw new IllegalArgumentException("Argument flctrl can not be null !");
        }
        char xonch = xon;
        char xoffch = xoff;
        int ret = this.mFTDID2XXJNIBridge.setFlowControl(handle, flctrl.getValue(), (byte)xonch, (byte)xoffch);
        if (ret < 0) {
            throw new SerialComException("Could not set the desired flow control values for the requested device. Please retry !");
        }
        return true;
    }

    public boolean setDTR(long handle) throws SerialComException {
        int ret = this.mFTDID2XXJNIBridge.setDTR(handle);
        if (ret < 0) {
            throw new SerialComException("Could not set the DTR signal for the requested device. Please retry !");
        }
        return true;
    }

    public boolean clearDTR(long handle) throws SerialComException {
        int ret = this.mFTDID2XXJNIBridge.clearDTR(handle);
        if (ret < 0) {
            throw new SerialComException("Could not clear the DTR signal for the requested device. Please retry !");
        }
        return true;
    }

    public boolean setRTS(long handle) throws SerialComException {
        int ret = this.mFTDID2XXJNIBridge.setRTS(handle);
        if (ret < 0) {
            throw new SerialComException("Could not set the RTS signal for the requested device. Please retry !");
        }
        return true;
    }

    public boolean clearRTS(long handle) throws SerialComException {
        int ret = this.mFTDID2XXJNIBridge.clearRTS(handle);
        if (ret < 0) {
            throw new SerialComException("Could not clear the RTS signal for the requested device. Please retry !");
        }
        return true;
    }

    public int getModemStatus(long handle) throws SerialComException {
        int ret = this.mFTDID2XXJNIBridge.getModemStatus(handle);
        if (ret < 0) {
            throw new SerialComException("Could not get the status of modem for the requested device. Please retry !");
        }
        return ret;
    }

    public int getQueueStatus(long handle) throws SerialComException {
        int ret = this.mFTDID2XXJNIBridge.getQueueStatus(handle);
        if (ret < 0) {
            throw new SerialComException("Could not get the number of bytes in receive queue for the requested device. Please retry !");
        }
        return ret;
    }

    public FTOpenedDeviceInfo getDeviceInfo(long handle) throws SerialComException {
        String[] rawData = this.mFTDID2XXJNIBridge.getDeviceInfo(handle);
        if (rawData != null) {
            return new FTOpenedDeviceInfo(rawData[0], rawData[1], rawData[2], rawData[3]);
        }
        return null;
    }

    public long getDriverVersion(long handle) throws SerialComException {
        long ret = this.mFTDID2XXJNIBridge.getDriverVersion(handle);
        if (ret < 0L) {
            throw new SerialComException("Could not get the driver version for the requested device. Please retry !");
        }
        return ret;
    }

    public long getLibraryVersion() throws SerialComException {
        long ret = this.mFTDID2XXJNIBridge.getLibraryVersion();
        if (ret < 0L) {
            throw new SerialComException("Could not get the d2xx library version for the requested device. Please retry !");
        }
        return ret;
    }

    public long getComPortNumber(long handle) throws SerialComException {
        long ret = this.mFTDID2XXJNIBridge.getComPortNumber(handle);
        if (ret < 0L) {
            throw new SerialComException("Could not determine the COM port number for the requested device. Please retry !");
        }
        return ret;
    }

    public long[] getStatus(long handle) throws SerialComException {
        long[] info = this.mFTDID2XXJNIBridge.getStatus(handle);
        if (info == null) {
            throw new SerialComException("Could not determine the required information for the requested device. Please retry !");
        }
        return info;
    }

    public boolean setEventNotificationAndWait(long handle, int eventMask) throws SerialComException {
        int eventsThatOccurredMask = this.mFTDID2XXJNIBridge.setEventNotificationAndWait(handle, eventMask);
        if (eventsThatOccurredMask < 0) {
            throw new SerialComException("Could not set the event notification and block. Please retry !");
        }
        return true;
    }

    public boolean setChars(long handle, char eventChar, char eventEnable, char errorChar, char errorEnable) throws SerialComException {
        char evch = eventChar;
        char even = eventEnable;
        char erch = errorChar;
        char eren = errorEnable;
        int ret = this.mFTDID2XXJNIBridge.setChars(handle, (byte)evch, (byte)even, (byte)erch, (byte)eren);
        if (ret < 0) {
            throw new SerialComException("Could not set the given characters for the requested device. Please retry !");
        }
        return true;
    }

    public boolean setBreakOn(long handle) throws SerialComException {
        int ret = this.mFTDID2XXJNIBridge.setBreakOn(handle);
        if (ret < 0) {
            throw new SerialComException("Could not set the break condition for the requested device. Please retry !");
        }
        return true;
    }

    public boolean setBreakOff(long handle) throws SerialComException {
        int ret = this.mFTDID2XXJNIBridge.setBreakOff(handle);
        if (ret < 0) {
            throw new SerialComException("Could not reset the break condition for the requested device. Please retry !");
        }
        return true;
    }

    public boolean purge(long handle, boolean purgeTxBuffer, boolean purgeRxBuffer) throws SerialComException {
        if (!purgeRxBuffer && !purgeTxBuffer) {
            throw new IllegalArgumentException("Both arguments purgeRxBuffer and purgeTxBuffer can not be false !");
        }
        int ret = this.mFTDID2XXJNIBridge.purge(handle, purgeTxBuffer, purgeRxBuffer);
        if (ret < 0) {
            throw new SerialComException("Could not purge the buffer(s) for the requested device. Please retry !");
        }
        return true;
    }

    public boolean resetDevice(long handle) throws SerialComException {
        int ret = this.mFTDID2XXJNIBridge.resetDevice(handle);
        if (ret < 0) {
            throw new SerialComException("Could not reset the requested device. Please retry !");
        }
        return true;
    }

    public boolean resetPort(long handle) throws SerialComException {
        int ret = this.mFTDID2XXJNIBridge.resetPort(handle);
        if (ret < 0) {
            throw new SerialComException("Could not reset the requested port. Please retry !");
        }
        return true;
    }

    public boolean cyclePort(long handle) throws SerialComException {
        int ret = this.mFTDID2XXJNIBridge.cyclePort(handle);
        if (ret < 0) {
            throw new SerialComException("Could not cycle the requested port. Please retry !");
        }
        return true;
    }

    public boolean rescan() throws SerialComException {
        int ret = this.mFTDID2XXJNIBridge.rescan();
        if (ret < 0) {
            throw new SerialComException("Could not rescan the system for usb devices. Please retry !");
        }
        return true;
    }

    public boolean reload(int vid, int pid) throws SerialComException {
        int ret = this.mFTDID2XXJNIBridge.reload(vid, pid);
        if (ret < 0) {
            throw new SerialComException("Could not cycle the requested port. Please retry !");
        }
        return true;
    }

    public boolean setResetPipeRetryCount(long handle, int count) throws SerialComException {
        int ret = this.mFTDID2XXJNIBridge.setResetPipeRetryCount(handle, count);
        if (ret < 0) {
            throw new SerialComException("Could not set the requested count for given device. Please retry !");
        }
        return true;
    }

    public boolean stopInTask(long handle) throws SerialComException {
        int ret = this.mFTDID2XXJNIBridge.stopInTask(handle);
        if (ret < 0) {
            throw new SerialComException("Could not stop the driver's IN task for given device. Please retry !");
        }
        return true;
    }

    public boolean restartInTask(long handle) throws SerialComException {
        int ret = this.mFTDID2XXJNIBridge.restartInTask(handle);
        if (ret < 0) {
            throw new SerialComException("Could not restart the driver's IN task for given device. Please retry !");
        }
        return true;
    }

    public boolean setDeadmanTimeout(long handle, int count) throws SerialComException {
        int ret = this.mFTDID2XXJNIBridge.setDeadmanTimeout(handle, count);
        if (ret < 0) {
            throw new SerialComException("Could not set the requested time out for given device. Please retry !");
        }
        return true;
    }

    public int readEE(long handle, int offset) throws SerialComException {
        if (offset < 0) {
            throw new IllegalArgumentException("Argument offset can not be negative !");
        }
        int ret = this.mFTDID2XXJNIBridge.readEE(handle, offset);
        if (ret < 0) {
            throw new SerialComException("Could not read the value from given address offset. Please retry !");
        }
        return ret;
    }

    public boolean writeEE(long handle, int offset, int valueToWrite) throws SerialComException {
        if (offset < 0) {
            throw new IllegalArgumentException("Argument offset can not be negative !");
        }
        int ret = this.mFTDID2XXJNIBridge.writeEE(handle, offset, valueToWrite);
        if (ret < 0) {
            throw new SerialComException("Could not read the value from given address offset. Please retry !");
        }
        return true;
    }

    public boolean eraseEE(long handle) throws SerialComException {
        int ret = this.mFTDID2XXJNIBridge.eraseEE(handle);
        if (ret < 0) {
            throw new SerialComException("Could not erase the EEPROM. Please retry !");
        }
        return true;
    }

    public FTprogramData eeRead(long handle, int version) throws SerialComException {
        char[] manufacturer = new char[32];
        char[] manufacturerID = new char[16];
        char[] description = new char[64];
        char[] serialNumber = new char[16];
        int[] info = this.mFTDID2XXJNIBridge.eeRead(handle, version, manufacturer, manufacturerID, description, serialNumber);
        if (info == null) {
            throw new SerialComException("Could not read the contents from EEPROM. Please retry !");
        }
        FTprogramData ftProgramData = new FTprogramData(info, manufacturer, manufacturerID, description, serialNumber);
        return ftProgramData;
    }

    public FTprogramData eeReadEx(long handle, int version, char[] manufacturer, char[] manufacturerID, char[] description, char[] serialNumber) throws SerialComException {
        if (manufacturer == null || manufacturerID == null || description == null || serialNumber == null) {
            throw new IllegalArgumentException("Arguments manufacturer, manufacturerID, description and serialNumber can not be null !");
        }
        if (manufacturer.length != 32) {
            throw new IllegalArgumentException("Argument manufacturer must be of 32 bytes in size !");
        }
        if (manufacturerID.length != 16) {
            throw new IllegalArgumentException("Argument manufacturerID must be of 16 bytes in size !");
        }
        if (description.length != 64) {
            throw new IllegalArgumentException("Argument manufacturer must be of 64 bytes in size !");
        }
        if (serialNumber.length != 16) {
            throw new IllegalArgumentException("Argument serialNumber must be of 16 bytes in size !");
        }
        int[] info = this.mFTDID2XXJNIBridge.eeRead(handle, version, manufacturer, manufacturerID, description, serialNumber);
        if (info == null) {
            throw new SerialComException("Could not read the contents from EEPROM. Please retry !");
        }
        FTprogramData ftProgramData = new FTprogramData(info, manufacturer, manufacturerID, description, serialNumber);
        return ftProgramData;
    }

    public boolean eeProgram(long handle, String manufacturer, String manufacturerID, String description, String serialNumber, int[] values) throws SerialComException {
        if (manufacturer == null || manufacturerID == null || description == null || serialNumber == null) {
            throw new IllegalArgumentException("Arguments manufacturer, manufacturerID, description and serialNumber can not be null !");
        }
        int ret = this.mFTDID2XXJNIBridge.eeProgram(handle, manufacturer, manufacturerID, description, serialNumber, values);
        if (ret < 0) {
            throw new SerialComException("Could not program the EEPROM. Please retry !");
        }
        return true;
    }

    public boolean eeProgramEx(long handle, String manufacturer, String manufacturerID, String description, String serialNumber, int[] values) throws SerialComException {
        if (manufacturer == null || manufacturerID == null || description == null || serialNumber == null) {
            throw new IllegalArgumentException("Arguments manufacturer, manufacturerID, description and serialNumber can not be null !");
        }
        int ret = this.mFTDID2XXJNIBridge.eeProgramEx(handle, manufacturer, manufacturerID, description, serialNumber, values);
        if (ret < 0) {
            throw new SerialComException("Could not program the EEPROM. Please retry !");
        }
        return true;
    }

    public int eeUAsize(long handle) throws SerialComException {
        int ret = this.mFTDID2XXJNIBridge.eeUAsize(handle);
        if (ret < 0) {
            throw new SerialComException("Could not determine the available size. Please retry !");
        }
        return ret;
    }

    public int eeUAread(long handle, byte[] buffer, int length) throws SerialComException {
        if (buffer == null) {
            throw new IllegalArgumentException("Argument buffer can not be null !");
        }
        if (length > buffer.length) {
            throw new IllegalArgumentException("Argument length must be less than or equal to length of buffer !");
        }
        int ret = this.mFTDID2XXJNIBridge.eeUAread(handle, buffer, length);
        if (ret < 0) {
            throw new SerialComException("Could not read the EEPROM. Please retry !");
        }
        return ret;
    }

    public boolean eeUAwrite(long handle, byte[] buffer, int length) throws SerialComException {
        if (buffer == null) {
            throw new IllegalArgumentException("Argument buffer can not be null !");
        }
        if (length > buffer.length) {
            throw new IllegalArgumentException("Argument length must be less than or equal to length of buffer !");
        }
        int ret = this.mFTDID2XXJNIBridge.eeUAwrite(handle, buffer, length);
        if (ret < 0) {
            throw new SerialComException("Could not write data to the EEPROM. Please retry !");
        }
        return true;
    }

    public FTeepromData eepromRead(long handle, int deviceType, char[] manufacturer, char[] manufacturerID, char[] description, char[] serialNumber) throws SerialComException {
        if (deviceType != 8 && deviceType != 9 && deviceType != 6 && deviceType != 7 && deviceType != 16 && deviceType != 17) {
            throw new IllegalArgumentException("Argument deviceType has invalid value !");
        }
        if (manufacturer == null || manufacturerID == null || description == null || serialNumber == null) {
            throw new IllegalArgumentException("Arguments manufacturer, manufacturerID, description and serialNumber can not be null !");
        }
        if (manufacturer.length != 32) {
            throw new IllegalArgumentException("Argument manufacturer must be of 32 bytes in size !");
        }
        if (manufacturerID.length != 16) {
            throw new IllegalArgumentException("Argument manufacturerID must be of 16 bytes in size !");
        }
        if (description.length != 64) {
            throw new IllegalArgumentException("Argument manufacturer must be of 64 bytes in size !");
        }
        if (serialNumber.length != 16) {
            throw new IllegalArgumentException("Argument serialNumber must be of 16 bytes in size !");
        }
        int[] dataValues = this.mFTDID2XXJNIBridge.eepromRead(handle, deviceType, manufacturer, manufacturerID, description, serialNumber);
        if (dataValues == null) {
            throw new SerialComException("Could not read the EEPROM data. Please retry !");
        }
        if (deviceType == 8) {
            return new FTeeprom2232(dataValues);
        }
        if (deviceType == 9) {
            return new FTeeprom2232H(dataValues);
        }
        if (deviceType == 6) {
            return new FTeeprom232R(dataValues);
        }
        if (deviceType == 7) {
            return new FTeeprom232H(dataValues);
        }
        if (deviceType == 16) {
            return new FTeeprom4232H(dataValues);
        }
        if (deviceType == 17) {
            return new FTeepromXseries(dataValues);
        }
        return null;
    }

    public boolean eepromProgram(long handle, FTeepromData eepromData, String manufacturer, String manufacturerID, String description, String serialNumber) throws SerialComException {
        FTeepromHeader dev;
        int[] dataToBeWritten = null;
        FTeepromHeader header = (FTeepromHeader)eepromData;
        int devType = header.getDeviceType();
        if (devType == 8) {
            if (!(eepromData instanceof FTeeprom2232)) {
                throw new IllegalArgumentException("For FT_DEVICE_2232C, argument eepromData must be an instance of FTeeprom2232 class !");
            }
            dev = (FTeeprom2232)eepromData;
            dataToBeWritten = ((FTeeprom2232)dev).getAllMembers();
        } else if (devType == 9) {
            if (!(eepromData instanceof FTeeprom2232H)) {
                throw new IllegalArgumentException("For FT_DEVICE_2232H, argument eepromData must be an instance of FTeeprom2232H class !");
            }
            dev = (FTeeprom2232H)eepromData;
            dataToBeWritten = ((FTeeprom2232H)dev).getAllMembers();
        } else if (devType == 6) {
            if (!(eepromData instanceof FTeeprom232R)) {
                throw new IllegalArgumentException("For FT_DEVICE_232R, argument eepromData must be an instance of FTeeprom232R class !");
            }
            dev = (FTeeprom232R)eepromData;
            dataToBeWritten = ((FTeeprom232R)dev).getAllMembers();
        } else if (devType == 7) {
            if (!(eepromData instanceof FTeeprom232H)) {
                throw new IllegalArgumentException("For FT_DEVICE_232H, argument eepromData must be an instance of FTeeprom232H class !");
            }
            dev = (FTeeprom232H)eepromData;
            dataToBeWritten = ((FTeeprom232H)dev).getAllMembers();
        } else if (devType == 16) {
            if (!(eepromData instanceof FTeeprom4232H)) {
                throw new IllegalArgumentException("For FT_DEVICE_4232H, argument eepromData must be an instance of FTeeprom4232H class !");
            }
            dev = (FTeeprom4232H)eepromData;
            dataToBeWritten = ((FTeeprom4232H)dev).getAllMembers();
        } else if (devType == 17) {
            if (!(eepromData instanceof FTeepromXseries)) {
                throw new IllegalArgumentException("For FT_DEVICE_X_SERIES, argument eepromData must be an instance of FTeepromXseries class !");
            }
            dev = (FTeepromXseries)eepromData;
            dataToBeWritten = ((FTeepromXseries)dev).getAllMembers();
        }
        int ret = this.mFTDID2XXJNIBridge.eepromProgram(handle, devType, dataToBeWritten, manufacturer, manufacturerID, description, serialNumber);
        if (ret < 0) {
            throw new SerialComException("Could not program the EEPROM. Please retry !");
        }
        return true;
    }

    public boolean setLatencyTimer(long handle, int value) throws SerialComException {
        int ret = this.mFTDID2XXJNIBridge.setLatencyTimer(handle, value);
        if (ret < 0) {
            throw new SerialComException("Could not set the latency timer value. Please retry !");
        }
        return true;
    }

    public int getLatencyTimer(long handle) throws SerialComException {
        int ret = this.mFTDID2XXJNIBridge.getLatencyTimer(handle);
        if (ret < 0) {
            throw new SerialComException("Could not determine the latency timer value. Please retry !");
        }
        return ret;
    }

    public boolean setBitMode(long handle, int mask, int mode) throws SerialComException {
        int ret = this.mFTDID2XXJNIBridge.setBitMode(handle, mask, mode);
        if (ret < 0) {
            throw new SerialComException("Could not set the given chip mode. Please retry !");
        }
        return true;
    }

    public int getBitMode(long handle) throws SerialComException {
        int ret = this.mFTDID2XXJNIBridge.getBitMode(handle);
        if (ret < 0) {
            throw new SerialComException("Could not get the given chip mode. Please retry !");
        }
        return ret;
    }

    public boolean setUSBParameters(long handle, int inTransferSize, int outTransferSize) throws SerialComException {
        if (outTransferSize < 0 || inTransferSize < 0) {
            throw new IllegalArgumentException("Argument inTransferSize or outTransferSize can not be negative !");
        }
        int ret = this.mFTDID2XXJNIBridge.setUSBParameters(handle, inTransferSize, outTransferSize);
        if (ret < 0) {
            throw new SerialComException("Could not set the usb parameters. Please retry !");
        }
        return true;
    }

    public long w32CreateFile(String serialNum, String description, long location, int dwAttrsAndFlags, int dwAccess, boolean overLapped) throws SerialComException {
        if ((dwAttrsAndFlags & 8) == 8 && serialNum == null) {
            throw new IllegalArgumentException("Argument serialNum can not be null for FT_OPEN_BY_SERIAL_NUMBER !");
        }
        if ((dwAttrsAndFlags & 0x10) == 16 && description == null) {
            throw new IllegalArgumentException("Argument description can not be null for FT_OPEN_BY_DESCRIPTION !");
        }
        if ((dwAttrsAndFlags & 0x20) == 32 && location < 0L) {
            throw new IllegalArgumentException("Argument location can not be negative for FT_OPEN_BY_LOCATION !");
        }
        long handle = this.mFTDID2XXJNIBridge.w32CreateFile(serialNum, description, location, dwAttrsAndFlags, dwAccess, overLapped);
        if (handle < 0L) {
            throw new SerialComException("Could not open the requested device. Please retry !");
        }
        return handle;
    }

    public boolean w32CloseHandle(long handle) throws SerialComException {
        int ret = this.mFTDID2XXJNIBridge.w32CloseHandle(handle);
        if (ret < 0) {
            throw new SerialComException("Could not close the requested device. Please retry !");
        }
        return true;
    }

    public int w32ReadFile(long handle, byte[] buffer, int numOfBytesToRead) throws SerialComException {
        if (buffer == null) {
            throw new IllegalArgumentException("Argument buffer can not be null !");
        }
        if (numOfBytesToRead <= 0) {
            throw new IllegalArgumentException("Argument numOfBytesToRead can not be negative or zero !");
        }
        int ret = this.mFTDID2XXJNIBridge.w32ReadFile(handle, buffer, numOfBytesToRead);
        if (ret < 0) {
            throw new SerialComException("Could not read the data from the requested device. Please retry !");
        }
        return ret;
    }

    public int w32WriteFile(long handle, byte[] buffer, int numOfBytesToWrite) throws SerialComException {
        if (buffer == null) {
            throw new IllegalArgumentException("Argument buffer can not be null !");
        }
        if (numOfBytesToWrite <= 0) {
            throw new IllegalArgumentException("Argument numOfBytesToWrite can not be negative or zero !");
        }
        int ret = this.mFTDID2XXJNIBridge.w32WriteFile(handle, buffer, numOfBytesToWrite);
        if (ret < 0) {
            throw new SerialComException("Could not send data to the requested device. Please retry !");
        }
        return ret;
    }

    public boolean w32GetOverlappedResult(long handle, boolean wait) throws SerialComException {
        return false;
    }

    public boolean w32EscapeCommFunction(long handle, short function) throws SerialComException {
        int ret = this.mFTDID2XXJNIBridge.w32EscapeCommFunction(handle, function);
        if (ret < 0) {
            throw new SerialComException("Requested operation could not be executed successfully. Please retry !");
        }
        return true;
    }

    public int w32GetCommModemStatus(long handle) throws SerialComException {
        int ret = this.mFTDID2XXJNIBridge.w32GetCommModemStatus(handle);
        if (ret < 0) {
            throw new SerialComException("Could not get the modem status. Please retry !");
        }
        return ret;
    }

    public boolean w32SetupComm(long handle, int readBufSize, int writeBufSize) throws SerialComException {
        int ret = this.mFTDID2XXJNIBridge.w32SetupComm(handle, readBufSize, writeBufSize);
        if (ret < 0) {
            throw new SerialComException("Could not set the buffer size. Please retry !");
        }
        return true;
    }

    public boolean w32SetCommState(long handle, int[] dcb) throws SerialComException {
        int ret = this.mFTDID2XXJNIBridge.w32SetCommState(handle, dcb);
        if (ret < 0) {
            throw new SerialComException("Could not set the given settings values. Please retry !");
        }
        return true;
    }

    public int[] w32GetCommState(long handle) throws SerialComException {
        int[] ret = this.mFTDID2XXJNIBridge.w32GetCommState(handle);
        if (ret == null) {
            throw new SerialComException("Could not get the current state. Please retry !");
        }
        return ret;
    }

    public boolean w32SetCommTimeouts(long handle, int readIntervalTimeout, int readTotalTimeoutMultiplier, int readTotalTimeoutConstant, int writeTotalTimeoutMultiplier, int writeTotalTimeoutConstant) throws SerialComException {
        int ret = this.mFTDID2XXJNIBridge.w32SetCommTimeouts(handle, readIntervalTimeout, readTotalTimeoutMultiplier, readTotalTimeoutConstant, writeTotalTimeoutMultiplier, writeTotalTimeoutConstant);
        if (ret < 0) {
            throw new SerialComException("Could not set the given timeouts. Please retry !");
        }
        return true;
    }

    public int[] w32GetCommTimeouts(long handle) throws SerialComException {
        int[] ret = this.mFTDID2XXJNIBridge.w32GetCommTimeouts(handle);
        if (ret == null) {
            throw new SerialComException("Could not get the timeout values. Please retry !");
        }
        return ret;
    }

    public boolean w32SetCommBreak(long handle) throws SerialComException {
        int ret = this.mFTDID2XXJNIBridge.w32SetCommBreak(handle);
        if (ret < 0) {
            throw new SerialComException("Could not put the communications line in the BREAK state. Please retry !");
        }
        return true;
    }

    public boolean w32ClearCommBreak(long handle) throws SerialComException {
        int ret = this.mFTDID2XXJNIBridge.w32ClearCommBreak(handle);
        if (ret < 0) {
            throw new SerialComException("Could not put the communications line in non-BREAK state. Please retry !");
        }
        return true;
    }

    public boolean w32SetCommMask(long handle, int flag) throws SerialComException {
        int ret = this.mFTDID2XXJNIBridge.w32SetCommMask(handle, flag);
        if (ret < 0) {
            throw new SerialComException("Could not set the communication mask. Please retry !");
        }
        return true;
    }

    public int w32GetCommMask(long handle) throws SerialComException {
        int ret = this.mFTDID2XXJNIBridge.w32GetCommMask(handle);
        if (ret < 0) {
            throw new SerialComException("Could not get the communication mask. Please retry !");
        }
        return ret;
    }

    public boolean w32WaitCommEvent(long handle, int event) throws SerialComException {
        int ret = this.mFTDID2XXJNIBridge.w32WaitCommEvent(handle, event);
        if (ret < 0) {
            throw new SerialComException("Could not wait for event specified. Please retry !");
        }
        return true;
    }

    public boolean w32PurgeComm(long handle, int event) throws SerialComException {
        int ret = this.mFTDID2XXJNIBridge.w32PurgeComm(handle, event);
        if (ret < 0) {
            throw new SerialComException("Could not purge the port as specified. Please retry !");
        }
        return true;
    }

    public String w32GetLastError(long handle) throws SerialComException {
        String ret = this.mFTDID2XXJNIBridge.w32GetLastError(handle);
        if (ret == null) {
            throw new SerialComException("Could not get the last error. Please retry !");
        }
        return ret;
    }

    public int[] w32ClearCommError(long handle) throws SerialComException {
        int[] ret = this.mFTDID2XXJNIBridge.w32ClearCommError(handle);
        if (ret == null) {
            throw new SerialComException("Could not get the error and status information. Please retry !");
        }
        return ret;
    }

    public static enum FLOWCTRL {
        FT_FLOW_NONE(1),
        FT_FLOW_RTS_CTS(2),
        FT_FLOW_DTR_DSR(3),
        FT_FLOW_XON_XOFF(4);

        private int value;

        private FLOWCTRL(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum PARITY {
        FT_PARITY_NONE(1),
        FT_PARITY_ODD(2),
        FT_PARITY_EVEN(3),
        FT_PARITY_MARK(4),
        FT_PARITY_SPACE(5);

        private int value;

        private PARITY(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum STOPBITS {
        FT_STOP_BITS_1(1),
        FT_STOP_BITS_2(2);

        private int value;

        private STOPBITS(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum DATABITS {
        FT_BITS_7(7),
        FT_BITS_8(8);

        private int value;

        private DATABITS(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

